/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cmp;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.AlgorithmIdentifier;

public class PBMParameter
extends ASN1Encodable {
    private ASN1OctetString salt;
    private AlgorithmIdentifier owf;
    private DERInteger iterationCount;
    private AlgorithmIdentifier mac;

    private PBMParameter(ASN1Sequence seq) {
        this.salt = ASN1OctetString.getInstance((Object)seq.getObjectAt(0));
        this.owf = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
        this.iterationCount = DERInteger.getInstance((Object)seq.getObjectAt(2));
        this.mac = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(3));
    }

    public static PBMParameter getInstance(Object o) {
        if (o instanceof PBMParameter) {
            return (PBMParameter)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new PBMParameter((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public DERInteger getIterationCount() {
        return this.iterationCount;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.salt);
        v.add((DEREncodable)this.owf);
        v.add((DEREncodable)this.iterationCount);
        v.add((DEREncodable)this.mac);
        return new DERSequence((DEREncodableVector)v);
    }
}

