/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.crmf;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.GeneralName;

public class CertId
extends ASN1Encodable {
    private GeneralName issuer;
    private DERInteger serialNumber;

    private CertId(ASN1Sequence seq) {
        this.issuer = GeneralName.getInstance((Object)seq.getObjectAt(0));
        this.serialNumber = DERInteger.getInstance((Object)seq.getObjectAt(1));
    }

    public static CertId getInstance(Object o) {
        if (o instanceof CertId) {
            return (CertId)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new CertId((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public static CertId getInstance(ASN1TaggedObject obj, boolean isExplicit) {
        return CertId.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)isExplicit));
    }

    public GeneralName getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.issuer);
        v.add((DEREncodable)this.serialNumber);
        return new DERSequence((DEREncodableVector)v);
    }
}

