/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.crmf;

import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.crmf.OptionalValidity;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.asn1.x509.X509Name;

public class CertTemplate
extends ASN1Encodable {
    private DERInteger version;
    private DERInteger serialNumber;
    private AlgorithmIdentifier signingAlg;
    private X509Name issuer;
    private OptionalValidity validity;
    private X509Name subject;
    private SubjectPublicKeyInfo publicKey;
    private DERBitString issuerUID;
    private DERBitString subjectUID;
    private X509Extensions extensions;

    private CertTemplate(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        block12: while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            switch (tObj.getTagNo()) {
                case 0: {
                    this.version = DERInteger.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 1: {
                    this.serialNumber = DERInteger.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 2: {
                    this.signingAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 3: {
                    this.issuer = X509Name.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 4: {
                    this.validity = OptionalValidity.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)false));
                    continue block12;
                }
                case 5: {
                    this.subject = X509Name.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 6: {
                    this.publicKey = SubjectPublicKeyInfo.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 7: {
                    this.issuerUID = DERBitString.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 8: {
                    this.subjectUID = DERBitString.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
                case 9: {
                    this.extensions = X509Extensions.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("unknown tag: " + tObj.getTagNo());
        }
    }

    public static CertTemplate getInstance(Object o) {
        if (o instanceof CertTemplate) {
            return (CertTemplate)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new CertTemplate((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addOptional(v, 0, (ASN1Encodable)this.version);
        this.addOptional(v, 1, (ASN1Encodable)this.serialNumber);
        this.addOptional(v, 2, (ASN1Encodable)this.signingAlg);
        this.addOptional(v, 3, (ASN1Encodable)this.issuer);
        this.addOptional(v, 4, this.validity);
        this.addOptional(v, 5, (ASN1Encodable)this.subject);
        this.addOptional(v, 6, (ASN1Encodable)this.publicKey);
        this.addOptional(v, 7, (ASN1Encodable)this.issuerUID);
        this.addOptional(v, 8, (ASN1Encodable)this.subjectUID);
        this.addOptional(v, 9, (ASN1Encodable)this.extensions);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)new DERTaggedObject(false, tagNo, (DEREncodable)obj));
        }
    }
}

