/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.crmf;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERBitString;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.x509.AlgorithmIdentifier;

public class EncryptedValue
extends ASN1Encodable {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private DERBitString encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private ASN1OctetString valueHint;
    private DERBitString encValue;

    private EncryptedValue(ASN1Sequence seq) {
        int index = 0;
        while (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(index);
            switch (tObj.getTagNo()) {
                case 0: {
                    this.intendedAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    break;
                }
                case 1: {
                    this.symmAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    break;
                }
                case 2: {
                    this.encSymmKey = DERBitString.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    break;
                }
                case 3: {
                    this.keyAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    break;
                }
                case 4: {
                    this.valueHint = ASN1OctetString.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                }
            }
            ++index;
        }
        this.encValue = DERBitString.getInstance((Object)seq.getObjectAt(index));
    }

    public static EncryptedValue getInstance(Object o) {
        if (o instanceof EncryptedValue) {
            return (EncryptedValue)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new EncryptedValue((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addOptional(v, 0, (ASN1Encodable)this.intendedAlg);
        this.addOptional(v, 1, (ASN1Encodable)this.symmAlg);
        this.addOptional(v, 2, (ASN1Encodable)this.encSymmKey);
        this.addOptional(v, 3, (ASN1Encodable)this.keyAlg);
        this.addOptional(v, 4, (ASN1Encodable)this.valueHint);
        v.add((DEREncodable)this.encValue);
        return new DERSequence((DEREncodableVector)v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((DEREncodable)new DERTaggedObject(false, tagNo, (DEREncodable)obj));
        }
    }
}

