/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.ess;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.x509.IssuerSerial;

public class ESSCertID
extends ASN1Encodable {
    private ASN1OctetString certHash;
    private IssuerSerial issuerSerial;

    public static ESSCertID getInstance(Object o) {
        if (o == null || o instanceof ESSCertID) {
            return (ESSCertID)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new ESSCertID((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'ESSCertID' factory : " + o.getClass().getName() + ".");
    }

    public ESSCertID(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.certHash = ASN1OctetString.getInstance((Object)seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.issuerSerial = IssuerSerial.getInstance((Object)seq.getObjectAt(1));
        }
    }

    public ESSCertID(byte[] hash) {
        this.certHash = new DEROctetString(hash);
    }

    public ESSCertID(byte[] hash, IssuerSerial issuerSerial) {
        this.certHash = new DEROctetString(hash);
        this.issuerSerial = issuerSerial;
    }

    public byte[] getCertHash() {
        return this.certHash.getOctets();
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certHash);
        if (this.issuerSerial != null) {
            v.add((DEREncodable)this.issuerSerial);
        }
        return new DERSequence((DEREncodableVector)v);
    }
}

