/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.ess;

import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.nist.NISTObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.IssuerSerial;

public class ESSCertIDv2
extends ASN1Encodable {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certHash;
    private IssuerSerial issuerSerial;
    private static final AlgorithmIdentifier DEFAULT_ALG_ID = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (DEREncodable)DERNull.INSTANCE);

    public static ESSCertIDv2 getInstance(Object o) {
        if (o == null || o instanceof ESSCertIDv2) {
            return (ESSCertIDv2)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new ESSCertIDv2((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'ESSCertIDv2' factory : " + o.getClass().getName() + ".");
    }

    public ESSCertIDv2(ASN1Sequence seq) {
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int count = 0;
        this.hashAlgorithm = seq.getObjectAt(0) instanceof ASN1OctetString ? DEFAULT_ALG_ID : AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(count++).getDERObject());
        this.certHash = ASN1OctetString.getInstance((Object)seq.getObjectAt(count++).getDERObject()).getOctets();
        if (seq.size() > count) {
            this.issuerSerial = new IssuerSerial(ASN1Sequence.getInstance((Object)seq.getObjectAt(count).getDERObject()));
        }
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash) {
        this(algId, certHash, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash, IssuerSerial issuerSerial) {
        this.hashAlgorithm = algId == null ? DEFAULT_ALG_ID : algId;
        this.certHash = certHash;
        this.issuerSerial = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (!this.hashAlgorithm.equals((Object)DEFAULT_ALG_ID)) {
            v.add((DEREncodable)this.hashAlgorithm);
        }
        v.add((DEREncodable)new DEROctetString(this.certHash).toASN1Object());
        if (this.issuerSerial != null) {
            v.add((DEREncodable)this.issuerSerial);
        }
        return new DERSequence((DEREncodableVector)v);
    }
}

