/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.tsp;

import java.io.IOException;
import java.util.Enumeration;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DERBoolean;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREncodableVector;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERTaggedObject;
import kz.gamma.asn1.tsp.Accuracy;
import kz.gamma.asn1.tsp.MessageImprint;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.X509Extensions;

public class TSTInfo
extends ASN1Encodable {
    DERInteger version;
    DERObjectIdentifier tsaPolicyId;
    MessageImprint messageImprint;
    DERInteger serialNumber;
    DERGeneralizedTime genTime;
    Accuracy accuracy;
    DERBoolean ordering;
    DERInteger nonce;
    GeneralName tsa;
    X509Extensions extensions;

    public static TSTInfo getInstance(Object o) {
        if (o == null || o instanceof TSTInfo) {
            return (TSTInfo)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new TSTInfo((ASN1Sequence)o);
        }
        if (o instanceof ASN1OctetString) {
            try {
                return TSTInfo.getInstance(new ASN1InputStream(((ASN1OctetString)o).getOctets()).readObject());
            }
            catch (IOException ioEx) {
                throw new IllegalArgumentException("Bad object format in 'TSTInfo' factory.");
            }
        }
        throw new IllegalArgumentException("Unknown object in 'TSTInfo' factory : " + o.getClass().getName() + ".");
    }

    public TSTInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = DERInteger.getInstance(e.nextElement());
        this.tsaPolicyId = DERObjectIdentifier.getInstance(e.nextElement());
        this.messageImprint = MessageImprint.getInstance(e.nextElement());
        this.serialNumber = DERInteger.getInstance(e.nextElement());
        this.genTime = DERGeneralizedTime.getInstance(e.nextElement());
        this.ordering = new DERBoolean(false);
        while (e.hasMoreElements()) {
            DERObject o = (DERObject)e.nextElement();
            if (o instanceof ASN1TaggedObject) {
                DERTaggedObject tagged = (DERTaggedObject)o;
                switch (tagged.getTagNo()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.extensions = X509Extensions.getInstance((ASN1TaggedObject)tagged, (boolean)false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown tag value " + tagged.getTagNo());
                    }
                }
                continue;
            }
            if (o instanceof DERSequence) {
                this.accuracy = Accuracy.getInstance(o);
                continue;
            }
            if (o instanceof DERBoolean) {
                this.ordering = DERBoolean.getInstance((Object)o);
                continue;
            }
            if (!(o instanceof DERInteger)) continue;
            this.nonce = DERInteger.getInstance((Object)o);
        }
    }

    public TSTInfo(DERObjectIdentifier tsaPolicyId, MessageImprint messageImprint, DERInteger serialNumber, DERGeneralizedTime genTime, Accuracy accuracy, DERBoolean ordering, DERInteger nonce, GeneralName tsa, X509Extensions extensions) {
        this.version = new DERInteger(1);
        this.tsaPolicyId = tsaPolicyId;
        this.messageImprint = messageImprint;
        this.serialNumber = serialNumber;
        this.genTime = genTime;
        this.accuracy = accuracy;
        this.ordering = ordering;
        this.nonce = nonce;
        this.tsa = tsa;
        this.extensions = extensions;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public DERObjectIdentifier getPolicy() {
        return this.tsaPolicyId;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public DERGeneralizedTime getGenTime() {
        return this.genTime;
    }

    public DERBoolean getOrdering() {
        return this.ordering;
    }

    public DERInteger getNonce() {
        return this.nonce;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        seq.add((DEREncodable)this.version);
        seq.add((DEREncodable)this.tsaPolicyId);
        seq.add((DEREncodable)this.messageImprint);
        seq.add((DEREncodable)this.serialNumber);
        seq.add((DEREncodable)this.genTime);
        if (this.accuracy != null) {
            seq.add((DEREncodable)this.accuracy);
        }
        if (this.ordering != null && this.ordering.isTrue()) {
            seq.add((DEREncodable)this.ordering);
        }
        if (this.nonce != null) {
            seq.add((DEREncodable)this.nonce);
        }
        if (this.tsa != null) {
            seq.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.tsa));
        }
        if (this.extensions != null) {
            seq.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.extensions));
        }
        return new DERSequence((DEREncodableVector)seq);
    }
}

