/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Enumeration;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DERBMPString;
import kz.gamma.asn1.DERBoolean;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.core.utils.EndiannessUtils;

public class MSTemplate {
    private static EndiannessUtils endiannessUtils = new EndiannessUtils();

    public static ASN1Set getASN1Template(String name) throws IOException {
        String stringCp1251 = new String(name.getBytes(), "Cp1251");
        byte[] unicode = stringCp1251.getBytes("Unicode");
        byte[] unicodeWithoutBOM = null;
        try {
            ByteOrder byteOrder = endiannessUtils.getEndianness(unicode);
            if (byteOrder.equals(ByteOrder.BIG_ENDIAN) || byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) {
                unicodeWithoutBOM = new byte[unicode.length - 2];
                System.arraycopy(unicode, 2, unicodeWithoutBOM, 0, unicode.length - 2);
            }
        }
        catch (RuntimeException re) {
            unicodeWithoutBOM = unicode;
        }
        byte[] resultBytes = new byte[unicodeWithoutBOM.length];
        if (unicodeWithoutBOM[0] != 0) {
            resultBytes = endiannessUtils.changeEndianness(unicodeWithoutBOM);
        } else {
            System.arraycopy(unicodeWithoutBOM, 0, resultBytes, 0, unicodeWithoutBOM.length);
        }
        DERBMPString str = new DERBMPString(resultBytes);
        BERConstructedOctetString ASNocts = new BERConstructedOctetString(str.getEncoded());
        DERBoolean ASNtrue = new DERBoolean(true);
        ASN1EncodableVector vectTemp = new ASN1EncodableVector();
        vectTemp.add(PKCSObjectIdentifiers.MS_ENROLL_CERTTYPE_EXTENSION);
        vectTemp.add(ASNtrue);
        vectTemp.add(ASNocts);
        DERSequence seqTemplate = new DERSequence(vectTemp);
        ASN1EncodableVector vecSeqTemplate = new ASN1EncodableVector();
        vecSeqTemplate.add(seqTemplate);
        DERSequence seqvecSeqTemplate = new DERSequence(vecSeqTemplate);
        DERSet setSeqTemplate = new DERSet(seqvecSeqTemplate);
        ASN1EncodableVector vect1 = new ASN1EncodableVector();
        vect1.add(PKCSObjectIdentifiers.MS_CERT_EXTENSIONS_OBJID);
        vect1.add(setSeqTemplate);
        DERSequence qz = new DERSequence(vect1);
        return new DERSet(qz);
    }

    public static String getTemplateName(ASN1Set attributes) throws UnsupportedEncodingException {
        Enumeration enumeration = attributes.getObjects();
        while (enumeration.hasMoreElements()) {
            DERSequence seq1 = (DERSequence)enumeration.nextElement();
            if (!seq1.getObjectAt(0).toString().equals("1.3.6.1.4.1.311.2.1.14")) continue;
            DERSet set2 = (DERSet)seq1.getObjectAt(1);
            DERSequence seq3 = (DERSequence)set2.getObjectAt(0);
            DERSequence seq4 = (DERSequence)seq3.getObjectAt(0);
            DEROctetString dos5 = (DEROctetString)seq4.getObjectAt(seq4.size() - 1);
            byte[] bytesWithPrefix = dos5.getOctets();
            if (bytesWithPrefix[0] == 30) {
                byte[] bytes = new byte[bytesWithPrefix.length - 2];
                System.arraycopy(bytesWithPrefix, 2, bytes, 0, bytes.length);
                byte[] result = new byte[bytes.length + 2];
                if (bytes[0] == 0) {
                    result[0] = -2;
                    result[1] = -1;
                } else {
                    result[0] = -1;
                    result[1] = -2;
                }
                System.arraycopy(bytes, 0, result, 2, bytes.length);
                return new String(result, "Unicode");
            }
            return new String(bytesWithPrefix);
        }
        return null;
    }
}

