/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.asn1.cms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.DERUTF8String;
import kz.gamma.asn1.x509.X509Name;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSProcessableByteArray;
import kz.gamma.cms.CMSSignedData;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.cms.Pkcs7Data;
import kz.gamma.cms.SignerInformation;
import kz.gamma.cms.SignerInformationStore;
import kz.gamma.core.convertors.CharacterEncodingConvertor;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.CertificateFieldsResolver;

public class RevokeRequest {
    private String dnIssuer = null;
    private byte[] snSubject = null;
    private String dnSubject = null;
    private DERGeneralizedTime time = null;
    private int revReason = 0;
    private byte[] tbsRequest = null;
    private X509Certificate sigCert = null;
    private CharacterEncodingConvertor characterEncodingConvertor = new CharacterEncodingConvertor();
    private static CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();

    public RevokeRequest(byte[] revokeRequest) {
        try {
            CMSSignedData signedData = new CMSSignedData(revokeRequest);
            CertStore store1 = signedData.getCertificatesAndCRLs("Collection", GammaTechProvider.PROVIDER_NAME);
            SignerInformationStore sis = signedData.getSignerInfos();
            Collection signedColl = sis.getSigners();
            for (SignerInformation sinfo1 : signedColl) {
                Collection<? extends Certificate> cl = store1.getCertificates(sinfo1.getSID());
                Iterator<? extends Certificate> itr = cl.iterator();
                this.sigCert = (X509Certificate)itr.next();
            }
            byte[] content = (byte[])signedData.getSignedContent().getContent();
            ASN1InputStream in = new ASN1InputStream(content);
            DERSequence reqTBS = (DERSequence)in.readObject();
            this.tbsRequest = reqTBS.getDEREncoded();
            DERSequence reqv = (DERSequence)((DERSequence)reqTBS.getObjectAt(0)).getObjectAt(1);
            if (((DERObjectIdentifier)reqv.getObjectAt(1)).getId().toString().equals("1.3.6.1.5.5.7.7.17")) {
                DERSet set = (DERSet)reqv.getObjectAt(2);
                ASN1Sequence asn1Sequence = (ASN1Sequence)((ASN1Sequence)set.getObjectAt(0)).getObjectAt(0);
                X509Name x509Name = new X509Name(asn1Sequence);
                this.dnIssuer = x509Name.toString();
                BigInteger bigInteger = ((DERInteger)((DERSequence)set.getObjectAt(0)).getObjectAt(1)).getValue();
                this.snSubject = (byte[])certificateFieldsResolver.getSerialNumber(bigInteger, (Integer)1);
                this.revReason = ((DEREnumerated)((DERSequence)set.getObjectAt(0)).getObjectAt(2)).getValue().intValue();
                this.time = (DERGeneralizedTime)((DERSequence)set.getObjectAt(0)).getObjectAt(3);
                DEROctetString oct = (DEROctetString)((DERSequence)set.getObjectAt(0)).getObjectAt(4);
                this.dnSubject = new String(oct.getOctets(), "windows-1251");
                this.dnSubject = this.characterEncodingConvertor.convert(this.dnSubject, CharacterEncodingConvertor.rusChars, CharacterEncodingConvertor.kazChars);
            }
        }
        catch (Exception e) {
            System.out.println("Request not supported. Message: " + e.getLocalizedMessage());
        }
    }

    public RevokeRequest(String dnIssuer, byte[] snSubject, String dnSubject, int revReason, DERGeneralizedTime time) {
        this.dnIssuer = dnIssuer;
        this.snSubject = snSubject;
        this.dnSubject = dnSubject;
        this.revReason = revReason;
        this.time = time;
        try {
            this.tbsRequest = this.getTBSRequest();
        }
        catch (UnsupportedEncodingException e) {
            this.tbsRequest = null;
        }
    }

    public RevokeRequest(X509Certificate revCert, int revReason, DERGeneralizedTime time) throws UnsupportedEncodingException {
        this(revCert.getIssuerDN().getName(), (byte[])certificateFieldsResolver.getSerialNumber(revCert, (Integer)1), ((Object)revCert.getSubjectDN()).toString(), revReason, time);
    }

    public RevokeRequest(X509Certificate revCert, int revReason, Date time) throws UnsupportedEncodingException {
        this(revCert, revReason, new DERGeneralizedTime(time));
    }

    public RevokeRequest(X509Certificate revCert, int revReason) throws UnsupportedEncodingException {
        this(revCert, revReason, new Date());
    }

    public byte[] getTBSRequest() throws UnsupportedEncodingException {
        if (this.tbsRequest == null) {
            ASN1EncodableVector seq1 = new ASN1EncodableVector();
            ASN1EncodableVector seq2 = new ASN1EncodableVector();
            ASN1EncodableVector seq5 = new ASN1EncodableVector();
            seq5.add(new X509Name(this.dnIssuer));
            seq5.add(new DERInteger(this.snSubject));
            seq5.add(new DEREnumerated(this.revReason));
            seq5.add(this.time);
            String str = this.dnSubject;
            str = str.replaceAll(",", ";");
            str = str.replaceAll("GIVENNAME", "G");
            str = str.replaceAll("SERIALNUMBER", "SN") + ";";
            str = this.characterEncodingConvertor.convert(str, CharacterEncodingConvertor.kazChars, CharacterEncodingConvertor.rusChars);
            BERConstructedOctetString oct = new BERConstructedOctetString(str.getBytes("windows-1251"));
            seq5.add(oct);
            seq5.add(new DERUTF8String(" "));
            byte[] ret = null;
            ASN1EncodableVector seq3 = new ASN1EncodableVector();
            seq3.add(new DERInteger(1));
            seq3.add(new DERObjectIdentifier("1.3.6.1.5.5.7.7.5"));
            seq3.add(new DERSet(new DERInteger(new DERGeneralizedTime(new Date()).getDEREncoded())));
            ASN1EncodableVector seq4 = new ASN1EncodableVector();
            seq4.add(new DERInteger(2));
            seq4.add(new DERObjectIdentifier("1.3.6.1.5.5.7.7.17"));
            ASN1EncodableVector seq6 = new ASN1EncodableVector();
            seq6.add(new DERSequence(seq5));
            seq4.add(new DERSet(seq6));
            seq2.add(new DERSequence(seq3));
            seq2.add(new DERSequence(seq4));
            seq1.add(new DERSequence(seq2));
            seq1.add(new DERSequence());
            seq1.add(new DERSequence());
            seq1.add(new DERSequence());
            ret = new DERSequence(seq1).getDEREncoded();
            return ret;
        }
        return this.tbsRequest;
    }

    public byte[] getSignedRequest(PrivateKey key, X509Certificate cert) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, CertStoreException, CMSException, IOException {
        CMSSignedData signedData = null;
        if (cert == null) {
            throw new NullPointerException("Certificate cannot be null");
        }
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        if (cert.getSigAlgName().equals("ECGOST34310")) {
            gen.addSigner(key, cert, CMSSignedDataGenerator.DIGEST_GOST3411G);
        } else if (cert.getSigAlgName().equals("RSA")) {
            gen.addSigner(key, cert, CMSSignedDataGenerator.DIGEST_SHA1);
        } else {
            throw new RuntimeException("Bad signature algorithm name: \"" + cert.getSigAlgName() + "\"");
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(cert);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(list), GammaTechProvider.PROVIDER_NAME);
        gen.addCertificatesAndCRLs(store);
        CMSProcessableByteArray content = new CMSProcessableByteArray(this.getTBSRequest());
        signedData = gen.generate("1.3.6.1.5.5.7.12.2", content, true, GammaTechProvider.PROVIDER_NAME);
        return signedData.getEncoded();
    }

    public boolean verifyRevSignRequest(byte[] signedRequest) throws IOException, CMSException {
        CMSSignedData signedData = new CMSSignedData(signedRequest);
        Pkcs7Data sgnData = new Pkcs7Data(signedData.getEncoded());
        return sgnData.verify();
    }

    public int getRevokeReason() {
        return this.revReason;
    }

    public X509Certificate getSignCertificate() {
        return this.sigCert;
    }

    public byte[] getCertificateSN() {
        return this.snSubject;
    }

    public String getCertificateDN() {
        return this.dnSubject;
    }

    @Deprecated
    public String getrevokeDate() {
        return this.time.getTime();
    }

    public String getRevokeDate() {
        return this.time.getTime();
    }

    public String getDnIssuer() {
        return this.dnIssuer;
    }
}

