/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.cms.CMSObjectIdentifiers;
import kz.gamma.asn1.cms.CompressedData;
import kz.gamma.asn1.cms.ContentInfo;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.cms.CMSCompressedData;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSProcessable;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid));
    }

    public CMSCompressedData generate(CMSProcessable content, String compressionOID) throws CMSException {
        BERConstructedOctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DeflaterOutputStream zOut = new DeflaterOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = this.makeAlgId(compressionOID, null);
            comOcts = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new CMSException("exception encoding data.", e);
        }
        ContentInfo comContent = new ContentInfo(CMSObjectIdentifiers.data, comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }
}

