/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.BERConstructedOctetString;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.cms.ContentInfo;
import kz.gamma.asn1.cms.EncryptedContentInfo;
import kz.gamma.asn1.cms.EnvelopedData;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.cms.CMSEnvelopedData;
import kz.gamma.cms.CMSEnvelopedGenerator;
import kz.gamma.cms.CMSEnvelopedHelper;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSProcessable;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, KeyGenerator keyGen, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString encContent;
        AlgorithmIdentifier encAlgId;
        SecretKey encKey;
        String encProviderName = keyGen.getProvider().getName();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        try {
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(encryptionOID, encProviderName);
            encKey = keyGen.generateKey();
            AlgorithmParameters params = this.generateParameters(encryptionOID, encKey, encProviderName);
            cipher.init(1, (Key)encKey, params);
            if (params == null) {
                params = cipher.getParameters();
            }
            encAlgId = this.getAlgorithmIdentifier(encryptionOID, params);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            CipherOutputStream cOut = new CipherOutputStream(bOut, cipher);
            content.write(cOut);
            cOut.close();
            encContent = new BERConstructedOctetString(bOut.toByteArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
        for (CMSEnvelopedGenerator.RecipientInf recipient : this.recipientInfs) {
            try {
                recipientInfos.add(recipient.toRecipientInfo(encKey, provider));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.data, encAlgId, encContent);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(recipientInfos), eci, null));
        return new CMSEnvelopedData(contentInfo);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        return this.generate(content, encryptionOID, keyGen, provider);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(keySize);
        return this.generate(content, encryptionOID, keyGen, provider);
    }
}

