/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.BEROctetStringGenerator;
import kz.gamma.asn1.BERSequenceGenerator;
import kz.gamma.asn1.BERTaggedObject;
import kz.gamma.asn1.DERInteger;
import kz.gamma.asn1.DERNull;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DEROutputStream;
import kz.gamma.asn1.DERSet;
import kz.gamma.asn1.cms.AttributeTable;
import kz.gamma.asn1.cms.CMSObjectIdentifiers;
import kz.gamma.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.asn1.cms.SignerIdentifier;
import kz.gamma.asn1.cms.SignerInfo;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.TBSCertificateStructure;
import kz.gamma.cms.CMSAttributeTableGenerator;
import kz.gamma.cms.CMSSignedGenerator;
import kz.gamma.cms.CMSSignedHelper;
import kz.gamma.cms.CMSUtils;
import kz.gamma.cms.DefaultSignedAttributeTableGenerator;
import kz.gamma.cms.SignerInformation;
import kz.gamma.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        String encOID = this.getEncOID(key, digestOID);
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(digestOID);
        String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(encOID);
        Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
        MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
        sig.initSign(key);
        this._signerInfs.add(new SignerInf(key, cert, digestOID, encOID, signedAttrGenerator, unsignedAttrGenerator, dig, sig));
        this._messageDigests.add(dig);
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(out, DATA, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(out, DATA, encapsulate, dataOutputStream);
    }

    public OutputStream open(OutputStream out, String signedContentType, boolean encapsulate) throws IOException {
        return this.open(out, signedContentType, encapsulate, null);
    }

    public OutputStream open(OutputStream out, String signedContentType, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        OutputStream digStream;
        AlgorithmIdentifier digAlgId;
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(signedContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (Object signer : this._signers) {
            digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            digestAlgs.add(digAlgId);
        }
        for (Object signer : this._signerInfs) {
            digAlgId = this.makeAlgId(((SignerInf)signer).getDigestAlgOID(), ((SignerInf)signer).getDigestAlgParams());
            digestAlgs.add(digAlgId);
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(new DERObjectIdentifier(signedContentType));
        if (encapsulate) {
            BEROctetStringGenerator octGen = new BEROctetStringGenerator(eiGen.getRawOutputStream(), 0, true);
            digStream = this._bufferSize != 0 ? octGen.getOctetOutputStream(new byte[this._bufferSize]) : octGen.getOctetOutputStream();
            if (dataOutputStream != null) {
                digStream = new TeeOutputStream(dataOutputStream, digStream);
            }
        } else {
            digStream = dataOutputStream != null ? dataOutputStream : new NullOutputStream();
        }
        Iterator it = this._messageDigests.iterator();
        while (it.hasNext()) {
            digStream = new DigestOutputStream(digStream, (MessageDigest)it.next());
        }
        return new CmsSignedDataOutputStream(digStream, signedContentType, sGen, sigGen, eiGen);
    }

    private DERInteger calculateVersion(String contentOid) {
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this._certs != null) {
            for (Object obj : this._certs) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new DERInteger(5);
        }
        if (this._crls != null && !otherCert) {
            for (Object obj : this._crls) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new DERInteger(5);
        }
        if (attrCertV2Found) {
            return new DERInteger(4);
        }
        if (attrCertV1Found) {
            return new DERInteger(3);
        }
        if (contentOid.equals(DATA)) {
            if (this.checkForVersion3(this._signers)) {
                return new DERInteger(3);
            }
            return new DERInteger(1);
        }
        return new DERInteger(3);
    }

    private boolean checkForVersion3(List signerInfos) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            SignerInfo s = SignerInfo.getInstance(((SignerInformation)it.next()).toSignerInfo());
            if (s.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private DERObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, String contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = new DERObjectIdentifier(contentOID);
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        @Override
        public void write(int b) throws IOException {
            this._out.write(b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        @Override
        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this._digests.clear();
            if (CMSSignedDataStreamGenerator.this._certs.size() != 0) {
                ASN1Set certs = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, certs).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this._crls.size() != 0) {
                ASN1Set crls = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this._crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, crls).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (Object signer : CMSSignedDataStreamGenerator.this._signers) {
                signerInfos.add(((SignerInformation)signer).toSignerInfo());
            }
            for (Object signer : CMSSignedDataStreamGenerator.this._signerInfs) {
                try {
                    signerInfos.add(((SignerInf)signer).toSignerInfo(this._contentOID));
                }
                catch (IOException e) {
                    throw new IOException("encoding error." + e);
                }
                catch (SignatureException e) {
                    throw new IOException("error creating signature." + e);
                }
                catch (CertificateEncodingException e) {
                    throw new IOException("error creating sid." + e);
                }
            }
            this._sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class TeeOutputStream
    extends OutputStream {
        private OutputStream s1;
        private OutputStream s2;

        public TeeOutputStream(OutputStream dataOutputStream, OutputStream digStream) {
            this.s1 = dataOutputStream;
            this.s2 = digStream;
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.s1.write(buf);
            this.s2.write(buf);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.s1.write(buf, off, len);
            this.s2.write(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.s1.write(b);
            this.s2.write(b);
        }

        @Override
        public void close() throws IOException {
            this.s1.close();
            this.s2.close();
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] buf) throws IOException {
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private class SignerInf {
        PrivateKey _key;
        X509Certificate _cert;
        String _digestOID;
        String _encOID;
        CMSAttributeTableGenerator _sAttr;
        CMSAttributeTableGenerator _unsAttr;
        MessageDigest _digest;
        Signature _signature;

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, MessageDigest digest, Signature signature) {
            this._key = key;
            this._cert = cert;
            this._digestOID = digestOID;
            this._encOID = encOID;
            this._sAttr = sAttr;
            this._unsAttr = unsAttr;
            this._digest = digest;
            this._signature = signature;
        }

        PrivateKey getKey() {
            return this._key;
        }

        X509Certificate getCertificate() {
            return this._cert;
        }

        String getDigestAlgOID() {
            return this._digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this._encOID;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType) throws IOException, SignatureException, CertificateEncodingException {
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = CMSSignedDataStreamGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            byte[] hash = this._digest.digest();
            CMSSignedDataStreamGenerator.this._digests.put(this._digestOID, hash.clone());
            Map parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            AttributeTable signed = this._sAttr != null ? this._sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set signedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(signed);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr == null) {
                throw new RuntimeException("signatures without signed attributes not implemented.");
            }
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(signedAttr);
            this._signature.update(bOut.toByteArray());
            DEROctetString encDigest = new DEROctetString(this._signature.sign());
            parameters = CMSSignedDataStreamGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this._unsAttr != null ? this._unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = CMSSignedDataStreamGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ASN1InputStream aIn = new ASN1InputStream(cert.getTBSCertificate());
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }
}

