/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.X509ObjectIdentifiers;
import kz.gamma.asn1.x9.X9ObjectIdentifiers;
import kz.gamma.cms.CMSException;
import kz.gamma.cms.CMSSignedDataGenerator;
import kz.gamma.x509.NoSuchStoreException;
import kz.gamma.x509.X509CollectionStoreParameters;
import kz.gamma.x509.X509Store;
import kz.gamma.x509.X509StoreParameters;
import kz.gamma.x509.X509V2AttributeCertificate;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();
    private static final Map encryptionAlgs = new HashMap();
    private static final Map digestAlgs = new HashMap();
    private static final Map digestAliases = new HashMap();

    CMSSignedHelper() {
    }

    String getDigestAlgName(String digestAlgOID) {
        String algName = (String)digestAlgs.get(digestAlgOID);
        if (algName != null) {
            return algName;
        }
        return digestAlgOID;
    }

    String[] getDigestAliases(String algName) {
        String[] aliases = (String[])digestAliases.get(algName);
        if (aliases != null) {
            return aliases;
        }
        return new String[0];
    }

    String getEncryptionAlgName(String encryptionAlgOID) {
        String algName = (String)encryptionAlgs.get(encryptionAlgOID);
        if (algName != null) {
            return algName;
        }
        return encryptionAlgOID;
    }

    MessageDigest getDigestInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createDigestInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String[] aliases = this.getDigestAliases(algorithm);
            for (int i = 0; i != aliases.length; ++i) {
                try {
                    return this.createDigestInstance(aliases[i], provider);
                }
                catch (NoSuchAlgorithmException ex) {
                    continue;
                }
            }
            if (provider != null) {
                return this.getDigestInstance(algorithm, null);
            }
            throw e;
        }
    }

    private MessageDigest createDigestInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider != null) {
            return MessageDigest.getInstance(algorithm, provider);
        }
        return MessageDigest.getInstance(algorithm);
    }

    Signature getSignatureInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (provider != null) {
            return Signature.getInstance(algorithm, provider);
        }
        return Signature.getInstance(algorithm);
    }

    X509Store createAttributeStore(String type, String provider, ASN1Set certSet) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList<X509V2AttributeCertificate> certs = new ArrayList<X509V2AttributeCertificate>();
        if (certSet != null) {
            Enumeration e = certSet.getObjects();
            while (e.hasMoreElements()) {
                try {
                    ASN1TaggedObject tagged;
                    DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                    if (!(obj instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)obj).getTagNo() != 2) continue;
                    certs.add(new X509V2AttributeCertificate(ASN1Sequence.getInstance(tagged, false).getEncoded()));
                }
                catch (IOException ex) {
                    throw new CMSException("can't re-encode attribute certificate!", ex);
                }
            }
        }
        try {
            return X509Store.getInstance("AttributeCertificate/" + type, (X509StoreParameters)new X509CollectionStoreParameters(certs), provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", e);
        }
    }

    X509Store createCertificateStore(String type, String provider, ASN1Set certSet) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList certs = new ArrayList();
        if (certSet != null) {
            this.addCertsFromSet(certs, certSet, provider);
        }
        try {
            return X509Store.getInstance("Certificate/" + type, (X509StoreParameters)new X509CollectionStoreParameters(certs), provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", e);
        }
    }

    X509Store createCRLsStore(String type, String provider, ASN1Set crlSet) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList crls = new ArrayList();
        if (crlSet != null) {
            this.addCRLsFromSet(crls, crlSet, provider);
        }
        try {
            return X509Store.getInstance("CRL/" + type, (X509StoreParameters)new X509CollectionStoreParameters(crls), provider);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("can't setup the X509Store", e);
        }
    }

    CertStore createCertStore(String type, String provider, ASN1Set certSet, ASN1Set crlSet) throws NoSuchProviderException, CMSException, NoSuchAlgorithmException {
        ArrayList certsAndcrls = new ArrayList();
        if (certSet != null) {
            this.addCertsFromSet(certsAndcrls, certSet, provider);
        }
        if (crlSet != null) {
            this.addCRLsFromSet(certsAndcrls, crlSet, provider);
        }
        try {
            if (provider != null) {
                return CertStore.getInstance(type, (CertStoreParameters)new CollectionCertStoreParameters(certsAndcrls), provider);
            }
            return CertStore.getInstance(type, new CollectionCertStoreParameters(certsAndcrls));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("can't setup the CertStore", e);
        }
    }

    private void addCertsFromSet(List certs, ASN1Set certSet, String provider) throws NoSuchProviderException, CMSException {
        CertificateFactory cf;
        try {
            cf = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new CMSException("can't get certificate factory.", ex);
        }
        Enumeration e = certSet.getObjects();
        while (e.hasMoreElements()) {
            try {
                DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                if (!(obj instanceof ASN1Sequence)) continue;
                certs.add(cf.generateCertificate(new ByteArrayInputStream(obj.getEncoded())));
            }
            catch (IOException ex) {
                throw new CMSException("can't re-encode certificate!", ex);
            }
            catch (CertificateException ex) {
                throw new CMSException("can't re-encode certificate!", ex);
            }
        }
    }

    private void addCRLsFromSet(List crls, ASN1Set certSet, String provider) throws NoSuchProviderException, CMSException {
        CertificateFactory cf;
        try {
            cf = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new CMSException("can't get certificate factory.", ex);
        }
        Enumeration e = certSet.getObjects();
        while (e.hasMoreElements()) {
            try {
                DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                crls.add(cf.generateCRL(new ByteArrayInputStream(obj.getEncoded())));
            }
            catch (IOException ex) {
                throw new CMSException("can't re-encode CRL!", ex);
            }
            catch (CRLException ex) {
                throw new CMSException("can't re-encode CRL!", ex);
            }
        }
    }

    private boolean anyCertHasTypeOther() {
        return false;
    }

    private boolean anyCertHasV1Attribute() {
        return false;
    }

    private boolean anyCertHasV2Attribute() {
        return false;
    }

    private boolean anyCrlHasTypeOther() {
        return false;
    }

    static {
        encryptionAlgs.put(X9ObjectIdentifiers.id_dsa_with_sha1.getId(), "DSA");
        encryptionAlgs.put(X9ObjectIdentifiers.id_dsa.getId(), "DSA");
        encryptionAlgs.put(OIWObjectIdentifiers.dsaWithSHA1.getId(), "DSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.rsaEncryption.getId(), "RSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "RSA");
        encryptionAlgs.put(OIWObjectIdentifiers.sha1WithRSA.getId(), "RSA");
        encryptionAlgs.put(X509ObjectIdentifiers.id_ea_rsa.getId(), "RSA");
        encryptionAlgs.put(CMSSignedDataGenerator.ENCRYPTION_ECDSA, "ECDSA");
        encryptionAlgs.put(X9ObjectIdentifiers.ecdsa_with_SHA2.getId(), "ECDSA");
        encryptionAlgs.put(X9ObjectIdentifiers.ecdsa_with_SHA224.getId(), "ECDSA");
        encryptionAlgs.put(X9ObjectIdentifiers.ecdsa_with_SHA256.getId(), "ECDSA");
        encryptionAlgs.put(X9ObjectIdentifiers.ecdsa_with_SHA384.getId(), "ECDSA");
        encryptionAlgs.put(X9ObjectIdentifiers.ecdsa_with_SHA512.getId(), "ECDSA");
        encryptionAlgs.put(CMSSignedDataGenerator.ENCRYPTION_RSA_PSS, "RSAandMGF1");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A_EX.getId(), "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.6.2", "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.1.5", "GOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A.getId(), "ECGOST3410");
        encryptionAlgs.put(KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId(), "ECGOST3410");
        digestAlgs.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestAlgs.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestAlgs.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        digestAlgs.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "SHA224");
        digestAlgs.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256");
        digestAlgs.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384");
        digestAlgs.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512");
        digestAlgs.put(GammaObjectIndentifiers.gost34311.getId(), "GOST3411");
        digestAlgs.put(KZObjectIndentifiers.GOST_34_11_95.getId(), "GOST3411");
        digestAlgs.put(KZObjectIndentifiers.GOST_34_11_95_TEST.getId(), "GOST3411");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34311.getId(), "GOST3411");
        digestAliases.put("SHA1", new String[]{"SHA-1"});
        digestAliases.put("SHA224", new String[]{"SHA-224"});
        digestAliases.put("SHA256", new String[]{"SHA-256"});
        digestAliases.put("SHA384", new String[]{"SHA-384"});
        digestAliases.put("SHA512", new String[]{"SHA-512"});
    }
}

