/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.core.convertors;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import kz.gamma.core.utils.EndiannessUtils;

public class CharacterEncodingConvertor {
    public static final byte[] tablePart1251k = new byte[]{4, -80, 4, -110, 4, -109, 4, -24, 4, -94, 4, -102, 4, -70, 4, -82, 4, -79, 4, -23, 4, -93, 4, -101, 4, -69, 4, -81, 4, -106, 4, -78, 4, -77, 4, -105, 4, -40, 4, -39};
    public static final byte[] tablePart1251 = new byte[]{4, 2, 4, 3, 4, 83, 4, 9, 4, 10, 4, 12, 4, 11, 4, 15, 4, 82, 4, 89, 4, 90, 4, 92, 4, 91, 4, 95, 4, 8, 4, -112, 4, -111, 4, 88, 4, 5, 4, 85};
    public static final char[] kazChars = new char[]{'\u04b0', '\u0492', '\u0493', '\u04e8', '\u04a2', '\u049a', '\u04ba', '\u04ae', '\u04b1', '\u04e9', '\u04a3', '\u049b', '\u04bb', '\u04af', '\u0496', '\u04b2', '\u04b3', '\u0497', '\u04d8', '\u04d9'};
    public static final char[] rusChars = new char[]{'\u0402', '\u0403', '\u0453', '\u0409', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u0459', '\u045a', '\u045c', '\u045b', '\u045f', '\u0408', '\u0490', '\u0491', '\u0458', '\u0405', '\u0455'};
    private EndiannessUtils endiannessUtils = new EndiannessUtils();

    public String convert(String data, byte[] fromTable, byte[] toTable) throws UnsupportedEncodingException {
        if (fromTable == null) {
            throw new IllegalArgumentException("fromTable parameter must not be null");
        }
        if (toTable == null) {
            throw new IllegalArgumentException("toTable parameter must not be null");
        }
        byte[] unicodeString = data.getBytes("UNICODE");
        ByteOrder byteOrder = null;
        for (int i = 0; i < unicodeString.length; i += 2) {
            int j = 0;
            if (i == 0) {
                byteOrder = this.endiannessUtils.getEndianness(unicodeString);
            }
            while (j < fromTable.length) {
                if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
                    if (unicodeString[i] == fromTable[j] && unicodeString[i + 1] == fromTable[j + 1]) {
                        unicodeString[i] = toTable[j];
                        unicodeString[i + 1] = toTable[j + 1];
                    }
                } else if (byteOrder.equals(ByteOrder.LITTLE_ENDIAN) && unicodeString[i] == fromTable[j + 1] && unicodeString[i + 1] == fromTable[j]) {
                    unicodeString[i] = toTable[j + 1];
                    unicodeString[i + 1] = toTable[j];
                }
                j += 2;
            }
        }
        String result = new String(unicodeString, "UNICODE");
        return result;
    }

    public String convert(String data, char[] fromChars, char[] toChars) throws UnsupportedEncodingException {
        if (fromChars == null) {
            throw new IllegalArgumentException("fromChars parameter must not be null");
        }
        if (toChars == null) {
            throw new IllegalArgumentException("toChars parameter must not be null");
        }
        char[] chars = new char[data.length()];
        data.getChars(0, data.length(), chars, 0);
        block0: for (int i = 0; i < chars.length; ++i) {
            for (int j = 0; j < fromChars.length; ++j) {
                if (chars[i] != fromChars[j]) continue;
                chars[i] = toChars[j];
                continue block0;
            }
        }
        String result = new String(chars);
        return result;
    }
}

