/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.crypto.pcsc.idcard;

import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import kz.gamma.core.UtilCM;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.pcsc.idcard.IdCard;

public class IdCardInfo {
    private ResponseAPDU respApdu = null;
    private CommandAPDU capdu = null;
    private IdCard idCard = null;
    private String selectedReader = null;
    private CardChannel selectedChannel = null;

    public IdCardInfo(IdCard idCard, String selectedReader) {
        this.idCard = idCard;
        this.selectedReader = selectedReader;
        Map map = idCard.getCards();
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            String key = (String)entry.getKey();
            if (!key.equals(selectedReader)) continue;
            this.selectedChannel = (CardChannel)entry.getValue();
        }
    }

    public Map getInfo() {
        try {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            byte[] iin = new byte[]{0, -80, 0, 0, 12};
            this.capdu = new CommandAPDU(iin);
            this.respApdu = this.selectedChannel.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new RuntimeException("Cannot get IIN. Error: " + String.valueOf(this.respApdu.getSW()));
            }
            map.put("iin", new String(this.respApdu.getData()));
            byte[] number = new byte[]{0, -54, -33, 1, 9};
            this.capdu = new CommandAPDU(number);
            this.respApdu = this.selectedChannel.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new RuntimeException("Cannot get ID number. Error: " + String.valueOf(this.respApdu.getSW()));
            }
            map.put("number", new String(this.respApdu.getData()));
            byte[] selectNameAndBirthDate = new byte[]{0, -92, 4, 12, 7, -96, 0, 0, 2, 71, 16, 1};
            this.capdu = new CommandAPDU(selectNameAndBirthDate);
            this.respApdu = this.selectedChannel.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new RuntimeException("Cannot select last name, first name, middle name, irth date. Error: " + String.valueOf(this.respApdu.getSW()));
            }
            byte[] nameAndBirthDate = new byte[]{0, -80, -117, 0, 0};
            this.capdu = new CommandAPDU(nameAndBirthDate);
            this.respApdu = this.selectedChannel.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new RuntimeException("Cannot get last name, first name, middle name, birth date. Error: " + String.valueOf(this.respApdu.getSW()));
            }
            IdInfo idInfo = this.readBlob(this.respApdu.getData());
            map.put("lastName", idInfo.getLastName());
            map.put("firstName", idInfo.getFirstName());
            map.put("middleName", idInfo.getMiddleName());
            map.put("birthDate", idInfo.getBirthDate());
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IdInfo readBlob(byte[] data) throws UnsupportedEncodingException {
        IdInfo idInfo = new IdInfo();
        int i = 0;
        byte len = 0;
        byte[] blob = null;
        boolean next = false;
        if (data[0] == 107 && data[1] == data.length - 2) {
            i += 2;
            block7: while (i < data.length) {
                byte tag = data[i];
                switch (tag) {
                    case 92: {
                        len = data[i + 1];
                        blob = new byte[len];
                        System.arraycopy(data, i + 2, blob, 0, len);
                        i = i + 2 + len;
                        continue block7;
                    }
                    case 95: {
                        if (data[i + 1] == 14) {
                            len = data[i + 2];
                            blob = new byte[len];
                            System.arraycopy(data, i + 3, blob, 0, len);
                            idInfo.setLastName(new String(blob, "UTF8"));
                        } else if (data[i + 1] == 43) {
                            len = data[i + 2];
                            blob = new byte[len];
                            System.arraycopy(data, i + 3, blob, 0, len);
                            String birthDateAsString = UtilCM.array2hex(blob);
                            Date birthDateAsDate = null;
                            try {
                                birthDateAsDate = DateUtils.getInstance().stringToDate(birthDateAsString, "yyyyMMdd");
                                idInfo.setBirthDate(birthDateAsDate);
                            }
                            catch (ParseException e) {
                                idInfo.setBirthDate(null);
                                e.printStackTrace();
                            }
                        } else if (data[i + 1] == 15) {
                            len = data[i + 2];
                            blob = new byte[len];
                            System.arraycopy(data, i + 3, blob, 0, len);
                            if (!next) {
                                idInfo.setMiddleName(new String(blob, "UTF8"));
                                next = true;
                            } else {
                                idInfo.setFirstName(new String(blob, "UTF8"));
                                next = false;
                            }
                        }
                        i = i + 3 + len;
                        continue block7;
                    }
                    case -96: {
                        i += 5;
                        continue block7;
                    }
                }
                throw new InvalidParameterException("Invalid parameter: " + UtilCM.toHexByte(tag));
            }
        }
        return idInfo;
    }

    private class IdInfo {
        private String lastName;
        private String firstName;
        private String middleName;
        private Date birthDate;

        private IdInfo() {
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public Date getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(Date birthDate) {
            this.birthDate = birthDate;
        }
    }
}

