/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.asn1.ASN1Encodable;
import kz.gamma.asn1.ASN1EncodableVector;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1OctetString;
import kz.gamma.asn1.ASN1OutputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DEREnumerated;
import kz.gamma.asn1.DERGeneralizedTime;
import kz.gamma.asn1.DERIA5String;
import kz.gamma.asn1.DERObject;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.isismtt.ISISMTTObjectIdentifiers;
import kz.gamma.asn1.x509.AlgorithmIdentifier;
import kz.gamma.asn1.x509.CRLDistPoint;
import kz.gamma.asn1.x509.CRLNumber;
import kz.gamma.asn1.x509.DistributionPoint;
import kz.gamma.asn1.x509.DistributionPointName;
import kz.gamma.asn1.x509.GeneralName;
import kz.gamma.asn1.x509.GeneralNames;
import kz.gamma.asn1.x509.PolicyInformation;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.asn1.x509.X509Extensions;
import kz.gamma.jce.X509LDAPCertStoreParameters;
import kz.gamma.jce.provider.AnnotatedException;
import kz.gamma.jce.provider.CertStatus;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.PKIXPolicyNode;
import kz.gamma.util.Selector;
import kz.gamma.util.StoreException;
import kz.gamma.x509.ExtendedPKIXParameters;
import kz.gamma.x509.X509AttributeCertificate;
import kz.gamma.x509.X509CRLStoreSelector;
import kz.gamma.x509.X509Store;
import kz.gamma.x509.X509StoreParameters;

public class CertPathValidatorUtilities {
    protected static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    protected static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    protected static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    protected static final String FRESHEST_CRL = X509Extensions.FreshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = X509Extensions.CRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = X509Extensions.AuthorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    protected static final TrustAnchor findTrustAnchor(X509Certificate cert, CertPath certPath, int index, Set trustAnchors) throws CertPathValidatorException {
        Iterator iter = trustAnchors.iterator();
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        try {
            certSelectX509.setSubject(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded());
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = (TrustAnchor)iter.next();
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal certIssuer = CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert);
                        X500Principal caName = new X500Principal(trust.getCAName());
                        if (certIssuer.equals(caName)) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", invalidKeyEx, certPath, index);
        }
        return trust;
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getIssuerX500Principal();
        }
        return (X500Principal)((X509AttributeCertificate)cert).getIssuer().getPrincipals()[0];
    }

    protected static Date getValidDate(PKIXParameters paramsPKIX) {
        Date validDate = paramsPKIX.getDate();
        if (validDate == null) {
            validDate = new Date();
        }
        return validDate;
    }

    protected static X500Principal getSubjectPrincipal(X509Certificate cert) {
        return cert.getSubjectX500Principal();
    }

    protected static boolean isSelfIssued(X509Certificate cert) {
        return ((Object)cert.getSubjectDN()).equals(cert.getIssuerDN());
    }

    protected static DERObject getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(oid, bytes);
    }

    private static DERObject getObject(String oid, byte[] ext) throws AnnotatedException {
        try {
            ASN1InputStream aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            aIn = new ASN1InputStream(octs.getOctets());
            return aIn.readObject();
        }
        catch (IOException e) {
            throw new AnnotatedException("exception processing extension " + oid, e);
        }
    }

    protected static X500Principal getIssuerPrincipal(X509CRL crl) {
        return crl.getIssuerX500Principal();
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey key) throws CertPathValidatorException {
        try {
            String alg = key.getAlgorithm();
            byte[] bytes = key.getEncoded();
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(new DERObjectIdentifier(alg), null), bytes);
            return info.getAlgorithmId();
        }
        catch (Exception e) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    protected static final Collection findCRLs(X509CRLSelector crlSelect, List crlStores) throws AnnotatedException {
        HashSet<? extends CRL> crls = new HashSet<CRL>();
        for (CertStore certStore : crlStores) {
            try {
                crls.addAll(certStore.getCRLs(crlSelect));
            }
            catch (CertStoreException e) {
                throw new AnnotatedException("cannot extract crl: " + e, e);
            }
        }
        return crls;
    }

    protected static final Collection findCRLs(X509CRLStoreSelector crlSelect, List crlStores) throws AnnotatedException {
        HashSet crls = new HashSet();
        Iterator iter = crlStores.iterator();
        AnnotatedException lastException = null;
        boolean foundValidStore = false;
        while (iter.hasNext()) {
            X509Store store = (X509Store)iter.next();
            try {
                crls.addAll(store.getMatches(crlSelect));
                foundValidStore = true;
            }
            catch (StoreException e) {
                lastException = new AnnotatedException("Exception searching in X.509 CRL store.", e);
            }
        }
        if (!foundValidStore && lastException != null) {
            throw lastException;
        }
        return crls;
    }

    protected static final Set getQualifierSet(ASN1Sequence qualifiers) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> pq = new HashSet<PolicyQualifierInfo>();
        if (qualifiers == null) {
            return pq;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        Enumeration e = qualifiers.getObjects();
        while (e.hasMoreElements()) {
            try {
                aOut.writeObject(e.nextElement());
                pq.add(new PolicyQualifierInfo(bOut.toByteArray()));
            }
            catch (IOException ex) {
                throw new CertPathValidatorException("exception building qualifier set: " + ex);
            }
            bOut.reset();
        }
        return pq;
    }

    protected static PKIXPolicyNode removePolicyNode(PKIXPolicyNode validPolicyTree, List[] policyNodes, PKIXPolicyNode _node) {
        PKIXPolicyNode _parent = (PKIXPolicyNode)_node.getParent();
        if (validPolicyTree == null) {
            return null;
        }
        if (_parent == null) {
            for (int j = 0; j < policyNodes.length; ++j) {
                policyNodes[j] = new ArrayList();
            }
            return null;
        }
        _parent.removeChild(_node);
        CertPathValidatorUtilities.removePolicyNodeRecurse(policyNodes, _node);
        return validPolicyTree;
    }

    private static void removePolicyNodeRecurse(List[] policyNodes, PKIXPolicyNode _node) {
        policyNodes[_node.getDepth()].remove(_node);
        if (_node.hasChildren()) {
            Iterator _iter = _node.getChildren();
            while (_iter.hasNext()) {
                PKIXPolicyNode _child = (PKIXPolicyNode)_iter.next();
                CertPathValidatorUtilities.removePolicyNodeRecurse(policyNodes, _child);
            }
        }
    }

    protected static boolean processCertD1i(int index, List[] policyNodes, DERObjectIdentifier pOid, Set pq) {
        List policyNodeVec = policyNodes[index - 1];
        for (int j = 0; j < policyNodeVec.size(); ++j) {
            PKIXPolicyNode node = (PKIXPolicyNode)policyNodeVec.get(j);
            Set expectedPolicies = node.getExpectedPolicies();
            if (!expectedPolicies.contains(pOid.getId())) continue;
            HashSet<String> childExpectedPolicies = new HashSet<String>();
            childExpectedPolicies.add(pOid.getId());
            PKIXPolicyNode child = new PKIXPolicyNode(new ArrayList(), index, childExpectedPolicies, node, pq, pOid.getId(), false);
            node.addChild(child);
            policyNodes[index].add(child);
            return true;
        }
        return false;
    }

    protected static void processCertD1ii(int index, List[] policyNodes, DERObjectIdentifier _poid, Set _pq) {
        List policyNodeVec = policyNodes[index - 1];
        for (int j = 0; j < policyNodeVec.size(); ++j) {
            PKIXPolicyNode _node = (PKIXPolicyNode)policyNodeVec.get(j);
            Set _expectedPolicies = _node.getExpectedPolicies();
            if (!ANY_POLICY.equals(_node.getValidPolicy())) continue;
            HashSet<String> _childExpectedPolicies = new HashSet<String>();
            _childExpectedPolicies.add(_poid.getId());
            PKIXPolicyNode _child = new PKIXPolicyNode(new ArrayList(), index, _childExpectedPolicies, _node, _pq, _poid.getId(), false);
            _node.addChild(_child);
            policyNodes[index].add(_child);
            return;
        }
    }

    protected static void prepareNextCertB1(int i, List[] policyNodes, String id_p, Map m_idp, X509Certificate cert) throws AnnotatedException, CertPathValidatorException {
        boolean idp_found = false;
        for (PKIXPolicyNode node : policyNodes[i]) {
            if (!node.getValidPolicy().equals(id_p)) continue;
            idp_found = true;
            node.expectedPolicies = (Set)m_idp.get(id_p);
            break;
        }
        if (!idp_found) {
            for (PKIXPolicyNode node : policyNodes[i]) {
                PKIXPolicyNode p_node;
                if (!ANY_POLICY.equals(node.getValidPolicy())) continue;
                Set pq = null;
                ASN1Sequence policies = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(cert, CERTIFICATE_POLICIES);
                Enumeration e = policies.getObjects();
                while (e.hasMoreElements()) {
                    PolicyInformation pinfo = PolicyInformation.getInstance(e.nextElement());
                    if (!ANY_POLICY.equals(pinfo.getPolicyIdentifier().getId())) continue;
                    pq = CertPathValidatorUtilities.getQualifierSet(pinfo.getPolicyQualifiers());
                    break;
                }
                boolean ci = false;
                if (cert.getCriticalExtensionOIDs() != null) {
                    ci = cert.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!ANY_POLICY.equals((p_node = (PKIXPolicyNode)node.getParent()).getValidPolicy())) break;
                PKIXPolicyNode c_node = new PKIXPolicyNode(new ArrayList(), i, (Set)m_idp.get(id_p), p_node, pq, id_p, ci);
                p_node.addChild(c_node);
                policyNodes[i].add(c_node);
                break;
            }
        }
    }

    protected static PKIXPolicyNode prepareNextCertB2(int i, List[] policyNodes, String id_p, PKIXPolicyNode validPolicyTree) {
        Iterator nodes_i = policyNodes[i].iterator();
        while (nodes_i.hasNext()) {
            PKIXPolicyNode node = (PKIXPolicyNode)nodes_i.next();
            if (!node.getValidPolicy().equals(id_p)) continue;
            PKIXPolicyNode p_node = (PKIXPolicyNode)node.getParent();
            p_node.removeChild(node);
            nodes_i.remove();
            for (int k = i - 1; k >= 0; --k) {
                PKIXPolicyNode node2;
                List nodes = policyNodes[k];
                for (int l = 0; l < nodes.size() && ((node2 = (PKIXPolicyNode)nodes.get(l)).hasChildren() || (validPolicyTree = CertPathValidatorUtilities.removePolicyNode(validPolicyTree, policyNodes, node2)) != null); ++l) {
                }
            }
        }
        return validPolicyTree;
    }

    protected static boolean isAnyPolicy(Set policySet) {
        return policySet == null || policySet.contains(ANY_POLICY) || policySet.isEmpty();
    }

    protected static void addAdditionalStoreFromLocation(String location, ExtendedPKIXParameters pkixParams) {
        if (pkixParams.isAdditionalLocationsEnabled()) {
            try {
                if (location.startsWith("ldap://")) {
                    location = location.substring(7);
                    String base = null;
                    String url = null;
                    if (location.indexOf("/") != -1) {
                        base = location.substring(location.indexOf("/"));
                        url = "ldap://" + location.substring(0, location.indexOf("/"));
                    } else {
                        url = "ldap://" + location;
                    }
                    X509LDAPCertStoreParameters params = new X509LDAPCertStoreParameters.Builder(url, base).build();
                    pkixParams.addAddionalStore(X509Store.getInstance("CERTIFICATE/LDAP", (X509StoreParameters)params, GammaTechProvider.PROVIDER_NAME));
                    pkixParams.addAddionalStore(X509Store.getInstance("CRL/LDAP", (X509StoreParameters)params, GammaTechProvider.PROVIDER_NAME));
                    pkixParams.addAddionalStore(X509Store.getInstance("ATTRIBUTECERTIFICATE/LDAP", (X509StoreParameters)params, GammaTechProvider.PROVIDER_NAME));
                    pkixParams.addAddionalStore(X509Store.getInstance("CERTIFICATEPAIR/LDAP", (X509StoreParameters)params, GammaTechProvider.PROVIDER_NAME));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception adding X.509 stores.");
            }
        }
    }

    protected static Collection findCertificates(CertSelector certSelect, List certStores) throws AnnotatedException {
        HashSet<? extends Certificate> certs = new HashSet<Certificate>();
        for (CertStore certStore : certStores) {
            try {
                certs.addAll(certStore.getCertificates(certSelect));
            }
            catch (CertStoreException e) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", e);
            }
        }
        return certs;
    }

    protected static Collection findCertificates(Selector certSelect, List certStores) throws AnnotatedException {
        HashSet certs = new HashSet();
        for (X509Store certStore : certStores) {
            try {
                certs.addAll(certStore.getMatches(certSelect));
            }
            catch (StoreException e) {
                throw new AnnotatedException("Problem while picking certificates from X.509 store.", e);
            }
        }
        return certs;
    }

    protected static void addAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new AnnotatedException("Distribution points could not be read.", e);
            }
            for (int i = 0; i < dps.length; ++i) {
                DistributionPointName dpn = dps[i].getDistributionPoint();
                if (dpn.getType() != 0) continue;
                GeneralName[] genNames = GeneralNames.getInstance(dpn.getName()).getNames();
                for (int j = 0; j < genNames.length; ++j) {
                    if (genNames[j].getTagNo() != 6) continue;
                    String location = DERIA5String.getInstance(genNames[j].getName()).getString();
                    CertPathValidatorUtilities.addAdditionalStoreFromLocation(location, pkixParams);
                }
            }
        }
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint dp, Collection issuerPrincipals, X509CRLStoreSelector selector, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        Iterator it;
        ArrayList<X500Principal> issuers = new ArrayList<X500Principal>();
        if (dp.getCRLIssuer() != null) {
            GeneralName[] genNames = dp.getCRLIssuer().getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 4) continue;
                try {
                    issuers.add(new X500Principal(genNames[j].getName().getDERObject().getEncoded()));
                    continue;
                }
                catch (IOException e) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", e);
                }
            }
        } else {
            if (dp.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            it = issuerPrincipals.iterator();
            while (it.hasNext()) {
                issuers.add((X500Principal)it.next());
            }
        }
        if (dp.getDistributionPoint() != null && dp.getDistributionPoint().getType() == 1) {
            if (issuers.size() != 1) {
                throw new AnnotatedException("nameRelativeToCRLIssuer field is given but more than one CRL issuer is given.");
            }
            ASN1Encodable relName = dp.getDistributionPoint().getName();
            Iterator it2 = issuers.iterator();
            ArrayList<X500Principal> issuersTemp = new ArrayList<X500Principal>(issuers.size());
            while (it2.hasNext()) {
                Enumeration e = null;
                try {
                    e = ASN1Sequence.getInstance(new ASN1InputStream(((X500Principal)it2.next()).getEncoded()).readObject()).getObjects();
                }
                catch (IOException ex) {
                    throw new AnnotatedException("Cannot decode CRL issuer information.", ex);
                }
                ASN1EncodableVector v = new ASN1EncodableVector();
                while (e.hasMoreElements()) {
                    v.add((DEREncodable)e.nextElement());
                }
                v.add(relName);
                issuersTemp.add(new X500Principal(new DERSequence(v).getDEREncoded()));
            }
            issuers.clear();
            issuers.addAll(issuersTemp);
        }
        it = issuers.iterator();
        while (it.hasNext()) {
            try {
                selector.addIssuerName(((X500Principal)it.next()).getEncoded());
            }
            catch (IOException ex) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", ex);
            }
        }
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, BigInteger serialNumber, CertStatus certStatus) throws AnnotatedException {
        X509CRLEntry crl_entry = crl.getRevokedCertificate(serialNumber);
        if (crl_entry != null) {
            DEREnumerated reasonCode = null;
            if (crl_entry.hasExtensions()) {
                try {
                    reasonCode = DEREnumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(crl_entry, X509Extensions.ReasonCode.getId()));
                }
                catch (Exception e) {
                    new AnnotatedException("Reason code CRL entry extension could not be decoded.", e);
                }
            }
            if (validDate.getTime() >= crl_entry.getRevocationDate().getTime() || reasonCode == null || reasonCode.getValue().intValue() == 0 || reasonCode.getValue().intValue() == 1 || reasonCode.getValue().intValue() == 2 || reasonCode.getValue().intValue() == 8) {
                if (reasonCode != null) {
                    certStatus.setCertStatus(reasonCode.getValue().intValue());
                } else {
                    certStatus.setCertStatus(0);
                }
                certStatus.setRevocationDate(crl_entry.getRevocationDate());
            }
        }
    }

    protected static Set getDeltaCRLs(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509CRL completeCRL) throws AnnotatedException {
        BigInteger completeCRLNumber;
        HashSet set = new HashSet();
        X509CRLStoreSelector deltaSelect = new X509CRLStoreSelector();
        deltaSelect.setDateAndTime(currentDate);
        try {
            deltaSelect.addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(completeCRL).getEncoded());
        }
        catch (IOException e) {
            new AnnotatedException("Cannot extract issuer from CRL.", e);
        }
        try {
            completeCRLNumber = CRLNumber.getInstance(CertPathValidatorUtilities.getExtensionValue(completeCRL, CRL_NUMBER)).getPositiveValue();
        }
        catch (Exception e) {
            throw new AnnotatedException("CRL number extension could not be extracted from CRL.", e);
        }
        byte[] idp = null;
        try {
            idp = completeCRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception e) {
            throw new AnnotatedException("Issuing distribution point extension value could not be read.", e);
        }
        deltaSelect.setIssuingDistributionPoint(idp);
        deltaSelect.setIssuingDistributionPointEnabled(true);
        deltaSelect.setMaxBaseCRLNumber(completeCRLNumber);
        deltaSelect.setMinCRLNumber(completeCRLNumber.add(BigInteger.valueOf(1L)));
        HashSet temp = new HashSet();
        try {
            temp.addAll(CertPathValidatorUtilities.findCRLs(deltaSelect, paramsPKIX.getAddionalStores()));
            temp.addAll(CertPathValidatorUtilities.findCRLs(deltaSelect, paramsPKIX.getStores()));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Could not search for delta CRLs.", e);
        }
        if (set.isEmpty()) {
            throw new AnnotatedException("No delta CRLs found.");
        }
        return set;
    }

    protected static Set getCompleteCRLs(DistributionPoint dp, Object cert, Date currentDate, ExtendedPKIXParameters paramsPKIX) throws AnnotatedException {
        X509CRLStoreSelector crlselect = new X509CRLStoreSelector();
        try {
            HashSet<Principal> issuers = new HashSet<Principal>();
            if (cert instanceof X509AttributeCertificate) {
                issuers.add(((X509AttributeCertificate)cert).getIssuer().getPrincipals()[0]);
            } else {
                issuers.add(((X509Certificate)cert).getSubjectX500Principal());
            }
            CertPathValidatorUtilities.getCRLIssuersFromDistributionPoint(dp, issuers, crlselect, paramsPKIX);
        }
        catch (AnnotatedException e) {
            new AnnotatedException("Could not get issuer information from distribution point.", e);
        }
        if (cert instanceof X509Certificate) {
            crlselect.setCertificateChecking((X509Certificate)cert);
        } else {
            crlselect.setAttrCertificateChecking((X509AttributeCertificate)cert);
        }
        crlselect.setDateAndTime(currentDate);
        crlselect.setCompleteCRLEnabled(true);
        HashSet crls = new HashSet();
        try {
            crls.addAll(CertPathValidatorUtilities.findCRLs(crlselect, paramsPKIX.getStores()));
            crls.addAll(CertPathValidatorUtilities.findCRLs(crlselect, paramsPKIX.getAddionalStores()));
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Could not search for CRLs.", e);
        }
        if (crls.isEmpty()) {
            throw new AnnotatedException("No CRLs found.");
        }
        return crls;
    }

    protected static Date getValidCertDateFromValidityModel(ExtendedPKIXParameters paramsPKIX, CertPath certPath, int index) throws AnnotatedException {
        if (paramsPKIX.getValidityModel() == 1) {
            if (index <= 0) {
                return CertPathValidatorUtilities.getValidDate(paramsPKIX);
            }
            if (index - 1 == 0) {
                DERGeneralizedTime dateOfCertgen = null;
                try {
                    dateOfCertgen = DERGeneralizedTime.getInstance(((X509Certificate)certPath.getCertificates().get(index - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId()));
                }
                catch (IllegalArgumentException e) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (dateOfCertgen != null) {
                    try {
                        return dateOfCertgen.getDate();
                    }
                    catch (ParseException e) {
                        throw new AnnotatedException("Date from dat of cert gen extension could not be parsed.", e);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
        }
        return CertPathValidatorUtilities.getValidDate(paramsPKIX);
    }

    protected static PublicKey getNextWorkingKey(X509Certificate cert, List certs, int index) throws CertPathValidatorException {
        PublicKey pubKey = cert.getPublicKey();
        if (!(pubKey instanceof DSAPublicKey)) {
            return pubKey;
        }
        DSAPublicKey dsaPubKey = (DSAPublicKey)pubKey;
        if (dsaPubKey.getParams() != null) {
            return dsaPubKey;
        }
        for (int i = index + 1; i < certs.size(); ++i) {
            X509Certificate parentCert = (X509Certificate)certs.get(i);
            pubKey = parentCert.getPublicKey();
            if (!(pubKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey prevDSAPubKey = (DSAPublicKey)pubKey;
            if (prevDSAPubKey.getParams() == null) continue;
            DSAParams dsaParams = prevDSAPubKey.getParams();
            DSAPublicKeySpec dsaPubKeySpec = new DSAPublicKeySpec(dsaPubKey.getY(), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", GammaTechProvider.PROVIDER_NAME);
                return keyFactory.generatePublic(dsaPubKeySpec);
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }
}

