/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.jce.provider.JCEECPublicKey;

public class JDKKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return null;
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        return null;
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getObjectId().getId().equals(CryptoProObjectIdentifiers.gostR3410_2001.getId()) || info.getAlgorithmId().getObjectId().getId().equals(KZObjectIndentifiers.GOST_34_310_KEY.getId())) {
            try {
                DERSequence derSequence = (DERSequence)info.getAlgorithmId().getParameters();
                DERObjectIdentifier keyOid = (DERObjectIdentifier)derSequence.getObjectAt(0);
                return new JCEECPublicKey(info.getEncoded(), keyOid.getId());
            }
            catch (Exception ex) {
                return null;
            }
        }
        return new JCEECPublicKey(info.getPublicKeyData().getBytes(), info.getAlgorithmId().getObjectId().getId());
    }

    static PublicKey createPublicKeyFromDERStream(byte[] in) throws IOException, InvalidKeySpecException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(in).readObject()));
    }

    public static class ECGOST34310
    extends JDKKeyFactory {
        String algorithm;

        public ECGOST34310() {
            this("ECGOST34310");
        }

        public ECGOST34310(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return null;
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                try {
                    JCEECPublicKey key = (JCEECPublicKey)JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                    return key;
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            return null;
        }
    }
}

