/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERSequence;
import kz.gamma.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gamma.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.core.UtilCM;
import kz.gamma.jce.exception.CSPException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.jce.provider.JCEECPrivateKey;
import kz.gamma.jce.provider.JCEECPublicKey;
import kz.gamma.tumarcsp.ErrorResolver;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class JDKKeyPairGenerator
extends KeyPairGenerator {
    protected JDKKeyPairGenerator(String algorithm) {
        super(algorithm);
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        private boolean initialized = false;
        private String profile;
        private String password;
        private int algID = 43578;

        public RSA() {
            super("RSA");
        }

        public RSA(String algorithm) {
            super(algorithm);
        }

        @Override
        public void initialize(int algorithmId) {
            this.algID = algorithmId;
        }

        public void setProfName(String profile, String password) {
            this.profile = ProfileParams.getProfileName(profile, true);
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            Number hProv = 0;
            if (!this.initialized) {
                throw new CSPException(new ErrorResolver(0), "Key Pair Generator not initialized. Profile not found");
            }
            if (this.password.length() == 0) {
                try {
                    hProv = TumarCspFunctions.cpAcquireContext(this.profile, 0x1000008, LibraryWrapper.PV_TABLE);
                }
                catch (Exception ex) {
                    hProv = 0;
                }
            }
            if (hProv.longValue() == 0L) {
                hProv = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
                this.profile = TumarCspFunctions.cpUrlToNewUrl(this.profile, this.password, 0, hProv);
                if (hProv.longValue() != 0L) {
                    TumarCspFunctions.cpReleaseContext(hProv, 0);
                }
                hProv = TumarCspFunctions.cpAcquireContext(this.profile, 0x1000008, LibraryWrapper.PV_TABLE);
            }
            Number hKey = TumarCspFunctions.cpGenKey(hProv, this.algID, 1);
            TumarCspFunctions.cpSetKeyParam(hProv, hKey, 67, null, 0);
            byte[] pubKey = TumarCspFunctions.cpGetKeyParamData(hProv, hKey, 15, 0);
            return new KeyPair(new JCEECPublicKey(pubKey, PKCSObjectIdentifiers.rsaEncryption.getId()), new JCEECPrivateKey(this.profile, hProv, hKey));
        }
    }

    public static class ECGOST34310
    extends JDKKeyPairGenerator {
        private boolean initialized = false;
        private String profile;
        private String password;
        private int algID = 43578;
        private int blobType = 6;
        private int flags = 0;

        public ECGOST34310() {
            super("ECGOST34310");
        }

        public ECGOST34310(String algorithm) {
            super(algorithm);
        }

        @Override
        public void initialize(int algorithmId) {
            this.algID = algorithmId;
        }

        public void setProfName(String profile, String password) {
            this.profile = ProfileParams.getProfileName(profile, true);
            this.password = password == null ? "" : password.trim();
            this.initialized = true;
        }

        public void setParameters(int blobType, int flags) {
            this.flags = flags;
            this.blobType = blobType;
        }

        @Override
        public KeyPair generateKeyPair() {
            Number hProv = 0;
            String keyOID = GammaTechProvider.getAlgUtil().getOID(this.algID);
            if (!this.initialized) {
                throw new CSPException(new ErrorResolver(0), "Key Pair Generator not initialized. Profile not found");
            }
            if (this.password.length() == 0) {
                try {
                    hProv = TumarCspFunctions.cpAcquireContext(this.profile, 0x1000008, LibraryWrapper.PV_TABLE);
                }
                catch (Exception ex) {
                    hProv = 0;
                }
            }
            if (hProv.longValue() == 0L) {
                hProv = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
                this.profile = TumarCspFunctions.cpUrlToNewUrl(this.profile, this.password, 0, hProv);
                if (hProv.longValue() != 0L) {
                    TumarCspFunctions.cpReleaseContext(hProv, 0);
                }
                hProv = TumarCspFunctions.cpAcquireContext(this.profile, 0x1000008, LibraryWrapper.PV_TABLE);
            }
            Number hKey = TumarCspFunctions.cpGenKey(hProv, this.algID, 1);
            TumarCspFunctions.cpSetKeyParam(hProv, hKey, 67, null, 0);
            byte[] pubKey = TumarCspFunctions.cpExportKeyData(hProv, hKey, (Number)0, this.blobType, this.flags);
            if (this.flags == 0x400000) {
                keyOID = CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A.getId();
                try {
                    SubjectPublicKeyInfo subjectPKInfo = new SubjectPublicKeyInfo((DERSequence)new ASN1InputStream(pubKey).readObject());
                    pubKey = subjectPKInfo.getEncoded();
                    byte[] pk = subjectPKInfo.getPublicKeyData().getBytes();
                    System.out.println("   " + UtilCM.array2hex(pk));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.flags == 0x4000000) {
                keyOID = KZObjectIndentifiers.GOST_34_310_KEY_A.getId();
                try {
                    SubjectPublicKeyInfo subjectPKInfo = new SubjectPublicKeyInfo((DERSequence)new ASN1InputStream(pubKey).readObject());
                    pubKey = subjectPKInfo.getEncoded();
                    byte[] pk = subjectPKInfo.getPublicKeyData().getBytes();
                    System.out.println("   " + UtilCM.array2hex(pk));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new KeyPair(new JCEECPublicKey(pubKey, keyOID), new JCEECPrivateKey(this.profile, hProv, hKey));
        }
    }
}

