/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.ASN1Set;
import kz.gamma.asn1.ASN1TaggedObject;
import kz.gamma.asn1.DEREncodable;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.asn1.pkcs.SignedData;
import kz.gamma.asn1.x509.CertificateList;
import kz.gamma.asn1.x509.X509CertificateStructure;
import kz.gamma.jce.provider.PEMUtil;
import kz.gamma.jce.provider.PKIXCertPath;
import kz.gamma.jce.provider.ProviderUtil;
import kz.gamma.jce.provider.X509CRLObject;
import kz.gamma.jce.provider.X509CertificateObject;

public class JDKX509CertificateFactory
extends CertificateFactorySpi {
    private static final PEMUtil PEM_CERT_PARSER = new PEMUtil("CERTIFICATE");
    private static final PEMUtil PEM_CRL_PARSER = new PEMUtil("CRL");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;
    private ASN1Set sCrlData = null;
    private int sCrlDataObjectCount = 0;
    private InputStream currentCrlStream = null;

    private Certificate readDERCertificate(ASN1InputStream dIn) throws IOException, CertificateParsingException {
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true)).getCertificates();
            return this.getCertificate();
        }
        return new X509CertificateObject(X509CertificateStructure.getInstance(seq));
    }

    private Certificate getCertificate() throws CertificateParsingException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                DEREncodable obj;
                if (!((obj = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1Sequence)) continue;
                return new X509CertificateObject(X509CertificateStructure.getInstance(obj));
            }
        }
        return null;
    }

    private Certificate readPEMCertificate(InputStream in) throws IOException, CertificateParsingException {
        ASN1Sequence seq = PEM_CERT_PARSER.readPEMObject(in);
        if (seq != null) {
            return new X509CertificateObject(X509CertificateStructure.getInstance(seq));
        }
        return null;
    }

    private CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        ASN1Sequence seq = PEM_CRL_PARSER.readPEMObject(in);
        if (seq != null) {
            return new X509CRLObject(CertificateList.getInstance(seq));
        }
        return null;
    }

    private CRL readDERCRL(ASN1InputStream aIn) throws IOException, CRLException {
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sCrlData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true)).getCRLs();
            return this.getCRL();
        }
        return new X509CRLObject(CertificateList.getInstance(seq));
    }

    private CRL getCRL() throws CRLException {
        if (this.sCrlData == null || this.sCrlDataObjectCount >= this.sCrlData.size()) {
            return null;
        }
        return new X509CRLObject(CertificateList.getInstance(this.sCrlData.getObjectAt(this.sCrlDataObjectCount++)));
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream in) throws CertificateException {
        if (this.currentStream == null) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        } else if (this.currentStream != in) {
            this.currentStream = in;
            this.sData = null;
            this.sDataObjectCount = 0;
        }
        try {
            if (this.sData != null) {
                if (this.sDataObjectCount != this.sData.size()) {
                    return this.getCertificate();
                }
                this.sData = null;
                this.sDataObjectCount = 0;
                return null;
            }
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(10);
            int tag = in.read();
            if (tag == -1) {
                return null;
            }
            if (tag != 48) {
                in.reset();
                return this.readPEMCertificate(in);
            }
            in.reset();
            return this.readDERCertificate(new ASN1InputStream(in, ProviderUtil.getReadLimit(in)));
        }
        catch (Exception e) {
            throw new CertificateException(e.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        Certificate cert;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while ((cert = this.engineGenerateCertificate(inStream)) != null) {
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (this.currentCrlStream == null) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        } else if (this.currentCrlStream != inStream) {
            this.currentCrlStream = inStream;
            this.sCrlData = null;
            this.sCrlDataObjectCount = 0;
        }
        try {
            if (this.sCrlData != null) {
                if (this.sCrlDataObjectCount != this.sCrlData.size()) {
                    return this.getCRL();
                }
                this.sCrlData = null;
                this.sCrlDataObjectCount = 0;
                return null;
            }
            if (!inStream.markSupported()) {
                inStream = new BufferedInputStream(inStream);
            }
            inStream.mark(10);
            if (inStream.read() != 48) {
                inStream.reset();
                return this.readPEMCRL(inStream);
            }
            inStream.reset();
            return this.readDERCRL(new ASN1InputStream(inStream, ProviderUtil.getReadLimit(inStream)));
        }
        catch (CRLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        CRL crl;
        ArrayList<CRL> crls = new ArrayList<CRL>();
        while ((crl = this.engineGenerateCRL(inStream)) != null) {
            crls.add(crl);
        }
        return crls;
    }

    public Iterator engineGetCertPathEncodings() {
        return PKIXCertPath.certPathEncodings.iterator();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        return this.engineGenerateCertPath(inStream, "PkiPath");
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        return new PKIXCertPath(inStream, encoding);
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        for (Object obj : certificates) {
            if (obj == null || obj instanceof X509Certificate) continue;
            throw new CertificateException("list contains non X509Certificate object while creating CertPath\n" + obj.toString());
        }
        return new PKIXCertPath(certificates);
    }
}

