/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.ASN1Sequence;
import kz.gamma.asn1.DERObject;
import kz.gamma.util.encoders.Base64;

public class PEMUtil {
    private String[] pemHeaders = new String[2];
    private String[] pemFooters = new String[2];
    public static final String PEM_BEGIN = "-----BEGIN";
    public static final String PEM_END = "-----END";
    public static final String PEM_CERT_REQUEST_HEADER = "CERTIFICATE REQUEST";
    public static final String PEM_NEW_CERT_REQUEST_HEADER = "NEW CERTIFICATE REQUEST";
    public static final String PEM_CERT_HEADER = "CERTIFICATE";
    public static final String PEM_TRUSTED_CERT_HEADER = "TRUSTED CERTIFICATE";
    public static final String PEM_ENC_KEY_HEADER = "ENCRYPTED PRIVATE KEY";
    public static final String PEM_KEY_HEADER = "PRIVATE KEY";
    public static final String PEM_RSA_KEY_HEADER = "RSA PRIVATE KEY";
    public static final String PEM_CRL_HEADER = "CRL";

    public PEMUtil(String type) {
        this.pemHeaders[0] = "-----BEGIN " + type + "-----";
        this.pemHeaders[1] = "-----BEGIN X509 " + type + "-----";
        this.pemFooters[0] = "-----END " + type + "-----";
        this.pemFooters[1] = "-----END X509 " + type + "-----";
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while (true) {
            if ((c = in.read()) != 13 && c != 10 && c >= 0) {
                if (c == 13) continue;
                l.append((char)c);
                continue;
            }
            if (c < 0 || l.length() != 0) break;
        }
        if (c < 0) {
            return null;
        }
        return l.toString();
    }

    ASN1Sequence readPEMObject(InputStream in) throws IOException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        while ((line = PEMUtil.readLine(in)) != null && !line.equals(this.pemHeaders[0]) && !line.equals(this.pemHeaders[1])) {
        }
        while ((line = PEMUtil.readLine(in)) != null && !line.equals(this.pemFooters[0]) && !line.equals(this.pemFooters[1])) {
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            DERObject o = new ASN1InputStream(Base64.decode(pemBuf.toString())).readObject();
            if (!(o instanceof ASN1Sequence)) {
                throw new IOException("malformed PEM data encountered");
            }
            return (ASN1Sequence)o;
        }
        return null;
    }

    public static boolean isHavePemHeaderAndFooter(InputStream in, String type) throws IOException {
        String line;
        String[] headers = new String[]{"-----BEGIN " + type + "-----", "-----BEGIN X509 " + type + "-----"};
        String[] footers = new String[]{"-----END " + type + "-----", "-----END X509 " + type + "-----"};
        boolean haveHeader = false;
        boolean haveFooter = false;
        while ((line = PEMUtil.readLine(in)) != null) {
            if (!line.equals(headers[0]) && !line.equals(headers[1])) continue;
            haveHeader = true;
            break;
        }
        while ((line = PEMUtil.readLine(in)) != null) {
            if (!line.equals(footers[0]) && !line.equals(footers[1])) continue;
            haveFooter = true;
            break;
        }
        return haveHeader && haveFooter;
    }
}

