/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.jce.exception.ExtCertPathBuilderException;
import kz.gamma.jce.provider.AnnotatedException;
import kz.gamma.jce.provider.CertPathValidatorUtilities;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.util.Selector;
import kz.gamma.x509.ExtendedPKIXBuilderParameters;
import kz.gamma.x509.ExtendedPKIXParameters;
import kz.gamma.x509.X509AttributeCertStoreSelector;
import kz.gamma.x509.X509AttributeCertificate;
import kz.gamma.x509.X509CertStoreSelector;

public class PKIXAttrCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection targets;
        if (!(params instanceof PKIXBuilderParameters) && !(params instanceof ExtendedPKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + ExtendedPKIXBuilderParameters.class.getName() + ".");
        }
        ExtendedPKIXBuilderParameters pkixParams = params instanceof ExtendedPKIXBuilderParameters ? (ExtendedPKIXBuilderParameters)params : (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance((PKIXBuilderParameters)params);
        ArrayList certPathList = new ArrayList();
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509AttributeCertStoreSelector)) {
            throw new CertPathBuilderException("TargetConstraints must be an instance of " + X509AttributeCertStoreSelector.class.getName() + " for " + this.getClass().getName() + " class.");
        }
        try {
            targets = CertPathValidatorUtilities.findCertificates(certSelect, pkixParams.getStores());
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathBuilderException("Error finding target attribute certificate.", e);
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("No attribute certificate found matching targetContraints.");
        }
        CertPathBuilderResult result = null;
        Iterator targetIter = targets.iterator();
        while (targetIter.hasNext() && result == null) {
            X509AttributeCertificate cert = (X509AttributeCertificate)targetIter.next();
            X509CertStoreSelector selector = new X509CertStoreSelector();
            Principal[] principals = cert.getIssuer().getPrincipals();
            HashSet issuers = new HashSet();
            for (int i = 0; i < principals.length; ++i) {
                try {
                    if (principals[i] instanceof X500Principal) {
                        selector.setSubject(((X500Principal)principals[i]).getEncoded());
                    }
                    issuers.addAll(CertPathValidatorUtilities.findCertificates(selector, pkixParams.getStores()));
                    continue;
                }
                catch (AnnotatedException e) {
                    throw new ExtCertPathBuilderException("Public key certificate for attribute certificate cannot be searched.", e);
                }
                catch (IOException e) {
                    throw new ExtCertPathBuilderException("cannot encode X500Proncipal.", e);
                }
            }
            if (issuers.isEmpty()) {
                throw new CertPathBuilderException("Public key certificate for attribute certificate cannot be found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && result == null) {
                result = this.build(cert, (X509Certificate)it.next(), pkixParams, certPathList);
            }
        }
        if (result == null && this.certPathException != null) {
            throw new ExtCertPathBuilderException("Possible certificate chain could not be validated.", this.certPathException);
        }
        if (result == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return result;
    }

    private CertPathBuilderResult build(X509AttributeCertificate attrCert, X509Certificate tbvCert, ExtendedPKIXBuilderParameters pkixParams, List tbvPath) {
        CertPathValidator validator;
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return null;
        }
        tbvPath.add(tbvCert);
        CertPathBuilderResult builderResult = null;
        try {
            cFact = CertificateFactory.getInstance("X.509", GammaTechProvider.PROVIDER_NAME);
            validator = CertPathValidator.getInstance("PKIX", GammaTechProvider.PROVIDER_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (this.findTrustAnchor(tbvCert, pkixParams.getTrustAnchors()) != null) {
                PKIXCertPathValidatorResult result;
                CertPath certPath;
                try {
                    certPath = cFact.generateCertPath(tbvPath);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", e);
                }
                try {
                    result = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixParams);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be validated.", e);
                }
                return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
            }
            try {
                this.addAdditionalStoresFromAltNames(tbvCert, pkixParams);
            }
            catch (CertificateParsingException e) {
                throw new AnnotatedException("No additiontal X.509 stores can be added from certificate locations.", e);
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(this.findIssuerCerts(tbvCert, pkixParams.getStores()));
                if (issuers.isEmpty()) {
                    issuers.addAll(this.findIssuerCerts(tbvCert, pkixParams.getAddionalStores()));
                }
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", e);
            }
            if (issuers.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && builderResult == null) {
                X509Certificate issuer = (X509Certificate)it.next();
                if (issuer.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) continue;
                builderResult = this.build(attrCert, issuer, pkixParams, tbvPath);
            }
        }
        catch (AnnotatedException e) {
            this.certPathException = new AnnotatedException("No valid certification path could be build.", e);
        }
        if (builderResult == null) {
            tbvPath.remove(tbvCert);
        }
        return builderResult;
    }

    private void addAdditionalStoresFromAltNames(X509Certificate cert, ExtendedPKIXParameters pkixParams) throws CertificateParsingException {
        if (cert.getIssuerAlternativeNames() != null) {
            for (List<?> list : cert.getIssuerAlternativeNames()) {
                if (!list.get(0).equals(new Integer(6))) continue;
                String temp = (String)list.get(1);
                CertPathValidatorUtilities.addAdditionalStoreFromLocation(temp, pkixParams);
            }
        }
    }

    private TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors) throws AnnotatedException {
        Iterator iter = trustAnchors.iterator();
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        try {
            certSelectX509.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException ex) {
            throw new AnnotatedException("Cannot set subject search criteria for trust anchor.", ex);
        }
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = (TrustAnchor)iter.next();
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal certIssuer = cert.getIssuerX500Principal();
                        if (certIssuer.getName().equals(trust.getCAName())) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new AnnotatedException("Trust anchor found, but certificate validation failed for certificate.", invalidKeyEx);
        }
        return trust;
    }

    private Collection findIssuerCerts(X509Certificate cert, List certStores) throws AnnotatedException {
        Iterator iter;
        X509CertStoreSelector certSelect = new X509CertStoreSelector();
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        try {
            certSelect.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException ex) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", ex);
        }
        try {
            iter = CertPathValidatorUtilities.findCertificates(certSelect, certStores).iterator();
        }
        catch (AnnotatedException e) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", e);
        }
        AnnotatedException lastException = null;
        boolean issuerCertFound = false;
        while (iter.hasNext()) {
            X509Certificate issuer = (X509Certificate)iter.next();
            try {
                cert.verify(issuer.getPublicKey());
                certs.add(issuer);
                issuerCertFound = true;
            }
            catch (Exception ex) {
                lastException = new AnnotatedException("Issued certificate could not be verified with issuer certificate.", ex);
            }
        }
        if (!issuerCertFound && lastException != null) {
            throw new AnnotatedException("Issuer certificate found but certificate validation failed for certificate.", lastException);
        }
        return certs;
    }
}

