/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.jce.provider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import kz.gamma.jce.exception.ExtCertPathBuilderException;
import kz.gamma.jce.provider.AnnotatedException;
import kz.gamma.jce.provider.CertPathValidatorUtilities;
import kz.gamma.jce.provider.GammaTechProvider;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        CertPathValidator validator;
        CertificateFactory cFact;
        Collection targets;
        if (!(params instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pkixParams = (PKIXBuilderParameters)params;
        ArrayList<X509Certificate> certPathList = new ArrayList<X509Certificate>();
        HashSet<X509Certificate> certPathSet = new HashSet<X509Certificate>();
        CertPath certPath = null;
        GeneralSecurityException certPathException = null;
        CertSelector certSelect = pkixParams.getTargetCertConstraints();
        if (certSelect == null) {
            throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
        }
        try {
            targets = CertPathValidatorUtilities.findCertificates(certSelect, pkixParams.getCertStores());
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathBuilderException("Error finding target certificate.", e.getCause());
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("no certificate found matching targetCertContraints");
        }
        try {
            cFact = CertificateFactory.getInstance("X.509", GammaTechProvider.PROVIDER_NAME);
            validator = CertPathValidator.getInstance("PKIX", GammaTechProvider.PROVIDER_NAME);
        }
        catch (Exception e) {
            throw new CertPathBuilderException("exception creating support classes: " + e);
        }
        for (X509Certificate cert : targets) {
            certPathList.clear();
            certPathSet.clear();
            while (cert != null) {
                certPathList.add(cert);
                certPathSet.add(cert);
                if (this.findTrustAnchor(cert, pkixParams.getTrustAnchors()) != null) {
                    try {
                        certPath = cFact.generateCertPath(certPathList);
                        PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixParams);
                        return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
                    }
                    catch (CertificateException ex) {
                        certPathException = ex;
                    }
                    catch (CertPathValidatorException ex) {
                        certPathException = ex;
                    }
                    cert = null;
                    continue;
                }
                try {
                    X509Certificate issuer = this.findIssuer(cert, pkixParams.getCertStores());
                    if (issuer.equals(cert)) {
                        cert = null;
                        continue;
                    }
                    cert = issuer;
                    if (!certPathSet.contains(cert)) continue;
                    cert = null;
                }
                catch (CertPathValidatorException ex) {
                    certPathException = ex;
                    cert = null;
                }
            }
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certificate chain, but could not be validated", certPathException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    final TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors) throws CertPathBuilderException {
        Iterator iter = trustAnchors.iterator();
        TrustAnchor trust = null;
        PublicKey trustPublicKey = null;
        Exception invalidKeyEx = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        try {
            certSelectX509.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException ex) {
            throw new CertPathBuilderException("can't get trust anchor principal", null);
        }
        while (iter.hasNext() && trust == null) {
            block15: {
                trust = (TrustAnchor)iter.next();
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    } else {
                        trust = null;
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal certIssuer = cert.getIssuerX500Principal();
                        X500Principal caName = new X500Principal(trust.getCAName());
                        if (certIssuer.equals(caName)) {
                            trustPublicKey = trust.getCAPublicKey();
                            break block15;
                        }
                        trust = null;
                    }
                    catch (IllegalArgumentException ex) {
                        trust = null;
                    }
                } else {
                    trust = null;
                }
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                trust = null;
            }
        }
        if (trust == null && invalidKeyEx != null) {
            throw new CertPathBuilderException("TrustAnchor found put certificate validation failed", invalidKeyEx);
        }
        return trust;
    }

    private X509Certificate findIssuer(X509Certificate cert, List certStores) throws CertPathValidatorException {
        Iterator iter;
        Exception invalidKeyEx = null;
        X509CertSelector certSelect = new X509CertSelector();
        try {
            certSelect.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException ex) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        try {
            iter = CertPathValidatorUtilities.findCertificates(certSelect, certStores).iterator();
        }
        catch (AnnotatedException e) {
            throw new CertPathValidatorException(e.getCause());
        }
        X509Certificate issuer = null;
        while (iter.hasNext() && issuer == null) {
            issuer = (X509Certificate)iter.next();
            try {
                cert.verify(issuer.getPublicKey());
            }
            catch (Exception ex) {
                invalidKeyEx = ex;
                issuer = null;
            }
        }
        if (issuer == null && invalidKeyEx == null) {
            throw new CertPathValidatorException("Issuer not found", null, null, -1);
        }
        if (issuer == null && invalidKeyEx != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)invalidKeyEx, null, -1);
        }
        return issuer;
    }
}

