/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.io.Serializable;
import kz.gamma.core.UtilCM;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;

public class CSPUtil
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePasswd(String profile, String oldPass, String newPass) {
        Number hProvLocal = 0;
        try {
            oldPass = oldPass == null ? "" : oldPass.trim();
            String string = newPass = newPass == null ? "" : newPass.trim();
            if (newPass.length() < 7) {
                throw new IllegalArgumentException("The password must be more than 6 digits");
            }
            String newURL = UtilCM.getUrl(profile, oldPass, 0);
            hProvLocal = TumarCspFunctions.cpAcquireContext(newURL, 64, LibraryWrapper.PV_TABLE);
            TumarCspFunctions.cpSetProvParam(hProvLocal, 7, newPass.getBytes(), 0);
        }
        finally {
            if (hProvLocal.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvLocal, 0);
            }
        }
    }

    private int getAlgType(int x) {
        return x & 0x1E00;
    }

    public int getTypeKey(Number hProv, Number hKey) {
        byte[] algId = TumarCspFunctions.cpGetKeyParamData(hProv, hKey, 7, 0);
        int result = UtilCM.byteToInt(algId, 0, 1);
        return this.getTypeKey(result);
    }

    public int getTypeKey(int algId) {
        int type = 2;
        int isDH = 1024;
        int isRSA = 2560;
        type = this.getAlgType(algId) == isDH || this.getAlgType(algId) == isRSA ? 2 : 1;
        return type;
    }
}

