/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.swing.JApplet;
import kz.gamma.asn1.ASN1InputStream;
import kz.gamma.asn1.DERObjectIdentifier;
import kz.gamma.asn1.DEROctetString;
import kz.gamma.asn1.DERSequence;
import kz.gamma.core.file.FileHelper;
import kz.gamma.core.utils.DateUtils;
import kz.gamma.crypto.pcsc.idcard.IdCard;
import kz.gamma.crypto.pcsc.idcard.IdCardInfo;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.CertificateFieldsResolver;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.profile.ProfileCreator;
import kz.gamma.tumarcsp.profile.ProfileInfo;
import kz.gamma.tumarcsp.profile.ProfileList;
import kz.gamma.util.encoders.Base64;
import kz.gamma.x509.X509InstanceGetter;

public class CommonApplet
extends JApplet {
    private static GammaTechProvider gammaTechProvider = null;
    private static final int PROVIDER_NOT_LOADED = 0;
    private static final int PROVIDER_LOADED = 1;
    private static final int PROVIDER_UNKNOWN_STATE = 2;
    private static final long serialVersionUID = 5522436105255512983L;
    private static Integer providerState = 2;
    public static String COLUMN_SEPARATOR = "|col|";
    public static String IN_COLUMN_SEPARATOR = "\\|col\\|";
    public static String ROW_SEPARATOR = "|row|";
    public static String IN_ROW_SEPARATOR = "\\|row\\|";
    protected DateFormat sdfShort = new SimpleDateFormat("dd/MM/yyyy");
    protected DateFormat sdfFull = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
    protected String lastError = "";
    protected static final String NULL_AS_STRING = "null";

    @Override
    public void init() {
        super.init();
        System.out.println("CommonApplet loading...");
        try {
            System.out.println("CommonApplet. Implementation-Title: " + CommonApplet.class.getPackage().getImplementationTitle());
            System.out.println("CommonApplet. Implementation-Version: " + CommonApplet.class.getPackage().getImplementationVersion());
            System.out.println("CommonApplet. Implementation-Vendor: " + CommonApplet.class.getPackage().getImplementationVendor());
        }
        catch (Throwable t) {
            System.out.println("CommonApplet. Implementation-Title: unknown");
            System.out.println("CommonApplet. Implementation-Version: unknown");
            System.out.println("CommonApplet. Implementation-Vendor: unknown");
        }
        try {
            this.sdfShort.setTimeZone(new SimpleTimeZone(0, "Z"));
            this.sdfFull.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        catch (Throwable t) {
            System.out.println("Cannot set time zones");
        }
        CommonApplet.loadProvider();
        System.out.println("CommonApplet loaded");
    }

    @Override
    public void destroy() {
        System.out.println("CommonApplet unloading...");
        CommonApplet.unloadProvider();
        System.out.println("CommonApplet unloaded");
        super.destroy();
    }

    protected static void loadProvider() {
        try {
            if (!providerState.equals(1)) {
                gammaTechProvider = new GammaTechProvider();
                Security.addProvider(gammaTechProvider);
                providerState = 1;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            providerState = 0;
        }
    }

    protected static void unloadProvider() {
        try {
            if (providerState.equals(1)) {
                Security.removeProvider(GammaTechProvider.PROVIDER_NAME);
                gammaTechProvider = null;
                providerState = 2;
            }
            providerState = 2;
        }
        catch (Throwable e) {
            e.printStackTrace();
            providerState = 2;
        }
    }

    protected void checkProvider() throws Exception {
        if (!providerState.equals(1)) {
            throw new Exception("\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043b\u0438 \u043a\u0440\u0438\u043f\u0442\u043e\u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440");
        }
    }

    public boolean isProviderLoaded() {
        try {
            this.lastError = "";
            this.checkProvider();
            return true;
        }
        catch (Throwable e) {
            this.lastError = e.getMessage();
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDn(String profile, int keySpec) {
        Number handleProv = 0;
        Number handleKey = 0;
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals(NULL_AS_STRING) ? null : profile;
            boolean profileChecking = ProfileParams.isProfile(profile);
            if (profileChecking) {
                profile = ProfileParams.getProfileName(profile, true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64, LibraryWrapper.PV_TABLE);
            if (profileChecking) {
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, keySpec);
            } else {
                ProfileInfo profileInfo = new ProfileInfo();
                int profileKeySpec = profileInfo.getKeySpec(profile, 64);
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, profileKeySpec);
            }
            byte[] userCertificateBytes = TumarCspFunctions.cpGetKeyParamData(handleProv, handleKey, 26, 0);
            X509InstanceGetter instanceGetter = new X509InstanceGetter();
            X509Certificate userCertificate = instanceGetter.getX509CertificateInstance(userCertificateBytes);
            String string = ((Object)userCertificate.getSubjectDN()).toString();
            return string;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043c\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }

    public String createProfile(String name, String dev, String user, String password, String param, String cont, int algExch, int algSign) {
        try {
            this.lastError = "";
            this.checkProvider();
            name = name != null && name.equals(NULL_AS_STRING) ? null : name;
            dev = dev != null && dev.equals(NULL_AS_STRING) ? null : dev;
            user = user != null && user.equals(NULL_AS_STRING) ? null : user;
            password = password != null && password.equals(NULL_AS_STRING) ? null : password;
            param = param != null && param.equals(NULL_AS_STRING) ? null : param;
            cont = cont != null && cont.equals(NULL_AS_STRING) ? null : cont;
            ProfileCreator profileCreator = new ProfileCreator();
            return profileCreator.createProfile(name, dev, user, password, param, cont, algExch, algSign);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0440\u043e\u0444\u0430\u0439\u043b (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public boolean isProfileExists(String profile) {
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals(NULL_AS_STRING) ? null : profile;
            ProfileInfo profileInfo = new ProfileInfo();
            boolean result = profileInfo.isProfileExists(profile);
            if (!result) {
                throw new Exception("\u041f\u0440\u043e\u0444\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 " + profile);
            }
            return result;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0430\u0439\u043b\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String getProfiles() {
        try {
            this.lastError = "";
            this.checkProvider();
            ProfileList profileList = new ProfileList();
            List<String> resultList = profileList.getProfiles(false);
            StringBuilder stringBuilder = new StringBuilder();
            for (String value : resultList) {
                stringBuilder.append(value).append(COLUMN_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u043c\u0435\u043d \u043f\u0440\u043e\u0444\u0430\u0439\u043b\u043e\u0432 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String getTumarCspBuild() {
        try {
            this.lastError = "";
            this.checkProvider();
            return GammaTechProvider.getTumarCspBuild();
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e \u0441\u0431\u043e\u0440\u043a\u0438 \u043a\u0440\u0438\u043f\u0442\u043e\u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 TumarCSP (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String getLastError() {
        return this.lastError;
    }

    public boolean saveData(String data, String path) {
        try {
            this.lastError = "";
            this.checkProvider();
            data = data != null && data.equals(NULL_AS_STRING) ? null : data;
            path = path != null && path.equals(NULL_AS_STRING) ? null : path;
            FileHelper fileHelper = new FileHelper();
            fileHelper.saveData(Base64.decode(data), path);
            return true;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b \"" + path + "\" (" + e.getMessage() + ")";
            e.printStackTrace();
            return false;
        }
    }

    public String loadData(String path) {
        try {
            this.lastError = "";
            this.checkProvider();
            path = path != null && path.equals(NULL_AS_STRING) ? null : path;
            FileHelper fileHelper = new FileHelper();
            byte[] fileContent = fileHelper.loadData(path);
            byte[] result = Base64.encode(fileContent);
            return new String(result);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \"" + path + "\" (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    public String createDialog(String extensions, String description, int type) {
        try {
            this.lastError = "";
            this.checkProvider();
            List<String> list = null;
            String string = description = description == null || description.equals(NULL_AS_STRING) ? "" : description;
            if (extensions != null && !extensions.equals(NULL_AS_STRING) && extensions.trim().length() > 0) {
                String[] est = extensions.split(IN_COLUMN_SEPARATOR);
                list = Arrays.asList(est);
            }
            FileHelper fileHelper = new FileHelper();
            return fileHelper.createDialog(list, description, type);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCertificatePolicies(String profile, int keySpec) {
        FilterInputStream extensionStream = null;
        Number handleProv = 0;
        Number handleKey = 0;
        try {
            this.lastError = "";
            this.checkProvider();
            StringBuilder stringBuilder = new StringBuilder("");
            profile = profile != null && profile.equals(NULL_AS_STRING) ? null : profile;
            boolean profileChecking = ProfileParams.isProfile(profile);
            if (profileChecking) {
                profile = ProfileParams.getProfileName(profile, true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64, LibraryWrapper.PV_TABLE);
            if (profileChecking) {
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, keySpec);
            } else {
                ProfileInfo profileInfo = new ProfileInfo();
                int profileKeySpec = profileInfo.getKeySpec(profile, 64);
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, profileKeySpec);
            }
            byte[] userCertificateBytes = TumarCspFunctions.cpGetKeyParamData(handleProv, handleKey, 26, 0);
            X509InstanceGetter instanceGetter = new X509InstanceGetter();
            X509Certificate userCertificate = instanceGetter.getX509CertificateInstance(userCertificateBytes);
            byte[] extensionBytes = userCertificate.getExtensionValue("2.5.29.32");
            if (extensionBytes != null) {
                extensionStream = new ASN1InputStream(extensionBytes);
                DEROctetString octetString = (DEROctetString)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                extensionStream = new ASN1InputStream(octetString.getOctets());
                DERSequence sequence = (DERSequence)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                Enumeration policies = sequence.getObjects();
                while (policies.hasMoreElements()) {
                    DERSequence nextElement = (DERSequence)policies.nextElement();
                    DERObjectIdentifier identifier = (DERObjectIdentifier)nextElement.getObjectAt(0);
                    stringBuilder.append(identifier.getId()).append(COLUMN_SEPARATOR);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
                }
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (extensionStream != null) {
                try {
                    extensionStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCertificateChain(String profile, int keySpec, String caCertificate) {
        Number handleProv = 0;
        Number handleKey = 0;
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals(NULL_AS_STRING) ? null : profile;
            caCertificate = caCertificate != null && caCertificate.equals(NULL_AS_STRING) ? null : caCertificate;
            boolean profileChecking = ProfileParams.isProfile(profile);
            if (profileChecking) {
                profile = ProfileParams.getProfileName(profile, true);
            }
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64, LibraryWrapper.PV_TABLE);
            if (profileChecking) {
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, keySpec);
            } else {
                ProfileInfo profileInfo = new ProfileInfo();
                int profileKeySpec = profileInfo.getKeySpec(profile, 64);
                handleKey = TumarCspFunctions.cpGetUserKey(handleProv, profileKeySpec);
            }
            byte[] userCertificateBytes = TumarCspFunctions.cpGetKeyParamData(handleProv, handleKey, 26, 0);
            X509InstanceGetter instanceGetter = new X509InstanceGetter();
            X509Certificate x509userCertificate = instanceGetter.getX509CertificateInstance(userCertificateBytes);
            X509Certificate x509caCert = instanceGetter.getX509CertificateInstance(Base64.decode(caCertificate));
            x509userCertificate.verify(x509caCert.getPublicKey());
            x509caCert.verify(x509caCert.getPublicKey());
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0446\u0435\u043f\u043e\u0447\u043a\u0443 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 (" + e.getMessage() + ")";
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (handleKey.longValue() != 0L) {
                TumarCspFunctions.cpDestroyKey(handleProv, handleKey);
            }
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }

    public String getCertificateSerialNumber(String certificatePath) {
        try {
            this.lastError = "";
            this.checkProvider();
            certificatePath = certificatePath != null && certificatePath.equals(NULL_AS_STRING) ? null : certificatePath;
            FileHelper fileHelper = new FileHelper();
            byte[] certificateBytes = fileHelper.loadData(certificatePath);
            X509InstanceGetter instanceGetter = new X509InstanceGetter();
            X509Certificate x509certificate = instanceGetter.getX509CertificateInstance(certificateBytes);
            CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();
            String serialNumber = (String)certificateFieldsResolver.getSerialNumber(x509certificate, (Integer)0);
            return serialNumber;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u0441\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 (" + e.getMessage() + "). \u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432 DER-\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435.";
            e.printStackTrace();
            return null;
        }
    }

    public Integer getKeySpec(String url, int acquireContextFlag) {
        try {
            this.lastError = "";
            this.checkProvider();
            url = url != null && url.equals(NULL_AS_STRING) ? null : url;
            ProfileInfo profileInfo = new ProfileInfo();
            return profileInfo.getKeySpec(url, acquireContextFlag);
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043b\u044e\u0447\u0430 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserCertificates(String profile) {
        Number handleProv = 0;
        try {
            this.lastError = "";
            this.checkProvider();
            profile = profile != null && profile.equals(NULL_AS_STRING) ? null : profile;
            boolean profileChecking = ProfileParams.isProfile(profile);
            if (!profileChecking) {
                throw new IllegalArgumentException("Use profile instead of url");
            }
            profile = ProfileParams.getProfileName(profile, true);
            handleProv = TumarCspFunctions.cpAcquireContext(profile, 64, LibraryWrapper.PV_TABLE);
            KeyParams keyParams = new KeyParams(handleProv);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < keyParams.getLength(); ++i) {
                boolean[] keyUsageArray;
                Object certificate = keyParams.getCertificateList()[i];
                if (certificate == null) continue;
                X509Certificate x509cert = (X509Certificate)certificate;
                stringBuilder.append(new String(Base64.encode(x509cert.getEncoded()))).append(COLUMN_SEPARATOR);
                stringBuilder.append(x509cert.getSubjectDN().getName()).append(COLUMN_SEPARATOR);
                Object oid = keyParams.getSzOIDList()[i];
                stringBuilder.append((String)oid).append(COLUMN_SEPARATOR);
                for (boolean keyUsageValue : keyUsageArray = x509cert.getKeyUsage()) {
                    if (keyUsageValue) {
                        stringBuilder.append("1");
                        continue;
                    }
                    stringBuilder.append("0");
                }
                stringBuilder.append(COLUMN_SEPARATOR);
                List<String> extendedKeyUsageList = x509cert.getExtendedKeyUsage();
                if (extendedKeyUsageList != null) {
                    for (int j = 0; j < extendedKeyUsageList.size(); ++j) {
                        String extendedKeyUsageValue = extendedKeyUsageList.get(j);
                        stringBuilder.append(extendedKeyUsageValue);
                        if (j >= extendedKeyUsageList.size() - 1) continue;
                        stringBuilder.append(",");
                    }
                }
                stringBuilder.append(COLUMN_SEPARATOR);
                String notBefore = DateUtils.getInstance().dateToString(x509cert.getNotBefore(), "dd/MM/yyyy");
                String notAfter = DateUtils.getInstance().dateToString(x509cert.getNotAfter(), "dd/MM/yyyy");
                stringBuilder.append(notBefore).append(COLUMN_SEPARATOR);
                stringBuilder.append(notAfter).append(COLUMN_SEPARATOR);
                Object serialNumber = keyParams.getSerialNumList()[i];
                String url = TumarCspFunctions.cpUrlToNewUrl(profile, (String)serialNumber, 1, handleProv);
                stringBuilder.append(url).append(ROW_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e \u0441\u0431\u043e\u0440\u043a\u0438 \u043a\u0440\u0438\u043f\u0442\u043e\u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 TumarCSP (" + e.getMessage() + ")";
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }

    public String getIdCardInfo() {
        try {
            this.lastError = "";
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    IdCard idCard = null;
                    try {
                        idCard = new IdCard();
                        StringBuilder stringBuilder = new StringBuilder();
                        Map cards = idCard.getCards();
                        Iterator i$ = cards.entrySet().iterator();
                        while (i$.hasNext()) {
                            Map.Entry o;
                            Map.Entry entry = o = i$.next();
                            String key = (String)entry.getKey();
                            IdCardInfo idCardInfo = new IdCardInfo(idCard, key);
                            Map info = idCardInfo.getInfo();
                            stringBuilder.append(info.get("iin")).append(COLUMN_SEPARATOR);
                            stringBuilder.append(info.get("number")).append(COLUMN_SEPARATOR);
                            stringBuilder.append(info.get("lastName")).append(COLUMN_SEPARATOR);
                            stringBuilder.append(info.get("firstName")).append(COLUMN_SEPARATOR);
                            stringBuilder.append(info.get("middleName")).append(COLUMN_SEPARATOR);
                            Date birthDate = (Date)info.get("birthDate");
                            String birthDateAsString = "";
                            if (birthDate != null) {
                                birthDateAsString = DateUtils.getInstance().dateToString(birthDate, "dd/MM/yyyy");
                            }
                            stringBuilder.append(birthDateAsString).append(ROW_SEPARATOR);
                        }
                        if (stringBuilder.length() > 0) {
                            stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
                        }
                        String string = stringBuilder.toString();
                        return string;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (idCard != null) {
                            idCard.disconnect();
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 Id Card. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043b\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043a \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0443 \u0438 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043b\u0438 \u0432 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0441\u0435\u0440\u0432\u0438\u0441 \u0441\u043c\u0430\u0440\u0442-\u043a\u0430\u0440\u0442 (" + e.getMessage() + ")";
            e.printStackTrace();
            return null;
        }
    }
}

