/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.params.StoreObjectParam;

public class ProfileParams {
    public Hashtable<String, KeyParams> profileList = new Hashtable();
    public List<StoreObjectParam> lst = new ArrayList<StoreObjectParam>();

    public ProfileParams() throws NoSuchProviderException, ParseException, CertificateException {
        this.createList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createList() throws NoSuchProviderException, ParseException, CertificateException {
        Number hProvOuter = 0;
        Number hProvInner = 0;
        try {
            hProvOuter = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
            int dwFlags = 1;
            byte[] result = new byte[1];
            while (result != null) {
                try {
                    result = TumarCspFunctions.cpGetProvParamByte(hProvOuter, 57, dwFlags, 0);
                    if (result == null) continue;
                    String profile = new String(result, 0, this.getSize(result, 0));
                    profile = ProfileParams.getProfileName(profile, true);
                    hProvInner = TumarCspFunctions.cpAcquireContext(profile, 64, LibraryWrapper.PV_TABLE);
                    KeyParams pKey = new KeyParams(hProvInner);
                    this.profileList.put(profile, pKey);
                    Object[] oidList = pKey.getSzOIDList();
                    Object[] certList = pKey.getCertificateList();
                    Object[] snList = pKey.getSerialNumList();
                    for (int i = 0; i < pKey.getLength(); ++i) {
                        if (oidList[i] == null || certList[i] == null || snList[i] == null) continue;
                        StoreObjectParam prm = new StoreObjectParam(profile, pKey, i);
                        this.lst.add(prm);
                    }
                    if (hProvInner.longValue() != 0L) {
                        TumarCspFunctions.cpReleaseContext(hProvInner, 0);
                        hProvInner = 0;
                    }
                    dwFlags = 0;
                }
                catch (Exception e) {
                    dwFlags = 0;
                }
            }
        }
        finally {
            if (hProvInner.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvInner, 0);
            }
            if (hProvOuter.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProvOuter, 0);
            }
        }
    }

    public int getSize(byte[] data, int offset) {
        return DataConverter.getSizeWithoutNulls(data, offset);
    }

    public static String getProfileName(String profile, Boolean isPrefixNeed) {
        if (profile == null) {
            return null;
        }
        if (profile.trim().length() == 0) {
            return profile;
        }
        if (ProfileParams.isProfile(profile)) {
            if (isPrefixNeed.booleanValue()) {
                if (!profile.trim().startsWith("profile://")) {
                    return "profile://".concat(profile);
                }
            } else if (!isPrefixNeed.booleanValue() && profile.trim().startsWith("profile://")) {
                return profile.substring("profile://".length());
            }
        }
        return profile;
    }

    public static boolean isProfile(String profile) {
        return !profile.contains("://") || profile.contains("profile://");
    }
}

