/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp;

import kz.gamma.core.UtilCM;
import kz.gamma.jce.exception.CSPException;
import kz.gamma.jce.provider.GammaTechProvider;
import kz.gamma.tumarcsp.DataConverter;
import kz.gamma.tumarcsp.ErrorResolver;
import kz.gamma.tumarcsp.LibraryWrapper;

public class TumarCspFunctions
extends LibraryWrapper {
    public static int getLibraryBit() {
        return libraryBit;
    }

    @Deprecated
    public static Number cpAcquireContext(String pszContainer, int dwFlags, int pVTable, byte[] reserved) {
        Integer pvTable = pVTable;
        return TumarCspFunctions.cpAcquireContext(pszContainer, dwFlags, pvTable);
    }

    public static Number cpAcquireContext(String pszContainer, int dwFlags, Number pVTable) {
        Number hProv;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            hProv = LibraryWrapper.cpAcquireContext(pszContainer, dwFlags, pVTable.intValue());
            if (hProv.intValue() == 0 && dwFlags != 16) {
                throw new CSPException(new ErrorResolver(hProv), "Error load profile ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            hProv = LibraryWrapper.cpAcquireContext(pszContainer, dwFlags, pVTable.longValue());
            if (hProv.longValue() == 0L && dwFlags != 16) {
                throw new CSPException(new ErrorResolver(hProv), "Error load profile ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return hProv;
    }

    public static int cpReleaseContext(Number hProv, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpReleaseContext(hProv.intValue(), dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpReleaseContext(hProv.longValue(), dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error release csp context ");
        }
        return ret;
    }

    public static int cpSetProvParam(Number hProv, int dwParam, byte[] pbData, int dwFlags) {
        int ret;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            ret = LibraryWrapper.cpSetProvParam(hProv.intValue(), dwParam, pbData, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            ret = LibraryWrapper.cpSetProvParam(hProv.longValue(), dwParam, pbData, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error set provider param (" + dwParam + ") ");
        }
        return ret;
    }

    public static int cpGetProvParamSize(Number hProv, int dwParam, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetProvParamSize(hProv.intValue(), dwParam, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetProvParamSize(hProv.longValue(), dwParam, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error get provider param size (" + dwParam + ") ");
        }
        return ret;
    }

    public static int cpSetKeyParam(Number hProv, Number hKey, int dwParam, byte[] pbData, int dwFlags) {
        int ret;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpSetKeyParam(hProv.intValue(), hKey.intValue(), dwParam, pbData, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpSetKeyParam(hProv.longValue(), hKey.longValue(), dwParam, pbData, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error set key param (" + dwParam + ") ");
        }
        return ret;
    }

    public static int cpGetKeyParamSize(Number hProv, Number hKey, int dwParam, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpGetKeyParamSize(hProv.intValue(), hKey.intValue(), dwParam, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpGetKeyParamSize(hProv.longValue(), hKey.longValue(), dwParam, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error get key param size (" + dwParam + ") ");
        }
        return ret;
    }

    public static byte[] cpGetKeyParamData(Number hProv, Number hKey, int dwParam, int dwFlags) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpGetKeyParamData(hProv.intValue(), hKey.intValue(), dwParam, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpGetKeyParamData(hProv.longValue(), hKey.longValue(), dwParam, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            CSPException e = new CSPException(new ErrorResolver(hProv), "Error get key param data (" + dwParam + ") ");
            if (!e.errorRes.errorStr.equals("80090011") || dwParam != 26 && dwParam != 68) {
                throw e;
            }
        } else if (dwParam == 7 || dwParam == 123 || dwParam == 80 || dwParam == 77 || dwParam == 75 || dwParam == 76 || dwParam == 110) {
            ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
        }
        return ret;
    }

    public static int cpDestroyKey(Number hProv, Number hKey) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpDestroyKey(hProv.intValue(), hKey.intValue());
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpDestroyKey(hProv.longValue(), hKey.longValue());
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error destroy key ");
        }
        return ret;
    }

    public static int cpExportKeySize(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpExportKeySize(hProv.intValue(), hKey.intValue(), hExpKey.intValue(), dwBlobType, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpExportKeySize(hProv.longValue(), hKey.longValue(), hExpKey.longValue(), dwBlobType, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key size ");
        }
        return ret;
    }

    public static byte[] cpExportKeyData(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpExportKeyData(hProv.intValue(), hKey.intValue(), hExpKey.intValue(), dwBlobType, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpExportKeyData(hProv.longValue(), hKey.longValue(), hExpKey.longValue(), dwBlobType, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return ret;
    }

    public static byte[] cpExportKeyData(Number hProv, Number hKey, byte[] pubKeyData, int dwBlobType, int dwFlags) {
        byte[] ret;
        pubKeyData = DataConverter.byteArrayToByteArray(pubKeyData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpExportKeyDataSecond(hProv.intValue(), hKey.intValue(), pubKeyData, dwBlobType, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpExportKeyDataSecond(hProv.longValue(), hKey.longValue(), pubKeyData, dwBlobType, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return ret;
    }

    public static byte[] cpExportKeyDataEx(Number hProv, Number hKey, Number hExpKey, int dwBlobType, int dwFlags, int dwSizeBlob) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpExportKeyDataEx(hProv.intValue(), hKey.intValue(), hExpKey.intValue(), dwBlobType, dwFlags, dwSizeBlob);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpExportKeyDataEx(hProv.longValue(), hKey.longValue(), hExpKey.longValue(), dwBlobType, dwFlags, dwSizeBlob);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error export key data ");
        }
        return ret;
    }

    public static Number cpGetUserKey(Number hProv, int dwKeySpec) {
        Number phUserKey;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phUserKey = LibraryWrapper.cpGetUserKey(hProv.intValue(), dwKeySpec);
            if (phUserKey.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error get user key ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phUserKey = LibraryWrapper.cpGetUserKey(hProv.longValue(), dwKeySpec);
            if (phUserKey.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error get user key ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phUserKey;
    }

    public static Number cpImportKey(Number hProv, byte[] pbData, int dwDataLen, Number hPubKey, int dwFlags) {
        Number phKey;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpImportKey(hProv.intValue(), pbData, dwDataLen, hPubKey.intValue(), dwFlags);
            if (phKey.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error import key ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpImportKey(hProv.longValue(), pbData, dwDataLen, hPubKey.longValue(), dwFlags);
            if (phKey.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error import key ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phKey;
    }

    public static Number cpImportKey(Number hProv, byte[] pbData, int dwDataLen, byte[] impKeyData, int dwFlags) {
        Number phKey;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        impKeyData = DataConverter.byteArrayToByteArray(impKeyData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpImportKeySecond(hProv.intValue(), pbData, dwDataLen, impKeyData, dwFlags);
            if (phKey.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error import key ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpImportKeySecond(hProv.longValue(), pbData, dwDataLen, impKeyData, dwFlags);
            if (phKey.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error import key ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phKey;
    }

    public static Number cpCreateHash(Number hProv, int algId, Number hKey, int dwFlags) {
        Number pHash = 0;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            pHash = LibraryWrapper.cpCreateHash(hProv.intValue(), algId, hKey.intValue(), dwFlags);
            if (pHash.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error create hash. Algoritm (" + algId + ")");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            pHash = LibraryWrapper.cpCreateHash(hProv.longValue(), algId, hKey.longValue(), dwFlags);
            if (pHash.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error create hash. Algoritm (" + algId + ")");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return pHash;
    }

    public static int cpDestroyHash(Number hProv, Number phHash) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (phHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpDestroyHash(hProv.intValue(), phHash.intValue());
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (phHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpDestroyHash(hProv.longValue(), phHash.longValue());
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error destroy hash ");
        }
        return ret;
    }

    public static int cpGetHashParamSize(Number hProv, Number hHash, int dwParam, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpGetHashParamSize(hProv.intValue(), hHash.intValue(), dwParam, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpGetHashParamSize(hProv.longValue(), hHash.longValue(), dwParam, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error get hash param size (" + dwParam + ") ");
        }
        return ret;
    }

    public static byte[] cpGetHashParamData(Number hProv, Number hHash, int dwParam, int dwFlags) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpGetHashParamData(hProv.intValue(), hHash.intValue(), dwParam, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpGetHashParamData(hProv.longValue(), hHash.longValue(), dwParam, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error get hash param data (" + dwParam + ") ");
        }
        return ret;
    }

    public static int cpHashData(Number hProv, Number hHash, byte[] pbData, int dwDataLen, int dwFlags) {
        int ret;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpHashData(hProv.intValue(), hHash.intValue(), pbData, dwDataLen, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpHashData(hProv.longValue(), hHash.longValue(), pbData, dwDataLen, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error hash data ");
        }
        return ret;
    }

    public static int cpSignHashSize(Number hProv, Number hHash, int dwKeySpec, String sDescription, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashSize(hProv.intValue(), hHash.intValue(), dwKeySpec, sDescription, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashSize(hProv.longValue(), hHash.longValue(), dwKeySpec, sDescription, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error create sign ");
        }
        return ret;
    }

    public static byte[] cpSignHashData(Number hProv, Number hHash, int dwKeySpec, String sDescription, int dwFlags) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashData(hProv.intValue(), hHash.intValue(), dwKeySpec, sDescription, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashData(hProv.longValue(), hHash.longValue(), dwKeySpec, sDescription, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create sign ");
        }
        if (dwFlags == 0) {
            ret = UtilCM.inverseCopyByte(ret, 0, ret.length);
        }
        return ret;
    }

    public static byte[] cpSignHashData(Number hProv, Number hHash, int dwKeySpec, String sDescription, int dwFlags, int size) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashDataSecond(hProv.intValue(), hHash.intValue(), dwKeySpec, sDescription, dwFlags, size);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSignHashDataSecond(hProv.longValue(), hHash.longValue(), dwKeySpec, sDescription, dwFlags, size);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create sign ");
        }
        if (dwFlags == 0) {
            ret = UtilCM.inverseCopyByte(ret, 0, ret.length);
        }
        return ret;
    }

    public static int cpVerifySignature(Number hProv, Number hHash, byte[] pbSignature, int dwSigLen, Number hPubKey, String sDescription, int dwFlags) {
        int ret;
        byte[] pbSignatureBackward = UtilCM.inverseCopyByte(pbSignature, 0, pbSignature.length);
        pbSignatureBackward = DataConverter.byteArrayToByteArray(pbSignatureBackward);
        byte[] pbSignatureForward = DataConverter.byteArrayToByteArray(pbSignature);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpVerifySignature(hProv.intValue(), hHash.intValue(), pbSignatureForward, dwSigLen, hPubKey.intValue(), sDescription, dwFlags);
            if (ret == 0) {
                ret = LibraryWrapper.cpVerifySignature(hProv.intValue(), hHash.intValue(), pbSignatureBackward, dwSigLen, hPubKey.intValue(), sDescription, dwFlags);
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpVerifySignature(hProv.longValue(), hHash.longValue(), pbSignatureForward, dwSigLen, hPubKey.longValue(), sDescription, dwFlags);
            if (ret == 0) {
                ret = LibraryWrapper.cpVerifySignature(hProv.longValue(), hHash.longValue(), pbSignatureBackward, dwSigLen, hPubKey.longValue(), sDescription, dwFlags);
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error verify signature ");
        }
        return ret;
    }

    public static Number cpDeriveKey(Number hProv, int algId, Number hHash, int dwFlags) {
        Number ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpDeriveKey(hProv.intValue(), algId, hHash.intValue(), dwFlags);
            if (ret.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error derive key. Algorithm(" + algId + ") ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpDeriveKey(hProv.longValue(), algId, hHash.longValue(), dwFlags);
            if (ret.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error derive key. Algorithm(" + algId + ") ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return ret;
    }

    public static Number cpDuplicateKey(Number hProv, Number hKey, int dwFlags) {
        Number phKey;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not load");
            }
            phKey = LibraryWrapper.cpDuplicateKey(hProv.intValue(), hKey.intValue(), dwFlags);
            if (phKey.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error duplicate key ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not load");
            }
            phKey = LibraryWrapper.cpDuplicateKey(hProv.longValue(), hKey.longValue(), dwFlags);
            if (phKey.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error duplicate key ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phKey;
    }

    public static byte[] cpGenRandom(Number hProv, int dwLen) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGenRandom(hProv.intValue(), dwLen);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGenRandom(hProv.longValue(), dwLen);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error generate random bytes ");
        }
        return ret;
    }

    public static Number cpGenKey(Number hProv, int algId, int dwFlags) {
        Number phKey;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpGenKey(hProv.intValue(), algId, dwFlags);
            if (phKey.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error generate key. Algorithm(" + algId + ") ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            phKey = LibraryWrapper.cpGenKey(hProv.longValue(), algId, dwFlags);
            if (phKey.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error generate key. Algorithm(" + algId + ") ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phKey;
    }

    public static byte[] cpDecrypt(Number hProv, Number hKey, Number hHash, int bFinal, int dwFlags, byte[] pbData, int pdwDataLen) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpDecrypt(hProv.intValue(), hKey.intValue(), hHash.intValue(), bFinal, dwFlags, pbData, pdwDataLen);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpDecrypt(hProv.longValue(), hKey.longValue(), hHash.longValue(), bFinal, dwFlags, pbData, pdwDataLen);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error Decrypt data ");
        }
        return ret;
    }

    public static byte[] cpEncrypt(Number hProv, Number hKey, Number hHash, int bFinal, int dwFlags, byte[] pbData, int pdwDataLen, int dwBufLen) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpEncrypt(hProv.intValue(), hKey.intValue(), hHash.intValue(), bFinal, dwFlags, pbData, pdwDataLen, dwBufLen);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            ret = LibraryWrapper.cpEncrypt(hProv.longValue(), hKey.longValue(), hHash.longValue(), bFinal, dwFlags, pbData, pdwDataLen, dwBufLen);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error Encrypt data ");
        }
        return ret;
    }

    public static Number cpDuplicateHash(Number hProv, Number hHash, int dwFlags) {
        Number phHash;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            phHash = LibraryWrapper.cpDuplicateHash(hProv.intValue(), hHash.intValue(), dwFlags);
            if (phHash.intValue() == 0) {
                throw new CSPException(new ErrorResolver(hProv), "Error Duplicate Hash ");
            }
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            phHash = LibraryWrapper.cpDuplicateHash(hProv.longValue(), hHash.longValue(), dwFlags);
            if (phHash.longValue() == 0L) {
                throw new CSPException(new ErrorResolver(hProv), "Error Duplicate Hash ");
            }
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        return phHash;
    }

    public static int cpHashSessionKey(Number hProv, Number hHash, Number hKey, int dwFlags) {
        int ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.intValue() == 0) {
                throw new IllegalArgumentException("Key not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpHashSessionKey(hProv.intValue(), hHash.intValue(), hKey.intValue(), dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hKey.longValue() == 0L) {
                throw new IllegalArgumentException("Key not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpHashSessionKey(hProv.longValue(), hHash.longValue(), hKey.longValue(), dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error hash session key ");
        }
        return ret;
    }

    public static int cpSetHashParam(Number hProv, Number hHash, int dwParam, byte[] pbData, int dwFlags) {
        int ret;
        pbData = DataConverter.byteArrayToByteArray(pbData);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.intValue() == 0) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSetHashParam(hProv.intValue(), hHash.intValue(), dwParam, pbData, dwFlags);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            if (hHash.longValue() == 0L) {
                throw new IllegalArgumentException("Hash not create");
            }
            ret = LibraryWrapper.cpSetHashParam(hProv.longValue(), hHash.longValue(), dwParam, pbData, dwFlags);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == 0) {
            throw new CSPException(new ErrorResolver(hProv), "Error set hash param(" + dwParam + ") ");
        }
        return ret;
    }

    public static String cpCreateProfile(String name, String dev, String user, String pass, String param, String cont, int alg_exch, int alg_sign, Number hProv) {
        String ret;
        Integer algCodeExch = GammaTechProvider.getAlgUtil().getAlgCode(alg_exch);
        Integer algCodeSign = GammaTechProvider.getAlgUtil().getAlgCode(alg_sign);
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpCreateProfile(name, dev, user, pass, param, cont, (int)algCodeExch, (int)algCodeSign, hProv.intValue());
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpCreateProfile(name, dev, user, pass, param, cont, (int)algCodeExch, (int)algCodeSign, hProv.longValue());
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create profile ");
        }
        return ret;
    }

    public static String cpCreateUrl(String name, String dev, String user, String pass, String param, String cont, int alg_exch, int alg_sign, Number hProv) {
        String ret;
        Integer algCodeOrAlgIdExch = 0;
        Integer algCodeOrAlgIdSign = 0;
        if (GammaTechProvider.getAlgUtil().isCspContainsKzOids().booleanValue()) {
            algCodeOrAlgIdExch = alg_exch;
            algCodeOrAlgIdSign = alg_sign;
        } else {
            algCodeOrAlgIdExch = GammaTechProvider.getAlgUtil().getAlgCode(alg_exch);
            algCodeOrAlgIdSign = GammaTechProvider.getAlgUtil().getAlgCode(alg_sign);
        }
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpCreateUrl(name, dev, user, pass, param, cont, (int)algCodeOrAlgIdExch, (int)algCodeOrAlgIdSign, hProv.intValue());
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpCreateUrl(name, dev, user, pass, param, cont, (int)algCodeOrAlgIdExch, (int)algCodeOrAlgIdSign, hProv.longValue());
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error create url ");
        }
        return ret;
    }

    public static String cpUrlToNewUrl(String url, String param, int type, Number hProv) {
        String ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpUrlToNewUrl(url, param, type, hProv.intValue());
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpUrlToNewUrl(url, param, type, hProv.longValue());
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error convert url to new url (" + url + ")");
        }
        return ret;
    }

    public static byte[] cpGetProvParamByte(Number hProv, int dwParam, int dwFlags, int dwField) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0 && dwParam != 55) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetProvParamByte(hProv.intValue(), dwParam, dwFlags, dwField);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L && dwParam != 55) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetProvParamByte(hProv.longValue(), dwParam, dwFlags, dwField);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            CSPException e = new CSPException(new ErrorResolver(hProv), "Error get provider param data (" + dwParam + ") ");
            if (e.errorRes.error != 259 && e.errorRes.error != 0) {
                throw e;
            }
        } else {
            if (dwParam == 55) {
                ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (!(dwParam != 52 && dwParam != 51 || dwField != 0 && dwField != 1 && dwField != 2 && dwField != 3 && dwField != 6 && dwField != 7)) {
                ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (dwParam == 45 && (dwField == 6 || dwField == 7 || dwField == 8)) {
                ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
            if (dwParam == 1 || dwParam == 22 || dwParam == 5 || dwParam == 47) {
                ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
            }
        }
        return ret;
    }

    public static byte[] cpGetTumarCspBuild() {
        if (TumarCspFunctions.getLibraryBit() == 0) {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        byte[] ret = LibraryWrapper.cpGetTumarCspBuild();
        if (ret != null) {
            // empty if block
        }
        return ret;
    }

    public static int cpGetTumarCspBit() {
        if (TumarCspFunctions.getLibraryBit() == 0) {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        int ret = LibraryWrapper.cpGetTumarCspBit();
        if (ret == 0) {
            CSPException e = new CSPException(new ErrorResolver(0), "Error get tumar csp bit ");
            if (e.errorRes.error != 0) {
                throw e;
            }
        }
        return ret;
    }

    public static byte[] cpGetDataFromUrl(Number hProv, String url, int type) {
        byte[] ret;
        if (TumarCspFunctions.getLibraryBit() == 32) {
            if (hProv.intValue() == 0) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetDataFromUrl(hProv.intValue(), url, type);
        } else if (TumarCspFunctions.getLibraryBit() == 64) {
            if (hProv.longValue() == 0L) {
                throw new IllegalArgumentException("Provider not loaded");
            }
            ret = LibraryWrapper.cpGetDataFromUrl(hProv.longValue(), url, type);
        } else {
            throw new RuntimeException("CSP library bit must be set. Please set CSP library bit to 32 or 64");
        }
        if (ret == null) {
            throw new CSPException(new ErrorResolver(hProv), "Error get data from url (" + url + ")");
        }
        if (type == 7 || type == 8 || type == 9) {
            ret = UtilCM.copyByte(ret, 0, ret.length, LibraryWrapper.SUN_CPU_ENDIAN);
        }
        return ret;
    }

    public static void initialize(String name) {
        LibraryWrapper.initialize(name);
    }
}

