/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.tumarcsp.profile;

import java.util.List;
import kz.gamma.core.UtilCM;
import kz.gamma.crypto.RuntimeCryptoException;
import kz.gamma.tumarcsp.CSPUtil;
import kz.gamma.tumarcsp.KeyParams;
import kz.gamma.tumarcsp.LibraryWrapper;
import kz.gamma.tumarcsp.ProfileParams;
import kz.gamma.tumarcsp.TumarCspFunctions;
import kz.gamma.tumarcsp.profile.ProfileList;

public class ProfileInfo {
    private ProfileList profileList = new ProfileList();

    public Boolean isProfileExists(String profile) throws Exception {
        if (profile == null) {
            return null;
        }
        String profileLocal = ProfileParams.getProfileName(profile.trim(), true);
        List<String> list = this.profileList.getProfiles(true);
        Boolean profileExist = false;
        for (String prof : list) {
            if (!prof.trim().equals(profileLocal)) continue;
            profileExist = true;
            break;
        }
        return profileExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataFromUrl(String url, Integer type) {
        Number hProv = 0;
        try {
            hProv = TumarCspFunctions.cpAcquireContext("", -268435456, LibraryWrapper.PV_TABLE);
            byte[] ret = TumarCspFunctions.cpGetDataFromUrl(hProv, url, (int)type);
            if (type == 7 || type == 8 || type == 9) {
                Integer result = UtilCM.byteToInt(ret, 0, 1);
                String string = Integer.toString(result, 10);
                return string;
            }
            if (type == 1) {
                String result = UtilCM.array2hex(ret);
                return result;
            }
            String result = new String(ret, "Cp1251");
            return result;
        }
        finally {
            if (hProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(hProv, 0);
            }
        }
    }

    public int getKeySpec(String url, int acquireContextFlag) {
        Number handleProv = 0;
        try {
            boolean profileChecking = ProfileParams.isProfile(url);
            if (!profileChecking) {
                block9: {
                    handleProv = TumarCspFunctions.cpAcquireContext(url, acquireContextFlag, LibraryWrapper.PV_TABLE);
                    String serialNumber = this.getDataFromUrl(url, 1);
                    try {
                        KeyParams keyParams = new KeyParams(handleProv);
                        if (keyParams.getLength() <= 0) break block9;
                        Object[] algID = keyParams.getKeyAlgIDList();
                        CSPUtil cspUtil = new CSPUtil();
                        int n = cspUtil.getTypeKey((Integer)algID[keyParams.getIndexSN(serialNumber)]);
                        return n;
                    }
                    catch (Exception e) {
                        throw new RuntimeCryptoException("Cannot obtain key usage for key with serial number: " + serialNumber);
                    }
                }
                throw new IllegalArgumentException("Key container have not any keys");
            }
            throw new IllegalArgumentException("Illegal url: " + url);
        }
        finally {
            if (handleProv.longValue() != 0L) {
                TumarCspFunctions.cpReleaseContext(handleProv, 0);
            }
        }
    }
}

