/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.applet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.cms.MSTemplate;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.asn1.x509.X509CertificateStructure;
import kz.gamma.hardware.asn1.x509.X509Extensions;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.cms.CMSProcessable;
import kz.gamma.hardware.cms.CMSProcessableByteArray;
import kz.gamma.hardware.cms.CMSProcessableFile;
import kz.gamma.hardware.cms.CMSSignedData;
import kz.gamma.hardware.cms.CMSSignedDataGenerator;
import kz.gamma.hardware.cms.Pkcs7Data;
import kz.gamma.hardware.cms.SignerInformation;
import kz.gamma.hardware.cms.SignerInformationStore;
import kz.gamma.hardware.core.archive.GzipArchiver;
import kz.gamma.hardware.core.file.FileHelper;
import kz.gamma.hardware.crypto.DeviceList;
import kz.gamma.hardware.crypto.RuntimeCryptoException;
import kz.gamma.hardware.crypto.params.DeviceParameter;
import kz.gamma.hardware.crypto.software.ocsp.OCSPUtilities;
import kz.gamma.hardware.jce.CryptoObject;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCESignature;
import kz.gamma.hardware.jce.Pkcs10RequestCreator;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.util.CertificateFieldsResolver;
import kz.gamma.hardware.util.DateUtils;
import kz.gamma.hardware.util.UtilCM;
import kz.gamma.hardware.util.encoders.Base64;
import kz.gamma.hardware.vista.VistaMessage;

public class CryptoApplet
extends JApplet {
    public static String COLUMN_SEPARATOR = "|col|";
    public static String IN_COLUMN_SEPARATOR = "\\|col\\|";
    public static String ROW_SEPARATOR = "|row|";
    public static String IN_ROW_SEPARATOR = "\\|row\\|";
    protected String lastError = "";
    protected static final String NULL_AS_STRING = "null";
    public static final int FILE_PATH = 0;
    public static final int STRING = 1;
    protected DateFormat sdfShort = new SimpleDateFormat("dd/MM/yyyy");
    protected DateFormat sdfFull = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
    protected FileHelper fileHelper = new FileHelper();

    @Override
    public void init() {
        super.init();
        System.out.println("CryptoApplet loading...");
        try {
            System.out.println("CryptoApplet. Implementation-Title: " + CryptoApplet.class.getPackage().getImplementationTitle());
            System.out.println("CryptoApplet. Implementation-Version: " + CryptoApplet.class.getPackage().getImplementationVersion());
            System.out.println("CryptoApplet. Implementation-Vendor: " + CryptoApplet.class.getPackage().getImplementationVendor());
        }
        catch (Throwable t) {
            System.out.println("CryptoApplet. Implementation-Title: unknown");
            System.out.println("CryptoApplet. Implementation-Version: unknown");
            System.out.println("CryptoApplet. Implementation-Vendor: unknown");
        }
        this.sdfShort.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.sdfFull.setTimeZone(new SimpleTimeZone(0, "Z"));
        System.out.println("CryptoApplet loaded");
    }

    @Override
    public void destroy() {
        System.out.println("CryptoApplet unloading...");
        System.out.println("CryptoApplet unloaded");
        super.destroy();
    }

    public String getLastError() {
        return this.lastError;
    }

    public String getReaders() {
        try {
            this.lastError = "";
            List<DeviceParameter> deviceList = AccessController.doPrivileged(new PrivilegedAction<List<DeviceParameter>>(){

                @Override
                public List<DeviceParameter> run() {
                    try {
                        return DeviceList.listOfDevices("");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            StringBuilder stringBuilder = new StringBuilder();
            for (DeviceParameter deviceParameter : deviceList) {
                stringBuilder.append(deviceParameter.getReaderName()).append(COLUMN_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain readers. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String getDevices() {
        try {
            this.lastError = "";
            List<DeviceParameter> deviceList = AccessController.doPrivileged(new PrivilegedAction<List<DeviceParameter>>(){

                @Override
                public List<DeviceParameter> run() {
                    try {
                        return DeviceList.listOfDevices("");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            StringBuilder stringBuilder = new StringBuilder();
            for (DeviceParameter deviceParameter : deviceList) {
                if (deviceParameter.isGost()) {
                    System.out.println("gost: " + deviceParameter.getReaderName() + " - " + deviceParameter.getGostDeviceName());
                    stringBuilder.append(deviceParameter.getReaderName()).append(COLUMN_SEPARATOR);
                    stringBuilder.append(deviceParameter.getGostDeviceName()).append(COLUMN_SEPARATOR);
                    stringBuilder.append("gost").append(ROW_SEPARATOR);
                }
                if (!deviceParameter.isRsa()) continue;
                System.out.println("rsa: " + deviceParameter.getReaderName() + " - " + deviceParameter.getRsaDeviceName());
                stringBuilder.append(deviceParameter.getReaderName()).append(COLUMN_SEPARATOR);
                stringBuilder.append(deviceParameter.getRsaDeviceName()).append(COLUMN_SEPARATOR);
                stringBuilder.append("rsa").append(ROW_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain devices. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String generateObjectName() {
        try {
            this.lastError = "";
            return String.valueOf(System.currentTimeMillis());
        }
        catch (Throwable e) {
            this.lastError = "Cannot generate object name. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String generateObjectName(String dateFormat) {
        try {
            this.lastError = "";
            dateFormat = dateFormat != null && dateFormat.equals(NULL_AS_STRING) ? null : dateFormat;
            SimpleDateFormat sdfLocal = new SimpleDateFormat(dateFormat);
            sdfLocal.setTimeZone(new SimpleTimeZone(0, "Z"));
            return sdfLocal.format(new Date());
        }
        catch (Throwable e) {
            this.lastError = "Cannot generate object name. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String getObjects(String reader, String pass) {
        return this.getObjects(reader, pass, "gost");
    }

    public String getObjects(String reader, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            List<JCEKeyPair> keyPairs = AccessController.doPrivileged(new PrivilegedAction<List<JCEKeyPair>>(){

                @Override
                public List<JCEKeyPair> run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        ArrayList<JCEKeyPair> resultList = new ArrayList<JCEKeyPair>();
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                resultList.add(keyPair);
                            }
                        }
                        return resultList;
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            StringBuilder stringBuilder = new StringBuilder();
            for (JCEKeyPair keyPair : keyPairs) {
                stringBuilder.append(keyPair.getPrivateKey().getName()).append(COLUMN_SEPARATOR);
                stringBuilder.append(keyPair.getPrivateKey().getAlgId()).append(COLUMN_SEPARATOR);
                stringBuilder.append(keyPair.getPrivateKey().getAlgorithm()).append(COLUMN_SEPARATOR);
                String certificateBody = "";
                if (keyPair.getCertBlob() != null) {
                    byte[] certBodyBytes = keyPair.getCertBlob();
                    if (UtilCM.getCertificateBlob(certBodyBytes) == null) {
                        GzipArchiver gzipArchiver = new GzipArchiver();
                        certBodyBytes = gzipArchiver.ungzip(certBodyBytes);
                    }
                    certificateBody = new String(Base64.encode(certBodyBytes));
                }
                stringBuilder.append(certificateBody).append(COLUMN_SEPARATOR);
                byte[] pKey = UtilCM.reverseParts(keyPair.getPublicKey().getpKey(), 0);
                String publicKey = new String(Base64.encode(pKey));
                stringBuilder.append(publicKey).append(ROW_SEPARATOR);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - ROW_SEPARATOR.length(), stringBuilder.length());
            }
            return stringBuilder.toString();
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain objects. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCertificateInfo(String certificate) {
        FilterInputStream extensionStream = null;
        try {
            boolean[] keyUsageArray;
            this.lastError = "";
            certificate = certificate != null && certificate.equals(NULL_AS_STRING) ? null : certificate;
            byte[] cert = UtilCM.getCertificateBlob(Base64.decode(certificate));
            if (cert == null) {
                throw new RuntimeCryptoException("Certificate bad data: " + certificate);
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            StringBuilder stringBuilder = new StringBuilder();
            extensionStream = new ASN1InputStream(cert);
            DERObject derObject = ((ASN1InputStream)extensionStream).readObject();
            X509CertificateStructure x509CertificateStructure = X509CertificateStructure.getInstance(derObject);
            stringBuilder.append(x509CertificateStructure.getSubject().toString(true, X509Name.DefaultSymbols)).append(COLUMN_SEPARATOR);
            extensionStream.close();
            for (boolean keyUsageValue : keyUsageArray = x509certificate.getKeyUsage()) {
                if (keyUsageValue) {
                    stringBuilder.append("1");
                    continue;
                }
                stringBuilder.append("0");
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            List<String> extendedKeyUsageList = x509certificate.getExtendedKeyUsage();
            if (extendedKeyUsageList != null) {
                for (int j = 0; j < extendedKeyUsageList.size(); ++j) {
                    String extendedKeyUsageValue = extendedKeyUsageList.get(j);
                    stringBuilder.append(extendedKeyUsageValue);
                    if (j >= extendedKeyUsageList.size() - 1) continue;
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            String notBefore = DateUtils.getInstance().dateToString(x509certificate.getNotBefore(), "dd/MM/yyyy");
            String notAfter = DateUtils.getInstance().dateToString(x509certificate.getNotAfter(), "dd/MM/yyyy");
            stringBuilder.append(notBefore).append(COLUMN_SEPARATOR);
            stringBuilder.append(notAfter).append(COLUMN_SEPARATOR);
            CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();
            String serialNumber = (String)certificateFieldsResolver.getSerialNumber(x509certificate.getSerialNumber(), (Integer)0);
            stringBuilder.append(serialNumber).append(COLUMN_SEPARATOR);
            stringBuilder.append(x509certificate.getSigAlgOID()).append(COLUMN_SEPARATOR);
            if (x509certificate.getBasicConstraints() != -1) {
                stringBuilder.append("1");
            } else {
                stringBuilder.append("0");
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(x509certificate.getPublicKey().getEncoded()).readObject());
            if (publicKeyInfo.getAlgorithmId().getObjectId().getId().equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                DERSequence publicKeySequence = (DERSequence)new ASN1InputStream(publicKeyInfo.getPublicKeyData().getBytes()).readObject();
                DERInteger publicKeyInteger = (DERInteger)publicKeySequence.getObjectAt(0);
                stringBuilder.append(new String(Base64.encode(publicKeyInteger.getValue().toByteArray())));
            } else if (publicKeyInfo.getAlgorithmId().getObjectId().getId().equals(GammaObjectIndentifiers.gost34310_GammaTech_A.getId()) || publicKeyInfo.getAlgorithmId().getObjectId().getId().equals(GammaObjectIndentifiers.gost34310_GammaTech_A_EX.getId()) || publicKeyInfo.getAlgorithmId().getObjectId().getId().equals(KZObjectIndentifiers.GOST_34_310_KEY.getId())) {
                byte[] publicKeyData = publicKeyInfo.getPublicKeyData().getBytes();
                int publicKeyLength = 64;
                int publicKeyOffset = publicKeyData.length - publicKeyLength;
                byte[] pKey = UtilCM.copyByte(publicKeyData, publicKeyOffset, publicKeyLength);
                stringBuilder.append(new String(Base64.encode(pKey)));
            } else {
                throw new RuntimeException("Unknown algorithm id in subject public key info: " + publicKeyInfo.getAlgorithmId().getObjectId().getId());
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            byte[] extensionBytes = x509certificate.getExtensionValue(X509Extensions.CertificatePolicies.getId());
            if (extensionBytes != null) {
                extensionStream = new ASN1InputStream(extensionBytes);
                DEROctetString octetString = (DEROctetString)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                extensionStream = new ASN1InputStream(octetString.getOctets());
                DERSequence sequence = (DERSequence)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                Enumeration policies = sequence.getObjects();
                String comma = ",";
                while (policies.hasMoreElements()) {
                    DERSequence nextElement = (DERSequence)policies.nextElement();
                    DERObjectIdentifier identifier = (DERObjectIdentifier)nextElement.getObjectAt(0);
                    stringBuilder.append(identifier.getId());
                    stringBuilder.append(comma);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.delete(stringBuilder.length() - comma.length(), stringBuilder.length());
                }
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            stringBuilder.append(x509certificate.getIssuerX500Principal().toString()).append(COLUMN_SEPARATOR);
            stringBuilder.append(new String(Base64.encode(x509certificate.getSignature()))).append(COLUMN_SEPARATOR);
            stringBuilder.append(x509certificate.getPublicKey().getAlgorithm()).append(COLUMN_SEPARATOR);
            byte[] subjectKeyIdentifierBytes = x509certificate.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
            if (subjectKeyIdentifierBytes != null) {
                extensionStream = new ASN1InputStream(subjectKeyIdentifierBytes);
                DEROctetString octetString = (DEROctetString)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                extensionStream = new ASN1InputStream(octetString.getOctets());
                DEROctetString subjectKeyIdentifier = (DEROctetString)((ASN1InputStream)extensionStream).readObject();
                String subjectKeyIdentifierInHex = UtilCM.array2hex(subjectKeyIdentifier.getOctets());
                stringBuilder.append(subjectKeyIdentifierInHex);
                extensionStream.close();
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            byte[] authorityKeyIdentifierBytes = x509certificate.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            if (authorityKeyIdentifierBytes != null) {
                extensionStream = new ASN1InputStream(authorityKeyIdentifierBytes);
                DEROctetString octetString = (DEROctetString)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                extensionStream = new ASN1InputStream(octetString.getOctets());
                DERSequence sequence = (DERSequence)((ASN1InputStream)extensionStream).readObject();
                extensionStream.close();
                Enumeration objects = sequence.getObjects();
                while (objects.hasMoreElements()) {
                    DERTaggedObject authorityKeyIdentifierTaggedObject;
                    DERObject nextElement = (DERObject)objects.nextElement();
                    if (!(nextElement instanceof DERTaggedObject) || (authorityKeyIdentifierTaggedObject = (DERTaggedObject)nextElement).getTagNo() != 0) continue;
                    DEROctetString authorityKeyIdentifierOctetString = (DEROctetString)authorityKeyIdentifierTaggedObject.getObject();
                    String authorityKeyIdentifierInHex = UtilCM.array2hex(authorityKeyIdentifierOctetString.getOctets());
                    stringBuilder.append(authorityKeyIdentifierInHex);
                    break;
                }
                extensionStream.close();
            }
            stringBuilder.append(COLUMN_SEPARATOR);
            if (stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - COLUMN_SEPARATOR.length(), stringBuilder.length());
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain certificate information. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (extensionStream != null) {
                try {
                    extensionStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String createPkcs7(String reader, String filePath, boolean attached, String objectName, String pass) {
        String algorithm;
        block6: {
            algorithm = "gost";
            String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            try {
                List<DeviceParameter> deviceList;
                this.lastError = "";
                if (readerLocal == null || (deviceList = AccessController.doPrivileged(new PrivilegedAction<List<DeviceParameter>>(){

                    @Override
                    public List<DeviceParameter> run() {
                        try {
                            return DeviceList.listOfDevices("");
                        }
                        catch (Exception e) {
                            throw new JCEHardwareException(e);
                        }
                    }
                })) == null) break block6;
                for (DeviceParameter devParam : deviceList) {
                    if (!devParam.getReaderName().equals(reader)) continue;
                    if (devParam.isGost()) {
                        algorithm = "gost";
                    } else if (devParam.isRsa()) {
                        algorithm = "rsa";
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.lastError = "Cannot create PKCS#7. Exception message: " + e.getMessage() + ".";
                e.printStackTrace();
                return null;
            }
        }
        return this.createPkcs7(reader, filePath, 0, attached, objectName, pass, algorithm);
    }

    public String createPkcs7(String reader, String filePath, boolean attached, String objectName, String pass, String algorithm) {
        return this.createPkcs7(reader, filePath, 0, attached, objectName, pass, algorithm);
    }

    public String createPkcs7(String reader, String data, int dataType, boolean attached, String objectName, String pass, String algorithm) {
        return this.createPkcs7(reader, data, dataType, attached, objectName, pass, algorithm, null);
    }

    public String createPkcs7(String reader, String data, int dataType, boolean attached, String objectName, String pass, String algorithm, String digestOid) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String dataLocal = data != null && data.equals(NULL_AS_STRING) ? null : data;
            final int dataTypeLocal = dataType;
            final boolean attachedLocal = attached;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            final String digestOidLocal = digestOid != null && digestOid.equals(NULL_AS_STRING) ? null : digestOid;
            byte[] pkcs7 = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CMSProcessable content = null;
                        switch (dataTypeLocal) {
                            case 0: {
                                if (!CryptoApplet.this.fileHelper.isFileExists(dataLocal).booleanValue()) {
                                    throw new RuntimeCryptoException("File '" + dataLocal + "' does not exists");
                                }
                                if (attachedLocal) {
                                    throw new RuntimeException("File can be used only for detached signature");
                                }
                                File file = new File(dataLocal);
                                content = new CMSProcessableFile(file);
                                break;
                            }
                            case 1: {
                                content = new CMSProcessableByteArray(dataLocal.getBytes("UTF-8"));
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown data type: " + dataTypeLocal);
                            }
                        }
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal)) continue;
                                if (keyPair.getCertBlob() == null) {
                                    throw new RuntimeCryptoException("Object '" + objectNameLocal + "' have not a certificate");
                                }
                                JCESignature signature = new JCESignature(cryptoObject, keyPair.getPrivateKey());
                                CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
                                byte[] certBodyBytes = keyPair.getCertBlob();
                                if (UtilCM.getCertificateBlob(certBodyBytes) == null) {
                                    GzipArchiver gzipArchiver = new GzipArchiver();
                                    certBodyBytes = gzipArchiver.ungzip(certBodyBytes);
                                }
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                X509Certificate x509certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBodyBytes));
                                LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
                                certList.add(x509certificate);
                                CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
                                gen.addCertificatesAndCRLs(certStore);
                                String generatorDigest = null;
                                generatorDigest = digestOidLocal == null || digestOidLocal.trim().length() == 0 ? (algorithmLocal.equals("gost") ? CMSSignedDataGenerator.DIGEST_GOST3411G : CMSSignedDataGenerator.DIGEST_SHA1) : digestOidLocal;
                                gen.addSigner(keyPair.getPrivateKey(), x509certificate, generatorDigest);
                                CMSSignedData signedData = gen.generate(content, attachedLocal, signature);
                                return signedData.getEncoded();
                            }
                        } else {
                            throw new RuntimeCryptoException("Device have not any keys");
                        }
                        throw new RuntimeCryptoException("Object '" + objectNameLocal + "' was not found");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return new String(Base64.encode(pkcs7));
        }
        catch (Throwable e) {
            this.lastError = "Cannot create PKCS#7. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public boolean verifyPkcs7(String pkcs7, String filePath) {
        return this.verifyPkcs7(pkcs7, filePath, 0);
    }

    public boolean verifyPkcs7(String pkcs7, String data, int dataType) {
        try {
            this.lastError = "";
            final String pkcs7Local = pkcs7 != null && pkcs7.equals(NULL_AS_STRING) ? null : pkcs7;
            final String dataLocal = data != null && data.equals(NULL_AS_STRING) ? null : data;
            final int dataTypeLocal = dataType;
            boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        Pkcs7Data pkcs7Data = null;
                        byte[] signedData = Base64.decode(pkcs7Local);
                        if (dataLocal == null) {
                            pkcs7Data = new Pkcs7Data(signedData);
                        } else {
                            switch (dataTypeLocal) {
                                case 0: {
                                    if (!CryptoApplet.this.fileHelper.isFileExists(dataLocal).booleanValue()) {
                                        throw new RuntimeCryptoException("File '" + dataLocal + "' does not exists");
                                    }
                                    File file = new File(dataLocal);
                                    pkcs7Data = new Pkcs7Data(signedData, file);
                                    break;
                                }
                                case 1: {
                                    pkcs7Data = new Pkcs7Data(signedData, dataLocal.getBytes("UTF-8"));
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown data type: " + dataTypeLocal);
                                }
                            }
                        }
                        return pkcs7Data.verify();
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.lastError = "Cannot verify PKCS#7. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public String getInfoFromPkcs7(String pkcs7) {
        try {
            this.lastError = "";
            final String pkcs7Local = pkcs7 != null && pkcs7.equals(NULL_AS_STRING) ? null : pkcs7;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        byte[] signedData = Base64.decode(pkcs7Local);
                        Pkcs7Data pkcs7Data = new Pkcs7Data(signedData);
                        return new String(pkcs7Data.getData(), "UTF-8");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain information from PKCS#7. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String getCertFromPkcs7(String pkcs7) {
        try {
            this.lastError = "";
            final String pkcs7Local = pkcs7 != null && pkcs7.equals(NULL_AS_STRING) ? null : pkcs7;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        String certs = "";
                        CMSSignedData signedData = new CMSSignedData(Base64.decode(pkcs7Local));
                        CertStore store = signedData.getCertificatesAndCRLs("Collection", null);
                        SignerInformationStore sis = signedData.getSignerInfos();
                        Collection signers = sis.getSigners();
                        X509Certificate certificate = null;
                        for (SignerInformation signer : signers) {
                            Collection<? extends Certificate> certificates = store.getCertificates(signer.getSID());
                            Iterator<? extends Certificate> itr = certificates.iterator();
                            if (!itr.hasNext()) continue;
                            certificate = (X509Certificate)itr.next();
                            if (certs.isEmpty()) {
                                certs = new String(Base64.encode(certificate.getEncoded()));
                                continue;
                            }
                            certs = certs + COLUMN_SEPARATOR + new String(Base64.encode(certificate.getEncoded()));
                        }
                        return certs;
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot obtain certificate from PKCS#7. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String generateKeyPair(String reader, int algType, String objectName, String pass) {
        return this.generateKeyPair(reader, algType, objectName, pass, "gost");
    }

    public String generateKeyPair(String reader, int algType, String objectName, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final int algTypeLocal = algType;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            switch (algType) {
                case 1: 
                case 2: {
                    if (algorithmLocal.equals("gost")) break;
                    throw new JCEHardwareException("Unknown algorithm type '" + algType + "' for algorithm: " + algorithm);
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (algorithmLocal.equals("rsa")) break;
                    throw new JCEHardwareException("Unknown algorithm type '" + algType + "' for algorithm: " + algorithm);
                }
                default: {
                    throw new JCEHardwareException("Unknown algorithm type: " + algType);
                }
            }
            byte[] publicKey = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        JCEKeyPair keyPair;
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal)) continue;
                                throw new RuntimeException("Object with name '" + objectNameLocal + "' already exists. Please, try another.");
                            }
                        }
                        keyPair = cryptoObject.createKey(algTypeLocal, objectNameLocal, passLocal);
                        byte[] pKey = UtilCM.reverseParts(keyPair.getPublicKey().getpKey(), 0);
                        return pKey;
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return new String(Base64.encode(publicKey));
        }
        catch (Throwable e) {
            this.lastError = "Cannot generate key pair. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public boolean deleteKeyPair(String reader, String objectName, String pass) {
        return this.deleteKeyPair(reader, objectName, pass, "gost");
    }

    public boolean deleteKeyPair(String reader, String objectName, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal)) continue;
                                cryptoObject.deleteKey(objectNameLocal, passLocal);
                                return true;
                            }
                        }
                        return false;
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.lastError = "Cannot delete key pair. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public String createPkcs10(String reader, String subject, String templateCn, String objectName, String pass) {
        return this.createPkcs10(reader, subject, templateCn, objectName, pass, "gost");
    }

    public String createPkcs10(String reader, String subject, String templateCn, String objectName, String pass, String algorithm) {
        return this.createPkcs10(reader, subject, templateCn, objectName, pass, algorithm, null, null);
    }

    public String createPkcs10(String reader, String subject, String templateCn, String objectName, String pass, String algorithm, String publicKeyOid, String signatureOid) {
        try {
            String algorithmLocal;
            String subjectLocal;
            String readerLocal;
            this.lastError = "";
            String string = readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            if (subject != null) {
                System.out.printf("Subject for PKCS#10: %s\n", subject);
            }
            String string2 = subjectLocal = subject != null && subject.equals(NULL_AS_STRING) ? null : subject;
            if (subjectLocal == null || subjectLocal.trim().length() == 0) {
                throw new RuntimeCryptoException("Illegal subject: " + subject);
            }
            final String templateCnLocal = templateCn != null && templateCn.equals(NULL_AS_STRING) ? null : templateCn;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string3 = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            final String publicKeyOidLocal = publicKeyOid != null && publicKeyOid.equals(NULL_AS_STRING) ? null : publicKeyOid;
            final String signatureOidLocal = signatureOid != null && signatureOid.equals(NULL_AS_STRING) ? null : signatureOid;
            byte[] pkcs10 = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        X509Name x509name = new X509Name(subjectLocal);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal)) continue;
                                ASN1Set templateAsn = null;
                                if (templateCnLocal != null && templateCnLocal.trim().length() > 0) {
                                    String templateDn = "CN=" + templateCnLocal + ",O=Template,C=KZ";
                                    templateAsn = MSTemplate.getASN1Template(templateDn);
                                }
                                if (publicKeyOidLocal == null || publicKeyOidLocal.trim().length() == 0 || signatureOidLocal == null || signatureOidLocal.trim().length() == 0) {
                                    return cryptoObject.generatePKCS10(x509name, keyPair.getPrivateKey(), keyPair.getPublicKey(), templateAsn);
                                }
                                Pkcs10RequestCreator pkcs10RequestCreator = new Pkcs10RequestCreator(x509name, keyPair.getPrivateKey(), keyPair.getPublicKey(), templateAsn, cryptoObject, publicKeyOidLocal, signatureOidLocal);
                                return pkcs10RequestCreator.createPkcs10();
                            }
                        } else {
                            throw new RuntimeCryptoException("Device have not any keys");
                        }
                        throw new RuntimeCryptoException("Object '" + objectNameLocal + "' was not found");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return new String(Base64.encode(pkcs10));
        }
        catch (Throwable e) {
            this.lastError = "Cannot create PKCS#10. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public boolean setCertificate(String reader, String certificate, String objectName, String pass) {
        return this.setCertificate(reader, certificate, objectName, pass, "gost");
    }

    public boolean setCertificate(String reader, String certificate, String objectName, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String certificateLocal = certificate != null && certificate.equals(NULL_AS_STRING) ? null : certificate;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal)) continue;
                                byte[] cert = UtilCM.getCertificateBlob(Base64.decode(certificateLocal));
                                if (cert == null) {
                                    throw new RuntimeCryptoException("Certificate bad data: " + certificateLocal);
                                }
                                int certificateType = UtilCM.getCertificateType(cert);
                                if (certificateType == 2 || certificateType == 3) {
                                    keyPair.getPrivateKey().setName("");
                                }
                                cryptoObject.setCertificate(cert, keyPair.getPrivateKey());
                                return true;
                            }
                        } else {
                            throw new RuntimeCryptoException("Device have not any keys");
                        }
                        throw new RuntimeCryptoException("Object '" + objectNameLocal + "' was not found");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.lastError = "Cannot install certificate. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveData(String data, String path) {
        try {
            this.lastError = "";
            data = data != null && data.equals(NULL_AS_STRING) ? null : data;
            path = path != null && path.equals(NULL_AS_STRING) ? null : path;
            this.fileHelper.saveData(Base64.decode(data), path);
            return true;
        }
        catch (Throwable e) {
            this.lastError = "Cannot save data to file \"" + path + "\". Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public String loadData(String path) {
        try {
            this.lastError = "";
            path = path != null && path.equals(NULL_AS_STRING) ? null : path;
            byte[] fileContent = this.fileHelper.loadData(path);
            byte[] result = Base64.encode(fileContent);
            return new String(result);
        }
        catch (Throwable e) {
            this.lastError = "Cannot load data from file \"" + path + "\". Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String createDialog(String extensions, String description, int type) {
        try {
            this.lastError = "";
            List<String> list = null;
            extensions = extensions != null && extensions.equals(NULL_AS_STRING) ? null : extensions;
            String string = description = description == null || description.equals(NULL_AS_STRING) ? "" : description;
            if (extensions != null && extensions.trim().length() > 0) {
                String[] exstArray = extensions.split(IN_COLUMN_SEPARATOR);
                list = Arrays.asList(exstArray);
            }
            return this.fileHelper.createDialog(list, description, type);
        }
        catch (Throwable e) {
            this.lastError = "Cannot select file. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String createDialog() {
        try {
            this.lastError = "";
            return this.fileHelper.createDialog(null, null, 0, 1);
        }
        catch (Throwable e) {
            this.lastError = "Cannot select directory. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public Integer getFileSize(String path) {
        try {
            this.lastError = "";
            path = path != null && path.equals(NULL_AS_STRING) ? null : path;
            return this.fileHelper.getFileSize(path);
        }
        catch (Throwable e) {
            this.lastError = "Cannot get size of \"" + path + "\". Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public boolean checkPassword(String reader, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        return cryptoObject.checkPassword(passLocal);
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.lastError = "Cannot check password. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public boolean changePassword(String reader, String oldPass, String newPass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String oldPassLocal = oldPass != null && oldPass.equals(NULL_AS_STRING) ? null : oldPass;
            final String newPassLocal = newPass != null && newPass.equals(NULL_AS_STRING) ? null : newPass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        cryptoObject.changePassword(oldPassLocal, newPassLocal);
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                    return null;
                }
            });
            return true;
        }
        catch (Throwable e) {
            this.lastError = "Cannot change password. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public boolean checkLicense(String reader, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        return cryptoObject.checkLicense();
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return result;
        }
        catch (Throwable e) {
            this.lastError = "Cannot change password. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return false;
        }
    }

    public String createOcspRequest(String reader, String objectName, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String objectNameLocal = objectName != null && objectName.equals(NULL_AS_STRING) ? null : objectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            byte[] ocsp = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        Enumeration<JCEKeyPair> keyPairs = cryptoObject.getKeyList(passLocal);
                        if (keyPairs != null) {
                            while (keyPairs.hasMoreElements()) {
                                JCEKeyPair keyPair = keyPairs.nextElement();
                                if (!keyPair.getPrivateKey().getName().equals(objectNameLocal) || keyPair.getCertBlob() == null) continue;
                                OCSPUtilities ocspUtilities = new OCSPUtilities();
                                return ocspUtilities.generateOcspRequest(keyPair.getCertBlob(), objectNameLocal, GammaObjectIndentifiers.gost34311.getId(), null, "gammaca");
                            }
                        } else {
                            throw new RuntimeCryptoException("Device have not any " + algorithmLocal + " certificates");
                        }
                        throw new RuntimeCryptoException("Object '" + objectNameLocal + "' was not found");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return new String(Base64.encode(ocsp));
        }
        catch (Throwable e) {
            this.lastError = "Cannot create OCSP request. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String verifyOcspResponse(String ocspResponse) {
        try {
            this.lastError = "";
            final String ocspResponseLocal = ocspResponse != null && ocspResponse.equals(NULL_AS_STRING) ? null : ocspResponse;
            Integer certificateStatus = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        OCSPUtilities ocspUtilities = new OCSPUtilities();
                        Map resultMap = ocspUtilities.verifyOcspResponse(Base64.decode(ocspResponseLocal));
                        return (Integer)resultMap.get("status");
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return String.valueOf(certificateStatus);
        }
        catch (Throwable e) {
            this.lastError = "Cannot verify OCSP response. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String createTimestampRequest(String reader, String data, int dataType, String reqPolicy, String objectName, String pass, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final String dataLocal = data != null && data.equals(NULL_AS_STRING) ? null : data;
            final int dataTypeLocal = dataType;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            final String reqPolicyLocal = reqPolicy != null && reqPolicy.equals(NULL_AS_STRING) ? null : reqPolicy;
            byte[] tsp = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        CMSProcessable content = null;
                        switch (dataTypeLocal) {
                            case 0: {
                                if (!CryptoApplet.this.fileHelper.isFileExists(dataLocal).booleanValue()) {
                                    throw new RuntimeCryptoException("File '" + dataLocal + "' does not exists");
                                }
                                File file = new File(dataLocal);
                                content = new CMSProcessableFile(file);
                                break;
                            }
                            case 1: {
                                content = new CMSProcessableByteArray(dataLocal.getBytes("UTF-8"));
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown data type: " + dataTypeLocal);
                            }
                        }
                        return cryptoObject.generateTimestampRequest(content, reqPolicyLocal);
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
            return new String(Base64.encode(tsp));
        }
        catch (Throwable e) {
            this.lastError = "Cannot create Timestamp request. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String parseVerifierResponse(String verifierResponse) {
        try {
            this.lastError = "";
            final String verifierResponseLocal = verifierResponse != null && verifierResponse.equals(NULL_AS_STRING) ? null : verifierResponse;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    ASN1InputStream in = null;
                    try {
                        in = new ASN1InputStream(Base64.decode(verifierResponseLocal));
                        DERSequence asnBody = (DERSequence)in.readObject();
                        Enumeration objects = asnBody.getObjects();
                        while (objects.hasMoreElements()) {
                            DEREncodable object = (DEREncodable)objects.nextElement();
                            if (!(object instanceof DERTaggedObject)) continue;
                            DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                            DEROctetString derOctetString = (DEROctetString)DEROctetString.getInstance(derTaggedObject);
                            String string = new String(derOctetString.getOctets(), "UTF-8");
                            return string;
                        }
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    throw new RuntimeException("Status was not found");
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot parse Verifier response. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public Integer getFreeMemorySize(String reader, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        return cryptoObject.getFreeMemorySize();
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot get free memory size. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String getSerialNumber(String reader, String algorithm) {
        try {
            String algorithmLocal;
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            String string = algorithmLocal = algorithm != null && algorithm.equals(NULL_AS_STRING) ? null : algorithm;
            if (!algorithmLocal.equals("gost") && !algorithmLocal.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", algorithmLocal);
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        return cryptoObject.getSerialNumber();
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot get serial number. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String createPasswordDialog(String message, String title, int numberOfColumns) {
        try {
            this.lastError = "";
            final String messageLocal = message != null && message.equals(NULL_AS_STRING) ? null : message;
            final String titleLocal = title != null && title.equals(NULL_AS_STRING) ? null : title;
            final int numberOfColumnsLocal = numberOfColumns;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        JPanel panel = new JPanel();
                        JLabel label = new JLabel(messageLocal);
                        JPasswordField pass = new JPasswordField(numberOfColumnsLocal);
                        panel.add(label);
                        panel.add(pass);
                        Object[] options = new String[]{"OK", "\u041e\u0442\u043c\u0435\u043d\u0430"};
                        int option = JOptionPane.showOptionDialog(null, panel, titleLocal, 2, -1, null, options, options[1]);
                        if (option == 0) {
                            return new String(pass.getPassword());
                        }
                        return "";
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot create password dialog. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String createVistaMessage(String reader, String filePaths, String directoryToSave, String senderSignObjectName, String senderExchObjectName, String pass, String recipientsExchCertificates, byte priority, String title) {
        try {
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            filePaths = filePaths != null && filePaths.equals(NULL_AS_STRING) ? null : filePaths;
            List<String> filePathsList = null;
            if (filePaths != null && filePaths.trim().length() > 0) {
                String[] filePathsArray = filePaths.split(IN_COLUMN_SEPARATOR);
                filePathsList = Arrays.asList(filePathsArray);
            }
            final List<String> filePathsListLocal = filePathsList;
            final String directoryToSaveLocal = directoryToSave != null && directoryToSave.equals(NULL_AS_STRING) ? null : directoryToSave;
            final String senderSignObjectNameLocal = senderSignObjectName != null && senderSignObjectName.equals(NULL_AS_STRING) ? null : senderSignObjectName;
            final String senderExchObjectNameLocal = senderExchObjectName != null && senderExchObjectName.equals(NULL_AS_STRING) ? null : senderExchObjectName;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            List<String> recipientsExchCertsList = null;
            if (recipientsExchCertificates != null && recipientsExchCertificates.trim().length() > 0) {
                String[] recipientsExchCertificatesArray = recipientsExchCertificates.split(IN_COLUMN_SEPARATOR);
                recipientsExchCertsList = Arrays.asList(recipientsExchCertificatesArray);
            }
            final List<String> recipientsExchCertsListLocal = recipientsExchCertsList;
            final byte priorityLocal = priority;
            final String titleLocal = title != null && title.equals(NULL_AS_STRING) ? null : title;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("reader", readerLocal);
                        params.put("algorithm", "gost");
                        CryptoObject cryptoObject = CryptoObject.getInstance(params);
                        ArrayList<X509Certificate> x509recipientExchCertList = new ArrayList<X509Certificate>();
                        for (String recipientExchCert : recipientsExchCertsListLocal) {
                            byte[] certBytes = UtilCM.getCertificateBlob(Base64.decode(recipientExchCert));
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            X509Certificate x509recipientExchCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
                            x509recipientExchCertList.add(x509recipientExchCert);
                        }
                        VistaMessage vistaMessage = new VistaMessage(titleLocal, priorityLocal, x509recipientExchCertList, cryptoObject, senderExchObjectNameLocal, passLocal);
                        FileHelper fileHelper = new FileHelper();
                        for (String filePath : filePathsListLocal) {
                            File file = new File(filePath);
                            byte[] fileData = fileHelper.loadData(filePath);
                            vistaMessage.addVistaFile(file.getName(), fileData);
                        }
                        byte[] message = vistaMessage.generateVistaMessage(cryptoObject, senderSignObjectNameLocal, senderExchObjectNameLocal, passLocal);
                        String vistaMessageFilePath = String.format("%s%s%s.cms", directoryToSaveLocal, File.separator, vistaMessage.getReference());
                        fileHelper.saveData(message, vistaMessageFilePath);
                        return vistaMessageFilePath;
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot create Vista message. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String parseVistaMessage(String reader, int informationType, String filePath, String directoryToSave, String pass, String senderSignCertificate, String senderExchCertificate) {
        try {
            this.lastError = "";
            final String readerLocal = reader != null && reader.equals(NULL_AS_STRING) ? null : reader;
            final int informationTypeLocal = informationType;
            final String filePathLocal = filePath != null && filePath.equals(NULL_AS_STRING) ? null : filePath;
            final String directoryToSaveLocal = directoryToSave != null && directoryToSave.equals(NULL_AS_STRING) ? null : directoryToSave;
            final String passLocal = pass != null && pass.equals(NULL_AS_STRING) ? null : pass;
            final String senderSignCertificateLocal = senderSignCertificate != null && senderSignCertificate.equals(NULL_AS_STRING) ? null : senderSignCertificate;
            final String senderExchCertificateLocal = senderExchCertificate != null && senderExchCertificate.equals(NULL_AS_STRING) ? null : senderExchCertificate;
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        byte[] fileData = CryptoApplet.this.fileHelper.loadData(filePathLocal);
                        VistaMessage vistaMessage = new VistaMessage(fileData);
                        StringBuilder stringBuilder = new StringBuilder();
                        switch (informationTypeLocal) {
                            case 0: {
                                stringBuilder.append(vistaMessage.getTitleMessage()).append(COLUMN_SEPARATOR);
                                String binaryString = Integer.toBinaryString(vistaMessage.getArchType());
                                int requiredLength = 6;
                                char[] zeroArray = new char[requiredLength - binaryString.length()];
                                Arrays.fill(zeroArray, '0');
                                stringBuilder.append(new String(zeroArray));
                                stringBuilder.append(binaryString).append(COLUMN_SEPARATOR);
                                stringBuilder.append(vistaMessage.getSignSenderName()).append(COLUMN_SEPARATOR);
                                SignerInformation signerInformation = vistaMessage.getSignerInfo();
                                stringBuilder.append(UtilCM.array2hex(signerInformation.getSID().getSerialNumber().toByteArray())).append(COLUMN_SEPARATOR);
                                stringBuilder.append(vistaMessage.getEnvelopedData().getExchSenderName()).append(COLUMN_SEPARATOR);
                                stringBuilder.append(UtilCM.array2hex(vistaMessage.getEnvelopedData().getExchSenderSn())).append(COLUMN_SEPARATOR);
                                List<X509Name> names = vistaMessage.getEnvelopedData().getRecipientsNames();
                                for (int i = 0; i < names.size(); ++i) {
                                    stringBuilder.append(names.get(i));
                                    if (i + 1 >= names.size()) continue;
                                    stringBuilder.append(ROW_SEPARATOR);
                                }
                                stringBuilder.append(COLUMN_SEPARATOR);
                                List serialNumbers = vistaMessage.getEnvelopedData().getRecipientsSerialNumbers();
                                for (int i = 0; i < serialNumbers.size(); ++i) {
                                    stringBuilder.append(UtilCM.array2hex(((BigInteger)serialNumbers.get(i)).toByteArray()));
                                    if (i + 1 >= serialNumbers.size()) continue;
                                    stringBuilder.append(ROW_SEPARATOR);
                                }
                                stringBuilder.append(COLUMN_SEPARATOR);
                                int fCount = vistaMessage.getVistaFileCount();
                                stringBuilder.append(fCount).append(COLUMN_SEPARATOR);
                                for (int i = 0; i < fCount; ++i) {
                                    stringBuilder.append(vistaMessage.getVistaFileName(i));
                                    if (i + 1 >= fCount) continue;
                                    stringBuilder.append(ROW_SEPARATOR);
                                }
                                break;
                            }
                            case 2: {
                                TreeMap<String, String> params = new TreeMap<String, String>();
                                params.put("reader", readerLocal);
                                params.put("algorithm", "gost");
                                CryptoObject cryptoObject = CryptoObject.getInstance(params);
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                if (vistaMessage.isMessageType((byte)2)) {
                                    if (senderSignCertificateLocal == null) {
                                        throw new RuntimeCryptoException("Certificate for signature must be passed");
                                    }
                                    byte[] senderSignCertBytes = UtilCM.getCertificateBlob(Base64.decode(senderSignCertificateLocal));
                                    X509Certificate x509signCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(senderSignCertBytes));
                                    boolean result = vistaMessage.verifySign(x509signCert);
                                    stringBuilder.append(result).append(COLUMN_SEPARATOR);
                                } else {
                                    stringBuilder.append("none").append(COLUMN_SEPARATOR);
                                }
                                stringBuilder.append(vistaMessage.getVistaFileCount()).append(COLUMN_SEPARATOR);
                                X509Certificate x509exchCert = null;
                                if (vistaMessage.isMessageType((byte)1)) {
                                    if (senderExchCertificateLocal == null) {
                                        throw new RuntimeCryptoException("Certificate for keyexchange must be passed");
                                    }
                                    byte[] senderExchCertBytes = UtilCM.getCertificateBlob(Base64.decode(senderExchCertificateLocal));
                                    cf = CertificateFactory.getInstance("X.509");
                                    x509exchCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(senderExchCertBytes));
                                }
                                FileHelper fileHelper = new FileHelper();
                                for (int i = 0; i < vistaMessage.getVistaFileCount(); ++i) {
                                    byte[] data = null;
                                    data = vistaMessage.isMessageType((byte)1) ? vistaMessage.getDecryptedFile(cryptoObject, passLocal, x509exchCert, i) : vistaMessage.getFile(i);
                                    String path = String.format("%s%s%s", directoryToSaveLocal, File.separator, vistaMessage.getVistaFileName(i));
                                    stringBuilder.append(path);
                                    if (i + 1 < vistaMessage.getVistaFileCount()) {
                                        stringBuilder.append(ROW_SEPARATOR);
                                    }
                                    fileHelper.saveData(data, path);
                                }
                                break;
                            }
                            default: {
                                throw new RuntimeCryptoException(String.format("Unknown information type: '%d'", informationTypeLocal));
                            }
                        }
                        return stringBuilder.toString();
                    }
                    catch (Exception e) {
                        throw new JCEHardwareException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            this.lastError = "Cannot parse Vista message. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String binToHex(String binInBase64) {
        try {
            String binInBase64Local;
            this.lastError = "";
            String string = binInBase64Local = binInBase64 != null && binInBase64.equals(NULL_AS_STRING) ? null : binInBase64;
            if (binInBase64Local != null) {
                byte[] bin = Base64.decode(binInBase64Local);
                return UtilCM.array2hex(bin);
            }
            throw new JCEHardwareException("binInBase64 cannot be null");
        }
        catch (Throwable e) {
            this.lastError = "Cannot convert bin to hex. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }

    public String invertParts(String binInBase64) {
        try {
            String binInBase64Local;
            this.lastError = "";
            String string = binInBase64Local = binInBase64 != null && binInBase64.equals(NULL_AS_STRING) ? null : binInBase64;
            if (binInBase64Local != null) {
                byte[] bin = Base64.decode(binInBase64Local);
                if (bin.length % 2 != 0) {
                    throw new RuntimeException("Bad binInBase64 length");
                }
                byte[] invertedParts = UtilCM.reverseParts(bin, 0);
                return new String(Base64.encode(invertedParts));
            }
            throw new JCEHardwareException("binInBase64 cannot be null");
        }
        catch (Throwable e) {
            this.lastError = "Cannot invert parts. Exception message: " + e.getMessage() + ".";
            e.printStackTrace();
            return null;
        }
    }
}

