/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import kz.gamma.hardware.asn1.ASN1OutputStream;
import kz.gamma.hardware.asn1.BEROutputStream;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private static final int MAX_LENGTH = 1000;
    private Vector octs;

    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != octs.size(); ++i) {
            try {
                DEROctetString o = (DEROctetString)octs.elementAt(i);
                bOut.write(o.getOctets());
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(octs.elementAt(i).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("exception converting octets " + e.toString());
            }
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octs) {
        super(BERConstructedOctetString.toBytes(octs));
        this.octs = octs;
    }

    public BERConstructedOctetString(DERObject obj) {
        super(obj);
    }

    public BERConstructedOctetString(DEREncodable obj) {
        super(obj.getDERObject());
    }

    @Override
    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        while (end + 1 < this.string.length) {
            if (this.string[end] == 0 && this.string[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                System.arraycopy(this.string, start, nStr, 0, nStr.length);
                vec.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.string.length - start];
        System.arraycopy(this.string, start, nStr, 0, nStr.length);
        vec.addElement(new DEROctetString(nStr));
        return vec;
    }

    @Override
    public void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(36);
            out.write(128);
            if (this.octs != null) {
                for (int i = 0; i != this.octs.size(); ++i) {
                    out.writeObject(this.octs.elementAt(i));
                }
            } else {
                for (int i = 0; i < this.string.length; i += 1000) {
                    int end = i + 1000 > this.string.length ? this.string.length : i + 1000;
                    byte[] nStr = new byte[end - i];
                    System.arraycopy(this.string, i, nStr, 0, nStr.length);
                    out.writeObject(new DEROctetString(nStr));
                }
            }
            out.write(0);
            out.write(0);
        } else {
            super.encode(out);
        }
    }
}

