/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1;

import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.BERConstructedOctetString;
import kz.gamma.hardware.asn1.DEREnumerated;
import kz.gamma.hardware.asn1.DERGeneralizedTime;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.DERUTF8String;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.util.CertificateFieldsResolver;
import kz.gamma.hardware.util.CharacterEncodingConvertor;

public class RevocationRequest {
    private String issuerCertificateDN = null;
    private byte[] \u0441ertificateSerialNumber = null;
    private String \u0441ertificateDN = null;
    private DERGeneralizedTime time = null;
    private int revocationReason = 0;
    private byte[] tbs = null;
    private CharacterEncodingConvertor characterEncodingConvertor = new CharacterEncodingConvertor();
    private static CertificateFieldsResolver certificateFieldsResolver = new CertificateFieldsResolver();

    private RevocationRequest(String issuerCertificateDN, byte[] \u0441ertificateSerialNumber, String \u0441ertificateDN, int revocationReason, DERGeneralizedTime time) {
        this.issuerCertificateDN = issuerCertificateDN;
        this.\u0441ertificateSerialNumber = \u0441ertificateSerialNumber;
        this.\u0441ertificateDN = \u0441ertificateDN;
        this.revocationReason = revocationReason;
        this.time = time;
        try {
            this.tbs = this.getTbs();
        }
        catch (UnsupportedEncodingException e) {
            this.tbs = null;
        }
    }

    private RevocationRequest(X509Certificate certificate, int revocationReason, DERGeneralizedTime time) throws UnsupportedEncodingException {
        this(certificate.getIssuerDN().getName(), (byte[])certificateFieldsResolver.getSerialNumber(certificate, (Integer)1), ((Object)certificate.getSubjectDN()).toString(), revocationReason, time);
    }

    private RevocationRequest(X509Certificate certificate, int revocationReason, Date time) throws UnsupportedEncodingException {
        this(certificate, revocationReason, new DERGeneralizedTime(time));
    }

    public RevocationRequest(X509Certificate certificate, int revocationReason) throws UnsupportedEncodingException {
        this(certificate, revocationReason, new Date());
    }

    public byte[] getTbs() throws UnsupportedEncodingException {
        if (this.tbs == null) {
            ASN1EncodableVector seq1 = new ASN1EncodableVector();
            ASN1EncodableVector seq2 = new ASN1EncodableVector();
            ASN1EncodableVector seq5 = new ASN1EncodableVector();
            seq5.add(new X509Name(this.issuerCertificateDN));
            seq5.add(new DERInteger(this.\u0441ertificateSerialNumber));
            seq5.add(new DEREnumerated(this.revocationReason));
            seq5.add(this.time);
            String str = this.\u0441ertificateDN;
            str = str.replaceAll("GIVENNAME", "G");
            str = str.replaceAll("SERIALNUMBER", "SN");
            str = str.replaceAll("EMAILADDRESS", "E");
            str = this.characterEncodingConvertor.convert(str, CharacterEncodingConvertor.kazChars, CharacterEncodingConvertor.rusChars);
            BERConstructedOctetString oct = new BERConstructedOctetString(str.getBytes("windows-1251"));
            seq5.add(oct);
            seq5.add(new DERUTF8String(" "));
            byte[] ret = null;
            ASN1EncodableVector seq3 = new ASN1EncodableVector();
            seq3.add(new DERInteger(1));
            seq3.add(new DERObjectIdentifier("1.3.6.1.5.5.7.7.5"));
            seq3.add(new DERSet(new DERInteger(new DERGeneralizedTime(new Date()).getDEREncoded())));
            ASN1EncodableVector seq4 = new ASN1EncodableVector();
            seq4.add(new DERInteger(2));
            seq4.add(new DERObjectIdentifier("1.3.6.1.5.5.7.7.17"));
            ASN1EncodableVector seq6 = new ASN1EncodableVector();
            seq6.add(new DERSequence(seq5));
            seq4.add(new DERSet(seq6));
            seq2.add(new DERSequence(seq3));
            seq2.add(new DERSequence(seq4));
            seq1.add(new DERSequence(seq2));
            seq1.add(new DERSequence());
            seq1.add(new DERSequence());
            seq1.add(new DERSequence());
            ret = new DERSequence(seq1).getDEREncoded();
            return ret;
        }
        return this.tbs;
    }

    public int getRevocationReason() {
        return this.revocationReason;
    }

    public byte[] getCertificateSerialNumber() {
        return this.\u0441ertificateSerialNumber;
    }

    public String getCertificateDN() {
        return this.\u0441ertificateDN;
    }

    public String getTime() {
        return this.time.getTime();
    }

    public String getIssuerCertificateDN() {
        return this.issuerCertificateDN;
    }
}

