/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1.ocsp;

import java.util.Enumeration;
import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1TaggedObject;
import kz.gamma.hardware.asn1.DERGeneralizedTime;
import kz.gamma.hardware.asn1.DERIA5String;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERTaggedObject;

public class CrlID
extends ASN1Encodable {
    DERIA5String crlUrl;
    DERInteger crlNum;
    DERGeneralizedTime crlTime;

    public CrlID(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        block5: while (e.hasMoreElements()) {
            ASN1TaggedObject o = (ASN1TaggedObject)e.nextElement();
            switch (o.getTagNo()) {
                case 0: {
                    this.crlUrl = DERIA5String.getInstance(o, true);
                    continue block5;
                }
                case 1: {
                    this.crlNum = DERInteger.getInstance(o, true);
                    continue block5;
                }
                case 2: {
                    this.crlTime = DERGeneralizedTime.getInstance(o, true);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + o.getTagNo());
        }
    }

    public DERIA5String getCrlUrl() {
        return this.crlUrl;
    }

    public DERInteger getCrlNum() {
        return this.crlNum;
    }

    public DERGeneralizedTime getCrlTime() {
        return this.crlTime;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.crlUrl != null) {
            v.add(new DERTaggedObject(true, 0, this.crlUrl));
        }
        if (this.crlNum != null) {
            v.add(new DERTaggedObject(true, 1, this.crlNum));
        }
        if (this.crlTime != null) {
            v.add(new DERTaggedObject(true, 2, this.crlTime));
        }
        return new DERSequence(v);
    }
}

