/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1TaggedObject;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.ocsp.Signature;
import kz.gamma.hardware.asn1.ocsp.TBSRequest;

public class OCSPRequest
extends ASN1Encodable {
    TBSRequest tbsRequest;
    Signature optionalSignature;

    public OCSPRequest(TBSRequest tbsRequest, Signature optionalSignature) {
        this.tbsRequest = tbsRequest;
        this.optionalSignature = optionalSignature;
    }

    public OCSPRequest(byte[] req) throws IOException {
        this(new ByteArrayInputStream(req));
    }

    public OCSPRequest(InputStream in) throws IOException {
        this((ASN1Sequence)new ASN1InputStream(in).readObject());
    }

    public OCSPRequest(ASN1Sequence seq) {
        this.tbsRequest = TBSRequest.getInstance(seq.getObjectAt(0));
        if (seq.size() == 2) {
            this.optionalSignature = Signature.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true);
        }
    }

    public static OCSPRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OCSPRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static OCSPRequest getInstance(Object obj) {
        if (obj == null || obj instanceof OCSPRequest) {
            return (OCSPRequest)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OCSPRequest((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSRequest getTbsRequest() {
        return this.tbsRequest;
    }

    public Signature getOptionalSignature() {
        return this.optionalSignature;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsRequest);
        if (this.optionalSignature != null) {
            v.add(new DERTaggedObject(true, 0, this.optionalSignature));
        }
        return new DERSequence(v);
    }
}

