/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1.pkcs;

import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.asn1.x509.X509Name;

public class CertificationRequestInfo
extends ASN1Encodable {
    DERInteger version = new DERInteger(0);
    X509Name subject;
    SubjectPublicKeyInfo subjectPKInfo;
    ASN1Set attributes = null;

    public static CertificationRequestInfo getInstance(Object obj) {
        if (obj instanceof CertificationRequestInfo) {
            return (CertificationRequestInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertificationRequestInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertificationRequestInfo(X509Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        this.subject = subject;
        this.subjectPKInfo = pkInfo;
        this.attributes = attributes;
        if (subject == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public CertificationRequestInfo(ASN1Sequence seq) {
        this.version = (DERInteger)seq.getObjectAt(0);
        this.subject = X509Name.getInstance(seq.getObjectAt(1));
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(2));
        if (seq.size() > 3) {
            DERTaggedObject tagobj = (DERTaggedObject)seq.getObjectAt(3);
            this.attributes = ASN1Set.getInstance(tagobj, false);
        }
        if (this.subject == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPKInfo;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.subject);
        v.add(this.subjectPKInfo);
        if (this.attributes != null) {
            v.add(new DERTaggedObject(false, 0, this.attributes));
        }
        return new DERSequence(v);
    }
}

