/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1.x509;

import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DERSequence;

public class PolicyInformation
extends ASN1Encodable {
    private DERObjectIdentifier policyIdentifier;
    private ASN1Sequence policyQualifiers;

    public PolicyInformation(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.policyIdentifier = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.policyQualifiers = ASN1Sequence.getInstance(seq.getObjectAt(1));
        }
    }

    public PolicyInformation(DERObjectIdentifier policyIdentifier) {
        this.policyIdentifier = policyIdentifier;
    }

    public PolicyInformation(DERObjectIdentifier policyIdentifier, ASN1Sequence policyQualifiers) {
        this.policyIdentifier = policyIdentifier;
        this.policyQualifiers = policyQualifiers;
    }

    public static PolicyInformation getInstance(Object obj) {
        if (obj == null || obj instanceof PolicyInformation) {
            return (PolicyInformation)obj;
        }
        return new PolicyInformation(ASN1Sequence.getInstance(obj));
    }

    public DERObjectIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public ASN1Sequence getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            v.add(this.policyQualifiers);
        }
        return new DERSequence(v);
    }
}

