/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.asn1.x509;

import java.io.IOException;
import kz.gamma.hardware.asn1.DERGeneralizedTime;
import kz.gamma.hardware.asn1.DERIA5String;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DERPrintableString;
import kz.gamma.hardware.asn1.DERUTF8String;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    @Override
    public DERObject getConvertedValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (oid.equals(X509Name.EmailAddress) || oid.equals(X509Name.DC)) {
            return new DERIA5String(value);
        }
        if (oid.equals(X509Name.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(value);
        }
        if (oid.equals(X509Name.C) || oid.equals(X509Name.SN) || oid.equals(X509Name.DN_QUALIFIER)) {
            return new DERPrintableString(value);
        }
        return new DERUTF8String(value);
    }
}

