/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import kz.gamma.hardware.asn1.ASN1Encodable;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1OctetStringParser;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1SequenceParser;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.ASN1SetParser;
import kz.gamma.hardware.asn1.ASN1StreamParser;
import kz.gamma.hardware.asn1.BERConstructedOctetString;
import kz.gamma.hardware.asn1.DERBitString;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DEREncodableVector;
import kz.gamma.hardware.asn1.DERGeneralizedTime;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.cms.Attribute;
import kz.gamma.hardware.asn1.cms.AttributeTable;
import kz.gamma.hardware.asn1.cms.ContentInfoParser;
import kz.gamma.hardware.asn1.cms.EncryptedContentInfo;
import kz.gamma.hardware.asn1.cms.EncryptedContentInfoParser;
import kz.gamma.hardware.asn1.cms.EnvelopedData;
import kz.gamma.hardware.asn1.cms.EnvelopedDataParser;
import kz.gamma.hardware.asn1.cms.OriginatorInfo;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.X509Name;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.core.archive.GzipArchiver;
import kz.gamma.hardware.crypto.BufferedBlockCipher;
import kz.gamma.hardware.crypto.GOST28147Engine;
import kz.gamma.hardware.crypto.mode.CFBBlockCipher;
import kz.gamma.hardware.crypto.params.KeyParameter;
import kz.gamma.hardware.crypto.params.ParametersWithIV;
import kz.gamma.hardware.crypto.params.ParametersWithSBox;
import kz.gamma.hardware.jce.CryptoObject;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.util.UtilCM;
import kz.gamma.hardware.x509.X509InstanceGetter;

public class CMSGammaEnvelopedData {
    private List recipientInfos = new LinkedList();
    private ASN1EncodableVector unAttr = new ASN1EncodableVector();
    private AttributeTable unAttrTable;
    private int version;
    private X509Name dnSenderIssuer;
    private byte[] exchSenderSn;
    private X509Name exchSenderName;
    X509Certificate exchSenderCert;
    JCEPrivateKey senderKey;
    private List<X509Name> recipientsNames;
    private byte[] content = null;
    private static byte[] h1 = new byte[]{1, 2, 0, 0, 31, 104, 4, 0, 31, 104, 0, 0};
    ParametersWithIV secKeyParam = null;
    CryptoObject cryptoObject = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvelopedData generateEnvelopedData(X509Certificate cert, boolean isInclude) throws CertificateEncodingException, IOException {
        ASN1EncodableVector vecRecipientInfos = new ASN1EncodableVector();
        ASN1EncodableVector vecRecipientKey = new ASN1EncodableVector();
        vecRecipientInfos.add(new DERInteger(3));
        ASN1EncodableVector vecSendInfo = new ASN1EncodableVector();
        vecSendInfo.add(new X509Name(cert.getIssuerX500Principal().toString()));
        vecSendInfo.add(new DERInteger(cert.getSerialNumber()));
        vecRecipientInfos.add(new DERTaggedObject(0, new DERSequence(vecSendInfo)));
        vecRecipientInfos.add(new AlgorithmIdentifier(GammaObjectIndentifiers.tumardh, new DERNull()));
        for (RecipientInfoGamma recipient : this.recipientInfos) {
            vecRecipientKey.add(recipient.toASN1Object());
        }
        vecRecipientInfos.add(new DERSequence(vecRecipientKey));
        OriginatorInfo originatorInfo = null;
        if (isInclude) {
            ASN1InputStream inStr = null;
            try {
                inStr = new ASN1InputStream(cert.getEncoded());
                originatorInfo = new OriginatorInfo(new DERSet(inStr.readObject()), null);
            }
            finally {
                if (inStr != null) {
                    try {
                        inStr.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new DERObjectIdentifier("1.2.840.113549.1.7.3"), new AlgorithmIdentifier(GammaObjectIndentifiers.gost28147, new DERNull()), this.content == null ? null : new BERConstructedOctetString(this.content));
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.8"), new DERSet(new X509Name(cert.getSubjectX500Principal().toString()))));
        this.unAttr.add(new Attribute(new DERObjectIdentifier("1.2.840.113549.1.9.5"), new DERSet(new DERGeneralizedTime(new Date()))));
        return new EnvelopedData(originatorInfo, new DERSet(new DERSequence(vecRecipientInfos)), encryptedContentInfo, new DERSet(this.unAttr));
    }

    public void addKeyRecipient(X509Certificate recipientCert) {
        boolean isAdd = false;
        RecipientInfoGamma rec = new RecipientInfoGamma(recipientCert, this.secKeyParam, this.senderKey, this.cryptoObject);
        this.recipientInfos.add(rec);
        for (int i = 0; i < this.unAttr.size(); ++i) {
            Attribute tmp = (Attribute)this.unAttr.get(0);
            if (!tmp.getAttrType().toString().equals("1.3.6.1.4.1.6801.2.9")) continue;
            ASN1Set asn1Set = tmp.getAttrValues();
            this.unAttr = new ASN1EncodableVector();
            DEREncodableVector derEncodableVector = new DEREncodableVector();
            derEncodableVector.add(asn1Set.getObjectAt(0).getDERObject());
            derEncodableVector.add(new X509Name(recipientCert.getSubjectX500Principal().toString()).toASN1Object());
            DERSet derSet = new DERSet(derEncodableVector);
            this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"), derSet));
            isAdd = true;
        }
        if (!isAdd) {
            this.unAttr.add(new Attribute(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"), new DERSet(new X509Name(recipientCert.getSubjectX500Principal().toString()))));
        }
    }

    public void addUnprotectedAttrs(Attribute attr) {
        this.unAttr.add(attr);
    }

    public CMSGammaEnvelopedData() {
    }

    public CMSGammaEnvelopedData(byte[] cmsDevelopedBuf) throws IOException, NoSuchProviderException, CertificateException, CMSException, NoSuchAlgorithmException {
        ASN1StreamParser as = new ASN1StreamParser(cmsDevelopedBuf);
        ContentInfoParser cP = new ContentInfoParser((ASN1SequenceParser)as.readObject());
        EnvelopedDataParser eP = new EnvelopedDataParser((ASN1SequenceParser)cP.getContent(16));
        this.version = eP.getVersion().getValue().intValue();
        ASN1SetParser certPars = eP.getCertificates();
        if (certPars != null) {
            DERTaggedObject certObject = (DERTaggedObject)certPars.readObject();
            DEREncodable en = certObject.getObjectParser(0, true);
            X509InstanceGetter x509InstanceGetter = new X509InstanceGetter();
            this.exchSenderCert = x509InstanceGetter.getX509CertificateInstance(en.getDERObject().getEncoded());
        }
        DERObject obj = eP.getRecipientInfos().getDERObject();
        DERSequence obj1 = (DERSequence)((DERSet)obj).getObjectAt(0);
        int ver = ((DERInteger)obj1.getObjectAt(0)).getValue().intValue();
        this.dnSenderIssuer = new X509Name((ASN1Sequence)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(0));
        this.exchSenderSn = ((DERInteger)((DERSequence)((DERTaggedObject)obj1.getObjectAt(1)).getObjectParser(0, true)).getObjectAt(1)).getValue().toByteArray();
        this.recipientInfos.clear();
        DERSequence seq = (DERSequence)obj1.getObjectAt(3);
        int count = seq.size();
        for (int i = 0; i < count; ++i) {
            this.recipientInfos.add(new RecipientInfoGamma((DERSequence)seq.getObjectAt(i)));
        }
        EncryptedContentInfoParser ecP = eP.getEncryptedContentInfo();
        try {
            this.content = ((DEROctetString)((ASN1OctetStringParser)ecP.getEncryptedContent(4)).getDERObject()).getOctets();
        }
        catch (NullPointerException e) {
            this.content = null;
        }
        ASN1SetParser prs = eP.getUnprotectedAttrs();
        DEREncodable nextObject = prs.readObject();
        while (nextObject != null) {
            this.unAttr.add(new Attribute((ASN1Sequence)nextObject.getDERObject()));
            nextObject = prs.readObject();
        }
        this.unAttrTable = new AttributeTable(this.unAttr);
        this.exchSenderName = new X509Name((ASN1Sequence)this.getAttributeByOid(this.unAttrTable, "1.3.6.1.4.1.6801.2.8"));
        Attribute at = this.unAttrTable.get(new DERObjectIdentifier("1.3.6.1.4.1.6801.2.9"));
        ASN1Set attrValuesSet = at.getAttrValues();
        this.recipientsNames = new LinkedList<X509Name>();
        for (int i = 0; i < attrValuesSet.size(); ++i) {
            X509Name tmpName = new X509Name((ASN1Sequence)attrValuesSet.getObjectAt(i).getDERObject());
            this.recipientsNames.add(tmpName);
        }
    }

    public DERObject getAttributeByOid(AttributeTable attributeTable, String oid) {
        Attribute at = attributeTable.get(new DERObjectIdentifier(oid));
        DEREncodable obj = at.getAttrValues().getObjectAt(0);
        return obj.getDERObject();
    }

    public byte[] cryptText(byte[] buf, boolean includeContent) {
        byte[] ret = new byte[buf.length];
        ParametersWithSBox sBox = (ParametersWithSBox)this.secKeyParam.getParameters();
        KeyParameter parameter = (KeyParameter)sBox.getParameters();
        BufferedBlockCipher blockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        blockCipher.reset();
        blockCipher.init(true, this.secKeyParam);
        blockCipher.processBytes(buf, 0, buf.length, ret, 0);
        if (includeContent) {
            this.content = ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptText(CryptoObject object, String pass, X509Certificate senderCert, byte[] crpData) {
        byte[] ret = null;
        RecipientInfoGamma rInfo = null;
        ASN1InputStream asn1InputStream = null;
        Enumeration<JCEKeyPair> keyPairs = object.getKeyList(pass);
        X509Certificate x509Certificate = null;
        JCEKeyPair keyPair = null;
        if (keyPairs != null) {
            while (keyPairs.hasMoreElements()) {
                keyPair = keyPairs.nextElement();
                if (keyPair.getCertBlob() == null) continue;
                byte[] certBodyBytes = keyPair.getCertBlob();
                if (UtilCM.getCertificateBlob(certBodyBytes) == null) {
                    GzipArchiver gzipArchiver = new GzipArchiver();
                    certBodyBytes = gzipArchiver.ungzip(certBodyBytes);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBodyBytes));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot generate certificate");
                }
                for (Object recipientInf : this.recipientInfos) {
                    RecipientInfoGamma tmpInfo = (RecipientInfoGamma)recipientInf;
                    if (!tmpInfo.snRecipient.getValue().equals(x509Certificate.getSerialNumber())) continue;
                    rInfo = tmpInfo;
                    break;
                }
                if (rInfo == null) continue;
                break;
            }
        }
        if (rInfo == null) {
            throw new IllegalArgumentException("Required encrypted key not found");
        }
        byte[] openKeyBlob = senderCert.getPublicKey().getEncoded();
        byte[] openKey = null;
        if (openKeyBlob[0] == 6) {
            openKey = UtilCM.reverseParts(openKeyBlob, 16);
        } else {
            try {
                asn1InputStream = new ASN1InputStream(openKeyBlob);
                openKey = UtilCM.reverseParts(((DERBitString)((DERSequence)asn1InputStream.readObject()).getObjectAt(1)).getBytes(), 16);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (asn1InputStream != null) {
                    try {
                        asn1InputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        byte[] ukm = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        byte[] dhKey = UtilCM.reverseParts(object.makeDH(keyPair.getPrivateKey(), openKey, ukm), 0);
        byte[] sesKey = new byte[dhKey.length / 2];
        for (int i = 0; i < dhKey.length / 2; ++i) {
            sesKey[i] = (byte)(dhKey[i] ^ dhKey[dhKey.length / 2 + i]);
        }
        byte[] iv = null;
        byte[] iv_crp = null;
        byte[] keySecretLocal = null;
        byte[] keyTmp = UtilCM.copyByte(rInfo.keySecret, h1.length, rInfo.keySecret.length - h1.length);
        try {
            asn1InputStream = new ASN1InputStream(keyTmp);
            DERSequence tmpSeq = (DERSequence)asn1InputStream.readObject();
            iv = ((DEROctetString)tmpSeq.getObjectAt(1)).getOctets();
            iv_crp = ((DEROctetString)tmpSeq.getObjectAt(2)).getOctets();
            keySecretLocal = ((DEROctetString)tmpSeq.getObjectAt(3)).getOctets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        KeyParameter keyParameter = new KeyParameter(sesKey);
        ParametersWithSBox sBox = new ParametersWithSBox(keyParameter, GOST28147Engine.getSBox("D-G"));
        BufferedBlockCipher blockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        this.secKeyParam = new ParametersWithIV(sBox, iv);
        blockCipher.reset();
        blockCipher.init(false, this.secKeyParam);
        byte[] tmpData = new byte[8];
        blockCipher.processBytes(iv_crp, 0, iv_crp.length, tmpData, 0);
        iv = UtilCM.copyByte(tmpData, 0, tmpData.length);
        tmpData = new byte[64];
        blockCipher.processBytes(keySecretLocal, 0, keySecretLocal.length, tmpData, 0);
        keySecretLocal = UtilCM.copyByte(tmpData, 0, tmpData.length);
        KeyParameter keyParameter1 = new KeyParameter(keySecretLocal);
        ParametersWithSBox sBox1 = new ParametersWithSBox(keyParameter1, GOST28147Engine.getSBox("D-G"));
        ParametersWithIV secKeyParam1 = new ParametersWithIV(sBox1, iv);
        BufferedBlockCipher blockCipher1 = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        blockCipher1.reset();
        blockCipher1.init(false, secKeyParam1);
        ret = new byte[crpData.length];
        blockCipher1.processBytes(crpData, 0, crpData.length, ret, 0);
        return ret;
    }

    public ASN1EncodableVector getUnAttr() {
        return this.unAttr;
    }

    public void initDHParameter(CryptoObject cryptoObject, JCEPrivateKey key) {
        this.senderKey = key;
        this.cryptoObject = cryptoObject;
        byte[] secKey = new byte[64];
        byte[] iv = new byte[8];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(secKey);
        secureRandom.nextBytes(iv);
        KeyParameter keyParameter = new KeyParameter(secKey);
        ParametersWithSBox sBox = new ParametersWithSBox(keyParameter, GOST28147Engine.getSBox("D-G"));
        this.secKeyParam = new ParametersWithIV(sBox, iv);
    }

    public List getRecipientInfos() {
        return this.recipientInfos;
    }

    public List getRecipientsSerialNumbers() {
        LinkedList<BigInteger> serialNumbers = new LinkedList<BigInteger>();
        for (Object recipientInf : this.recipientInfos) {
            RecipientInfoGamma tmpInfo = (RecipientInfoGamma)recipientInf;
            serialNumbers.add(tmpInfo.snRecipient.getValue());
        }
        return serialNumbers;
    }

    public List<X509Name> getRecipientsNames() {
        return this.recipientsNames;
    }

    public byte[] getExchSenderSn() {
        return this.exchSenderSn;
    }

    public X509Name getExchSenderName() {
        return this.exchSenderName;
    }

    public X509Certificate getExchSenderCert() {
        return this.exchSenderCert;
    }

    protected class RecipientInfoGamma
    extends ASN1Encodable {
        X509Name dnIssuerRecipient = null;
        DERInteger snRecipient = null;
        byte[] keySecret = null;

        public RecipientInfoGamma(DERSequence der) {
            this.dnIssuerRecipient = new X509Name((ASN1Sequence)((DERSequence)der.getObjectAt(0)).getObjectAt(0));
            this.snRecipient = (DERInteger)((DERSequence)der.getObjectAt(0)).getObjectAt(1);
            this.keySecret = ((DEROctetString)der.getObjectAt(1)).getOctets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RecipientInfoGamma(X509Certificate certRecipient, ParametersWithIV secKeyParam, JCEPrivateKey senderKey, CryptoObject cryptoObject) {
            ASN1EncodableVector sBlob = new ASN1EncodableVector();
            sBlob.add(new DERInteger(4));
            SecureRandom secureRandom = new SecureRandom();
            byte[] iv = new byte[8];
            secureRandom.nextBytes(iv);
            sBlob.add(new DEROctetString(iv));
            byte[] ukm = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
            byte[] openKeyBlob = certRecipient.getPublicKey().getEncoded();
            byte[] openKey = null;
            if (openKeyBlob[0] == 6) {
                openKey = UtilCM.reverseParts(openKeyBlob, 16);
            } else {
                ASN1InputStream asn1InputStream = null;
                try {
                    asn1InputStream = new ASN1InputStream(openKeyBlob);
                    openKey = UtilCM.reverseParts(((DERBitString)((DERSequence)asn1InputStream.readObject()).getObjectAt(1)).getBytes(), 16);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (asn1InputStream != null) {
                        try {
                            asn1InputStream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            byte[] dhKey = UtilCM.reverseParts(cryptoObject.makeDH(senderKey, openKey, ukm), 0);
            byte[] sesKey = new byte[dhKey.length / 2];
            for (int i = 0; i < dhKey.length / 2; ++i) {
                sesKey[i] = (byte)(dhKey[i] ^ dhKey[dhKey.length / 2 + i]);
            }
            ParametersWithSBox sBox = (ParametersWithSBox)secKeyParam.getParameters();
            KeyParameter parameter = (KeyParameter)sBox.getParameters();
            KeyParameter keyParameter = new KeyParameter(sesKey);
            ParametersWithSBox sBox1 = new ParametersWithSBox(keyParameter, GOST28147Engine.getSBox("D-G"));
            BufferedBlockCipher blockCipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
            ParametersWithIV secKeyParam1 = new ParametersWithIV(sBox1, iv);
            blockCipher.init(true, secKeyParam1);
            byte[] crpData = new byte[8];
            blockCipher.processBytes(secKeyParam.getIV(), 0, secKeyParam.getIV().length, crpData, 0);
            sBlob.add(new DEROctetString(crpData));
            crpData = new byte[64];
            blockCipher.processBytes(parameter.getKey(), 0, parameter.getKey().length, crpData, 0);
            sBlob.add(new DEROctetString(crpData));
            this.keySecret = UtilCM.concat(h1, new DERSequence(sBlob).getDEREncoded());
            this.dnIssuerRecipient = new X509Name(certRecipient.getIssuerX500Principal().toString());
            this.snRecipient = new DERInteger(certRecipient.getSerialNumber());
        }

        @Override
        public DERObject toASN1Object() {
            ASN1EncodableVector recInfo = new ASN1EncodableVector();
            ASN1EncodableVector infoKeyId = new ASN1EncodableVector();
            infoKeyId.add(this.dnIssuerRecipient);
            infoKeyId.add(this.snRecipient);
            recInfo.add(new DERSequence(infoKeyId));
            BERConstructedOctetString oct = new BERConstructedOctetString(this.keySecret);
            recInfo.add(oct);
            return new DERSequence(recInfo);
        }
    }
}

