/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Map;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1OctetString;
import kz.gamma.hardware.asn1.ASN1OutputStream;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.BERSequence;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.cms.ContentInfo;
import kz.gamma.hardware.asn1.cms.SignedData;
import kz.gamma.hardware.asn1.cms.SignerInfo;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.cms.CMSProcessable;
import kz.gamma.hardware.cms.CMSProcessableByteArray;
import kz.gamma.hardware.cms.CMSSignedHelper;
import kz.gamma.hardware.cms.CMSUtils;
import kz.gamma.hardware.cms.SignerInformation;
import kz.gamma.hardware.cms.SignerInformationStore;
import kz.gamma.hardware.x509.NoSuchStoreException;
import kz.gamma.hardware.x509.X509Store;

public class CMSSignedData {
    private static CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSProcessable signedContent;
    CertStore certStore;
    SignerInformationStore signerInfoStore;
    X509Store attributeStore;
    X509Store certificateStore;
    X509Store crlStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData c) {
        this.signedData = c.signedData;
        this.contentInfo = c.contentInfo;
        this.signedContent = c.signedContent;
        this.certStore = c.certStore;
        this.signerInfoStore = c.signerInfoStore;
    }

    public CMSSignedData(byte[] sigBlock) throws CMSException {
        this(CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(Map hashes, byte[] sigBlock) throws CMSException {
        this(hashes, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, InputStream sigData) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(sigData)));
    }

    public CMSSignedData(InputStream sigData) throws CMSException {
        this(CMSUtils.readContentInfo(sigData));
    }

    public CMSSignedData(CMSProcessable signedContent, ContentInfo sigData) {
        this.signedContent = signedContent;
        this.contentInfo = sigData;
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
    }

    public CMSSignedData(Map hashes, ContentInfo sigData) {
        this.hashes = hashes;
        this.contentInfo = sigData;
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
    }

    public CMSSignedData(ContentInfo sigData) {
        this.contentInfo = sigData;
        this.signedData = SignedData.getInstance(this.contentInfo.getContent());
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set s = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> signerInfos = new ArrayList<SignerInformation>();
            for (int i = 0; i != s.size(); ++i) {
                if (this.hashes == null) {
                    signerInfos.add(new SignerInformation(SignerInfo.getInstance(s.getObjectAt(i)), this.signedData.getEncapContentInfo().getContentType(), this.signedContent, null));
                    continue;
                }
                SignerInfo info = SignerInfo.getInstance(s.getObjectAt(i));
                byte[] hash = (byte[])this.hashes.get(info.getDigestAlgorithm().getObjectId().getId());
                signerInfos.add(new SignerInformation(info, this.signedData.getEncapContentInfo().getContentType(), null, hash));
            }
            this.signerInfoStore = new SignerInformationStore(signerInfos);
        }
        return this.signerInfoStore;
    }

    public X509Store getAttributeCertificates(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this.attributeStore == null) {
            this.attributeStore = HELPER.createAttributeStore(type, provider, this.signedData.getCertificates());
        }
        return this.attributeStore;
    }

    public X509Store getCRLs(String type, String provider) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.crlStore;
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this.certStore == null) {
            ASN1Set certSet = this.signedData.getCertificates();
            ASN1Set crlSet = this.signedData.getCRLs();
            this.certStore = HELPER.createCertStore(type, provider, certSet, crlSet);
        }
        return this.certStore;
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSProcessable getSignedContent() {
        return this.signedContent;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.contentInfo);
        return bOut.toByteArray();
    }

    public static CMSSignedData replaceSigners(CMSSignedData signedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.signerInfoStore = signerInformationStore;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (SignerInformation signer : signerInformationStore.getSigners()) {
            AlgorithmIdentifier digAlgId;
            try {
                digAlgId = CMSSignedData.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            }
            catch (IOException e) {
                throw new RuntimeException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            vec.add(signer.toSignerInfo());
        }
        DERSet digests = new DERSet(digestAlgs);
        DERSet signers = new DERSet(vec);
        ASN1Sequence sD = (ASN1Sequence)signedData.signedData.getDERObject();
        vec = new ASN1EncodableVector();
        vec.add(sD.getObjectAt(0));
        vec.add(digests);
        for (int i = 2; i != sD.size() - 1; ++i) {
            vec.add(sD.getObjectAt(i));
        }
        vec.add(signers);
        cms.signedData = SignedData.getInstance(new BERSequence(vec));
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData signedData, CertStore certsAndCrls) throws CMSException {
        ASN1Set set;
        CMSSignedData cms = new CMSSignedData(signedData);
        cms.certStore = certsAndCrls;
        ASN1Set certs = null;
        ASN1Set crls = null;
        try {
            set = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certsAndCrls));
            if (set.size() != 0) {
                certs = set;
            }
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting certs from certStore", e);
        }
        try {
            set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certsAndCrls));
            if (set.size() != 0) {
                crls = set;
            }
        }
        catch (CertStoreException e) {
            throw new CMSException("error getting crls from certStore", e);
        }
        cms.signedData = new SignedData(signedData.signedData.getDigestAlgorithms(), signedData.signedData.getEncapContentInfo(), certs, crls, signedData.signedData.getSignerInfos());
        cms.contentInfo = new ContentInfo(cms.contentInfo.getContentType(), cms.signedData);
        return cms;
    }

    private static DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), CMSSignedData.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }
}

