/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.BERConstructedOctetString;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.cms.AttributeTable;
import kz.gamma.hardware.asn1.cms.ContentInfo;
import kz.gamma.hardware.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.hardware.asn1.cms.SignedData;
import kz.gamma.hardware.asn1.cms.SignerIdentifier;
import kz.gamma.hardware.asn1.cms.SignerInfo;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.TBSCertificateStructure;
import kz.gamma.hardware.cms.CMSAttributeTableGenerator;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.cms.CMSProcessable;
import kz.gamma.hardware.cms.CMSSignedData;
import kz.gamma.hardware.cms.CMSSignedGenerator;
import kz.gamma.hardware.cms.CMSUtils;
import kz.gamma.hardware.cms.DefaultSignedAttributeTableGenerator;
import kz.gamma.hardware.cms.SignatureInformation;
import kz.gamma.hardware.cms.SignerInformation;
import kz.gamma.hardware.cms.SimpleAttributeTableGenerator;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;

public class CMSSignedDataCreator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public void addSigner(X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = this.getEncOID(null, digestOID);
        this.signerInfs.add(new SignerInf(cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, SignatureInformation signatureInformation) throws CMSException {
        ContentInfo encInfo;
        AlgorithmIdentifier digAlgId;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        this._digests.clear();
        for (Object signer : this._signers) {
            try {
                digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(((SignerInformation)signer).toSignerInfo());
        }
        for (Object signer : this.signerInfs) {
            try {
                digAlgId = this.makeAlgId(((SignerInf)signer).getDigestAlgOID(), ((SignerInf)signer).getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(((SignerInf)signer).toSignerInfo(signatureInformation));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CMSException("No such algorithm.", e);
            }
            catch (NoSuchProviderException e) {
                throw new CMSException("No such provider.", e);
            }
            catch (PcscException e) {
                throw new CMSException("Crypto error.", e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this._crls);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, SignatureInformation signatureInformation) throws CMSException {
        return this.generate(DATA, content, encapsulate, signatureInformation);
    }

    private class SignerInf {
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSignedTable;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(SignatureInformation signatureInformation) throws IOException, CertificateEncodingException, CMSException, NoSuchProviderException, NoSuchAlgorithmException, PcscException {
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = CMSSignedDataCreator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            ASN1Set signedAttr = CMSSignedDataCreator.this.getAttributeSet(this.baseSignedTable);
            if (signedAttr == null) {
                throw new CMSException("signedAttributes cannot be null");
            }
            DEROctetString encDigest = new DEROctetString(signatureInformation.getSignature());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(null) : null;
            ASN1Set unsignedAttr = CMSSignedDataCreator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }
}

