/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.BERConstructedOctetString;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DEROutputStream;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.cms.AttributeTable;
import kz.gamma.hardware.asn1.cms.ContentInfo;
import kz.gamma.hardware.asn1.cms.IssuerAndSerialNumber;
import kz.gamma.hardware.asn1.cms.SignedData;
import kz.gamma.hardware.asn1.cms.SignerIdentifier;
import kz.gamma.hardware.asn1.cms.SignerInfo;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.TBSCertificateStructure;
import kz.gamma.hardware.cms.CMSAttributeTableGenerator;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.cms.CMSProcessable;
import kz.gamma.hardware.cms.CMSSignedData;
import kz.gamma.hardware.cms.CMSSignedGenerator;
import kz.gamma.hardware.cms.CMSUtils;
import kz.gamma.hardware.cms.DefaultSignedAttributeTableGenerator;
import kz.gamma.hardware.cms.SignerInformation;
import kz.gamma.hardware.cms.SimpleAttributeTableGenerator;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.JCESignature;
import kz.gamma.hardware.util.UtilCM;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();
    boolean isCertexCMS = false;

    public void addSigner(JCEPrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(JCEPrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(JCEPrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, signedAttrGen, unsignedAttrGen, null));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public CMSSignedData generate(CMSProcessable content, JCESignature signature) throws CMSException {
        return this.generate(content, false, signature);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, JCESignature signature) throws CMSException {
        return this.generate(signedContentType, content, encapsulate, signature, true);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, JCESignature signature, boolean addDefaultAttributes) throws CMSException {
        ContentInfo encInfo;
        AlgorithmIdentifier digAlgId;
        if (signedContentType.equals("1.3.6.1.4.1.6801.11.1.9")) {
            this.isCertexCMS = true;
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        this._digests.clear();
        for (Object signer : this._signers) {
            try {
                digAlgId = this.makeAlgId(((SignerInformation)signer).getDigestAlgOID(), ((SignerInformation)signer).getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(((SignerInformation)signer).toSignerInfo());
        }
        for (Object signer : this.signerInfs) {
            try {
                digAlgId = this.makeAlgId(((SignerInf)signer).getDigestAlgOID(), ((SignerInf)signer).getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(((SignerInf)signer).toSignerInfo(contentTypeOID, content, signature, addDefaultAttributes));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CMSException("No such algorithm.", e);
            }
            catch (NoSuchProviderException e) {
                throw new CMSException("No such provider.", e);
            }
            catch (PcscException e) {
                throw new CMSException("Crypto error.", e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this._crls);
        }
        if (encapsulate) {
            BERConstructedOctetString octs;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            if (!this.isCertexCMS) {
                octs = new BERConstructedOctetString(bOut.toByteArray());
            } else {
                byte[] oid = new byte[24];
                String str = "1.3.6.1.4.1.6801.11.1.9";
                System.arraycopy(str.getBytes(), 0, oid, 0, 23);
                octs = new BERConstructedOctetString(oid);
            }
            encInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, JCESignature signature) throws CMSException {
        return this.generate(DATA, content, encapsulate, signature);
    }

    private class SignerInf {
        JCEPrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(JCEPrivateKey key, X509Certificate cert, String digestOID, String encOID) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
        }

        SignerInf(JCEPrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSigneTable;
        }

        JCEPrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, JCESignature sig, boolean addDefaultAttributes) throws IOException, CertificateEncodingException, CMSException, NoSuchProviderException, NoSuchAlgorithmException, PcscException {
            DEROctetString encDigest;
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            MessageDigest dig = sig.getMessageDigest();
            byte[] hash = null;
            if (!CMSSignedDataGenerator.this.isCertexCMS && content != null) {
                content.write(new DigOutputStream(dig));
                hash = dig.digest();
                CMSSignedDataGenerator.this._digests.put(this.digestOID, hash.clone());
            }
            if (addDefaultAttributes) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            ASN1Set signedAttr = CMSSignedDataGenerator.this.getAttributeSet(signed);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
            } else {
                content.write(bOut);
            }
            sig.initSign(this.key);
            sig.update(bOut.toByteArray());
            if (CMSSignedDataGenerator.this.isCertexCMS) {
                byte[] signBlob = UtilCM.copyByte(sig.sign(), 0, 64);
                encDigest = new DEROctetString(signBlob);
            } else {
                encDigest = new DEROctetString(sig.sign());
            }
            Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = CMSSignedDataGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        JCESignature sig;

        public SigOutputStream(JCESignature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.sig.update(b, off, len);
            }
            catch (Exception e) {
                throw new IOException("signature problem: " + e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (Exception e) {
                throw new IOException("signature problem: " + e);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

