/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.IOException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.gamma.hardware.asn1.ASN1Object;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DERNull;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.cms.AttributeTable;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.hardware.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.AlgorithmIdentifier;
import kz.gamma.hardware.asn1.x509.AttributeCertificate;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.cms.CMSUtils;
import kz.gamma.hardware.cms.SignerInformationStore;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.x509.X509AttributeCertificate;
import kz.gamma.hardware.x509.X509Store;

public class CMSSignedGenerator {
    public static final String DATA = PKCSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_GOST3411G = GammaObjectIndentifiers.gost34311.getId();
    public static final String DIGEST_KZ_GOST_34_11_95 = KZObjectIndentifiers.GOST_34_11_95.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_ECGOST3410 = GammaObjectIndentifiers.gost34310.getId();
    public static final String ENCRYPTION_KZ_GOST_34_310_SIGNATURE = KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId();
    private static final Set NO_PARAMS = new HashSet();
    protected List _certs = new ArrayList();
    protected List _crls = new ArrayList();
    protected List _signers = new ArrayList();
    protected Map _digests = new HashMap();

    protected CMSSignedGenerator() {
    }

    protected String getEncOID(JCEPrivateKey key, String digestOID) {
        String encOID = null;
        if (key == null) {
            encOID = digestOID.equals(DIGEST_GOST3411G) ? ENCRYPTION_ECGOST3410 : (digestOID.equals(DIGEST_KZ_GOST_34_11_95) ? ENCRYPTION_KZ_GOST_34_310_SIGNATURE : ENCRYPTION_RSA);
        } else if (key instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            encOID = ENCRYPTION_RSA;
        } else if ("ECGOST3410".equalsIgnoreCase(key.getAlgorithm())) {
            if (digestOID.equals(DIGEST_GOST3411G)) {
                encOID = ENCRYPTION_ECGOST3410;
            } else if (digestOID.equals(DIGEST_KZ_GOST_34_11_95)) {
                encOID = ENCRYPTION_KZ_GOST_34_310_SIGNATURE;
            }
        } else if ("ECGAMMAKEY".equalsIgnoreCase(key.getAlgorithm())) {
            encOID = digestOID.equals(DIGEST_GOST3411G) ? ENCRYPTION_ECGOST3410 : (digestOID.equals(DIGEST_KZ_GOST_34_11_95) ? ENCRYPTION_KZ_GOST_34_310_SIGNATURE : ENCRYPTION_RSA);
        }
        return encOID;
    }

    protected AlgorithmIdentifier getEncAlgorithmIdentifier(String encOid) {
        if (NO_PARAMS.contains(encOid)) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(encOid));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(encOid), new DERNull());
    }

    protected Map getBaseParameters(DERObjectIdentifier contentType, AlgorithmIdentifier digAlgId, byte[] hash) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contentType", contentType);
        param.put("digestAlgID", digAlgId);
        if (hash != null) {
            param.put("digest", hash.clone());
        }
        return param;
    }

    protected ASN1Set getAttributeSet(AttributeTable attr) {
        if (attr != null) {
            return new DERSet(attr.toASN1EncodableVector());
        }
        return null;
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        this._certs.addAll(CMSUtils.getCertificatesFromStore(certStore));
        this._crls.addAll(CMSUtils.getCRLsFromStore(certStore));
    }

    public void addAttributeCertificates(X509Store store) throws CMSException {
        try {
            for (X509AttributeCertificate attrCert : store.getMatches(null)) {
                this._certs.add(new DERTaggedObject(false, 2, AttributeCertificate.getInstance(ASN1Object.fromByteArray(attrCert.getEncoded()))));
            }
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing attribute certs", e);
        }
        catch (IOException e) {
            throw new CMSException("error processing attribute certs", e);
        }
    }

    public void addSigners(SignerInformationStore signerStore) {
        Iterator it = signerStore.getSigners().iterator();
        while (it.hasNext()) {
            this._signers.add(it.next());
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }
}

