/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.cryptopro.GammaObjectIndentifiers;
import kz.gamma.hardware.asn1.cryptopro.KZObjectIndentifiers;
import kz.gamma.hardware.asn1.oiw.OIWObjectIdentifiers;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.x509.NoSuchStoreException;
import kz.gamma.hardware.x509.X509Store;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();
    private static final Map encryptionAlgs = new HashMap();
    private static final Map digestAlgs = new HashMap();
    private static final Map digestAliases = new HashMap();

    CMSSignedHelper() {
    }

    String getDigestAlgName(String digestAlgOID) {
        String algName = (String)digestAlgs.get(digestAlgOID);
        if (algName != null) {
            return algName;
        }
        return digestAlgOID;
    }

    String[] getDigestAliases(String algName) {
        String[] aliases = (String[])digestAliases.get(algName);
        if (aliases != null) {
            return aliases;
        }
        return new String[0];
    }

    String getEncryptionAlgName(String encryptionAlgOID) {
        String algName = (String)encryptionAlgs.get(encryptionAlgOID);
        if (algName != null) {
            return algName;
        }
        return encryptionAlgOID;
    }

    MessageDigest getDigestInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createDigestInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String[] aliases = this.getDigestAliases(algorithm);
            for (int i = 0; i != aliases.length; ++i) {
                try {
                    return this.createDigestInstance(aliases[i], provider);
                }
                catch (NoSuchAlgorithmException ex) {
                    continue;
                }
            }
            if (provider != null) {
                return this.getDigestInstance(algorithm, null);
            }
            throw e;
        }
    }

    private MessageDigest createDigestInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider != null) {
            return MessageDigest.getInstance(algorithm, provider);
        }
        return MessageDigest.getInstance(algorithm);
    }

    X509Store createAttributeStore(String type, String provider, ASN1Set certSet) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return null;
    }

    CertStore createCertStore(String type, String provider, ASN1Set certSet, ASN1Set crlSet) throws NoSuchProviderException, CMSException, NoSuchAlgorithmException {
        ArrayList certsAndcrls = new ArrayList();
        if (certSet != null) {
            this.addCertsFromSet(certsAndcrls, certSet, provider);
        }
        try {
            if (provider != null) {
                return CertStore.getInstance(type, (CertStoreParameters)new CollectionCertStoreParameters(certsAndcrls), provider);
            }
            return CertStore.getInstance(type, new CollectionCertStoreParameters(certsAndcrls));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("can't setup the CertStore", e);
        }
    }

    private void addCertsFromSet(List certs, ASN1Set certSet, String provider) throws NoSuchProviderException, CMSException {
        Enumeration e = certSet.getObjects();
        while (e.hasMoreElements()) {
            try {
                DERObject obj = ((DEREncodable)e.nextElement()).getDERObject();
                if (!(obj instanceof ASN1Sequence)) continue;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certs.add(cf.generateCertificate(new ByteArrayInputStream(obj.getEncoded())));
            }
            catch (IOException ex) {
                throw new CMSException("can't re-encode certificate!", ex);
            }
            catch (CertificateException ex) {
                throw new CMSException("can't re-encode certificate!", ex);
            }
        }
    }

    private boolean anyCertHasTypeOther() {
        return false;
    }

    private boolean anyCertHasV1Attribute() {
        return false;
    }

    private boolean anyCertHasV2Attribute() {
        return false;
    }

    private boolean anyCrlHasTypeOther() {
        return false;
    }

    static {
        encryptionAlgs.put(OIWObjectIdentifiers.dsaWithSHA1.getId(), "DSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.rsaEncryption.getId(), "RSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "RSA");
        encryptionAlgs.put(OIWObjectIdentifiers.sha1WithRSA.getId(), "RSA");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A_EX.getId(), "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.6.2", "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.1.5", "GOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310.getId(), "ECGOST3410");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34310_GammaTech_A.getId(), "ECGOST3410");
        encryptionAlgs.put(KZObjectIndentifiers.GOST_34_310_SIGNATURE.getId(), "ECGOST3410");
        digestAlgs.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestAlgs.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestAlgs.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        digestAlgs.put(GammaObjectIndentifiers.gost34311.getId(), "GOST3411");
        digestAlgs.put(KZObjectIndentifiers.GOST_34_11_95.getId(), "GOST3411");
        digestAlgs.put(KZObjectIndentifiers.GOST_34_11_95_TEST.getId(), "GOST3411");
        encryptionAlgs.put(GammaObjectIndentifiers.gost34311.getId(), "GOST3411");
        digestAliases.put("SHA1", new String[]{"SHA-1"});
        digestAliases.put("SHA224", new String[]{"SHA-224"});
        digestAliases.put("SHA256", new String[]{"SHA-256"});
        digestAliases.put("SHA384", new String[]{"SHA-384"});
        digestAliases.put("SHA512", new String[]{"SHA-512"});
    }
}

