/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kz.gamma.hardware.asn1.ASN1EncodableVector;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1Object;
import kz.gamma.hardware.asn1.ASN1Set;
import kz.gamma.hardware.asn1.BERSet;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.cms.ContentInfo;
import kz.gamma.hardware.asn1.x509.CertificateList;
import kz.gamma.hardware.cms.CMSException;

class CMSUtils {
    private static final Runtime RUNTIME = Runtime.getRuntime();

    CMSUtils() {
    }

    static int getMaximumMemory() {
        long maxMem = RUNTIME.maxMemory();
        if (maxMem > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxMem;
    }

    static ContentInfo readContentInfo(byte[] input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static ContentInfo readContentInfo(InputStream input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input, CMSUtils.getMaximumMemory()));
    }

    static List getCertificatesFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            for (X509Certificate x509Certificate : certStore.getCertificates(null)) {
                certs.add(x509Certificate);
            }
            return certs;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getCRLsFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<CertificateList> crls = new ArrayList<CertificateList>();
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                crls.add(CertificateList.getInstance(ASN1Object.fromByteArray(x509CRL.getEncoded())));
            }
            return crls;
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("error processing crls", e);
        }
        catch (IOException e) {
            throw new CMSException("error processing crls", e);
        }
        catch (CRLException e) {
            throw new CMSException("error encoding crls", e);
        }
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        final ASN1EncodableVector v = new ASN1EncodableVector();
        final Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    X509Certificate obj = (X509Certificate)it.next();
                    try {
                        v.add(new ASN1InputStream(obj.getEncoded()).readObject());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CertificateEncodingException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        return new BERSet(v);
    }

    static ASN1Set createDerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((DEREncodable)it.next());
        }
        return new DERSet(v);
    }

    private static ContentInfo readContentInfo(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance(in.readObject());
        }
        catch (IOException e) {
            throw new CMSException("IOException reading content.", e);
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            bOut.write(ch);
        }
        return bOut.toByteArray();
    }
}

