/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.cms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import kz.gamma.hardware.asn1.ASN1InputStream;
import kz.gamma.hardware.asn1.ASN1OctetString;
import kz.gamma.hardware.asn1.ASN1Sequence;
import kz.gamma.hardware.asn1.BERConstructedOctetString;
import kz.gamma.hardware.asn1.BERSequence;
import kz.gamma.hardware.asn1.BERTaggedObject;
import kz.gamma.hardware.asn1.DERBitString;
import kz.gamma.hardware.asn1.DEREncodable;
import kz.gamma.hardware.asn1.DEREnumerated;
import kz.gamma.hardware.asn1.DERGeneralizedTime;
import kz.gamma.hardware.asn1.DERInteger;
import kz.gamma.hardware.asn1.DERObject;
import kz.gamma.hardware.asn1.DERObjectIdentifier;
import kz.gamma.hardware.asn1.DEROctetString;
import kz.gamma.hardware.asn1.DERPrintableString;
import kz.gamma.hardware.asn1.DERSequence;
import kz.gamma.hardware.asn1.DERSet;
import kz.gamma.hardware.asn1.DERTaggedObject;
import kz.gamma.hardware.asn1.cms.Attribute;
import kz.gamma.hardware.asn1.cms.AttributeTable;
import kz.gamma.hardware.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gamma.hardware.asn1.x509.SubjectPublicKeyInfo;
import kz.gamma.hardware.cms.CMSException;
import kz.gamma.hardware.cms.CMSSignedData;
import kz.gamma.hardware.cms.SignerInformation;
import kz.gamma.hardware.cms.SignerInformationStore;
import kz.gamma.hardware.crypto.RuntimeCryptoException;
import kz.gamma.hardware.crypto.software.SignatureVerifier;
import kz.gamma.hardware.jce.JCEMessageDigest;
import kz.gamma.hardware.util.Arrays;
import kz.gamma.hardware.util.EndiannessUtils;
import kz.gamma.hardware.util.UtilCM;

public class Pkcs7Data {
    private byte[] pkcs7 = null;
    private byte[] text = null;
    private File file = null;
    private final int DEFAULT_BUF_SIZE = 32768;
    private SignerInformation info = null;
    private CMSSignedData signedData = null;
    private boolean isExtractContent = false;
    private EndiannessUtils endiannessUtils = new EndiannessUtils();

    public Pkcs7Data(byte[] pkcs7, byte[] text) {
        this.pkcs7 = pkcs7;
        this.text = text;
        this.init();
    }

    public Pkcs7Data(byte[] pkcs7, String textString) {
        this.pkcs7 = pkcs7;
        this.text = textString.getBytes();
        this.init();
    }

    public Pkcs7Data(byte[] pkcs7) {
        this.pkcs7 = pkcs7;
        this.isExtractContent = true;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pkcs7Data(String fileName, byte[] text) {
        this.text = text;
        FileInputStream f = null;
        try {
            f = new FileInputStream(fileName);
            int size = f.available();
            this.pkcs7 = new byte[size];
            f.read(this.pkcs7, 0, size);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pkcs7Data(String fileName, String textString) {
        this.text = textString.getBytes();
        FileInputStream f = null;
        try {
            f = new FileInputStream(fileName);
            int size = f.available();
            this.pkcs7 = new byte[size];
            f.read(this.pkcs7, 0, size);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pkcs7Data(String fileName, File textFileName) {
        FileInputStream fis1 = null;
        try {
            fis1 = new FileInputStream(textFileName);
            int size = fis1.available();
            this.text = new byte[size];
            fis1.read(this.text, 0, size);
            if (this.text[0] == -1 && this.text[1] == -2) {
                this.text = UtilCM.copyByte(this.text, 2, size - 2);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        FileInputStream f = null;
        try {
            f = new FileInputStream(fileName);
            int size = f.available();
            this.pkcs7 = new byte[size];
            f.read(this.pkcs7, 0, size);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.init();
    }

    public Pkcs7Data(byte[] pkcs7, File file) {
        this.pkcs7 = pkcs7;
        this.file = file;
        this.init();
    }

    private void init() {
        try {
            this.signedData = new CMSSignedData(this.pkcs7);
            SignerInformationStore signers = this.signedData.getSignerInfos();
            Collection sinfo = signers.getSigners();
            Iterator itcert = sinfo.iterator();
            if (itcert.hasNext()) {
                this.info = (SignerInformation)itcert.next();
            }
            if (this.isExtractContent && this.signedData.getSignedContent() != null) {
                this.text = (byte[])this.signedData.getSignedContent().getContent();
            }
        }
        catch (CMSException e) {
            e.printStackTrace();
        }
    }

    public byte[] getSignedAttributesInBytes() {
        return this.info.getSignedAttributesByte();
    }

    public AttributeTable getSignedAttributes() {
        return this.info.getSignedAttributes();
    }

    public byte[] getSignature() {
        return this.info.getSignature();
    }

    public String getEncryptionAlgOID() {
        return this.info.getEncryptionAlgOID();
    }

    public CertStore getCertStore() {
        CertStore crt = null;
        try {
            crt = this.signedData.getCertificatesAndCRLs("Collection", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crt;
    }

    public byte[] getAttributeByOid(String oid) throws IOException {
        AttributeTable attributes = this.getSignedAttributes();
        Attribute at = attributes.get(new DERObjectIdentifier(oid));
        DEREncodable obj = at.getAttrValues().getObjectAt(0);
        return obj.getDERObject().getEncoded();
    }

    public X509Certificate getCertificateOfSigner() throws CMSException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException {
        SignerInformation signer;
        Collection<? extends Certificate> certificates;
        Iterator<? extends Certificate> i$;
        CertStore store = this.signedData.getCertificatesAndCRLs("Collection", null);
        SignerInformationStore sis = this.signedData.getSignerInfos();
        Collection signers = sis.getSigners();
        Iterator i$2 = signers.iterator();
        if (i$2.hasNext() && (i$ = (certificates = store.getCertificates((signer = (SignerInformation)i$2.next()).getSID())).iterator()).hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)i$.next();
            return x509Certificate;
        }
        throw new CertStoreException("PKCS#7 not have certificate of signer");
    }

    @Deprecated
    public boolean verifyOther() {
        throw new RuntimeException("Not implemented");
    }

    private int getType(Object obj) {
        int type = 0;
        try {
            if (obj instanceof DERSequence) {
                type = 1;
            } else if (obj instanceof DERObjectIdentifier) {
                type = 2;
            } else if (obj instanceof DEROctetString) {
                type = 3;
            } else if (obj instanceof DERGeneralizedTime) {
                type = 4;
            } else if (obj instanceof DERPrintableString) {
                type = 5;
            } else if (obj instanceof DEREnumerated) {
                type = 6;
            } else if (obj instanceof DERBitString) {
                type = 7;
            } else if (obj instanceof DERTaggedObject) {
                type = 8;
            } else if (obj instanceof DERInteger) {
                type = 9;
            } else if (obj instanceof DERSet) {
                type = 10;
            } else if (obj instanceof BERSequence) {
                type = 11;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    public void retrieveData() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEREncodable obj = this.signedData.contentInfo.getContent();
        int type = this.getType(obj);
        if (type == 1) {
            DERSequence ssq = (DERSequence)obj;
            DERSequence ssq1 = (DERSequence)ssq.getObjectAt(2);
            DERTaggedObject objc = (DERTaggedObject)ssq1.getObjectAt(1);
            DEROctetString oboct = (DEROctetString)objc.getObjectParser(4, false);
            byteArrayOutputStream.write(oboct.getOctets());
        } else if (type == 3) {
            byteArrayOutputStream.write(((DEROctetString)obj).getOctets());
        } else if (type == 11) {
            BERSequence ssq = (BERSequence)obj;
            BERSequence ssq1 = (BERSequence)ssq.getObjectAt(2);
            BERTaggedObject objc = (BERTaggedObject)ssq1.getObjectAt(1);
            BERConstructedOctetString conoct = (BERConstructedOctetString)objc.getObjectParser(4, false);
            Enumeration e123 = conoct.getObjects();
            while (e123.hasMoreElements()) {
                Object obj1 = e123.nextElement();
                if (!(obj1 instanceof DEROctetString)) continue;
                DEROctetString oboct = (DEROctetString)obj1;
                byteArrayOutputStream.write(oboct.getOctets());
            }
        } else {
            throw new Exception("Not supported format for the signed message");
        }
        this.text = byteArrayOutputStream.toByteArray();
    }

    public byte[] getData() throws Exception {
        return this.text;
    }

    public boolean verify() {
        return this.verify(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(X509Certificate x509Certificate) {
        try {
            CertStore store = this.signedData.getCertificatesAndCRLs("Collection", null);
            SignerInformationStore sis = this.signedData.getSignerInfos();
            Collection signers = sis.getSigners();
            X509Certificate certificate = null;
            for (SignerInformation signer : signers) {
                Attribute attribute;
                if (x509Certificate == null) {
                    Collection<? extends Certificate> certificates = store.getCertificates(signer.getSID());
                    Iterator<? extends Certificate> itr = certificates.iterator();
                    if (itr.hasNext()) {
                        certificate = (X509Certificate)itr.next();
                    }
                } else {
                    certificate = x509Certificate;
                }
                if (certificate == null) {
                    throw new RuntimeCryptoException("Cannot verify signature without certificate");
                }
                AttributeTable attributeTable = this.info.getSignedAttributes();
                byte[] hashFromPkcs = null;
                if (attributeTable != null && (attribute = attributeTable.get(new DERObjectIdentifier("1.2.840.113549.1.9.4"))) != null) {
                    Enumeration e = attribute.getAttrValues().getObjects();
                    while (e.hasMoreElements()) {
                        DERObject o = (DERObject)e.nextElement();
                        ASN1InputStream aIn = new ASN1InputStream(o.getEncoded());
                        ASN1OctetString key = (ASN1OctetString)aIn.readObject();
                        hashFromPkcs = key.getOctets();
                    }
                }
                String signatureAlg = null;
                SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(certificate.getPublicKey().getEncoded()).readObject());
                MessageDigest messageDigest = null;
                byte[] signedHash = null;
                byte[] hashToData = null;
                byte[] pKey = null;
                if (this.info.getEncryptionAlgOID().equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                    pKey = publicKeyInfo.getDEREncoded();
                    signatureAlg = "rsa";
                    messageDigest = MessageDigest.getInstance("SHA1");
                } else {
                    byte[] publicKeyData = publicKeyInfo.getPublicKeyData().getBytes();
                    int publicKeyLength = 64;
                    int publicKeyOffset = publicKeyData.length - publicKeyLength;
                    signatureAlg = "gost";
                    messageDigest = JCEMessageDigest.getInstance("");
                    pKey = UtilCM.reverseParts(publicKeyData, publicKeyOffset);
                }
                SignatureVerifier signatureVerifier = SignatureVerifier.getInstance(signatureAlg);
                messageDigest.reset();
                if (this.file != null) {
                    FileInputStream fileInputStream = null;
                    try {
                        byte[] buf = new byte[32768];
                        fileInputStream = new FileInputStream(this.file);
                        int len = 0;
                        while ((len = fileInputStream.read(buf, 0, buf.length)) > 0) {
                            messageDigest.update(buf, 0, len);
                        }
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (this.text != null) {
                    messageDigest.update(this.text, 0, this.text.length);
                } else {
                    throw new RuntimeCryptoException("Cannot find file or text");
                }
                hashToData = messageDigest.digest();
                messageDigest.reset();
                byte[] sigAttr = this.info.getSignedAttributesByte();
                if (sigAttr != null) {
                    messageDigest.update(sigAttr, 0, sigAttr.length);
                    signedHash = messageDigest.digest();
                } else {
                    signedHash = hashToData;
                }
                if (this.info.getEncryptionAlgOID().equals(PKCSObjectIdentifiers.rsaEncryption.getId()) ? !signatureVerifier.verify(pKey, signedHash, this.info.getSignature()) : !signatureVerifier.verify(pKey, UtilCM.inverseCopyByte(signedHash, 0, 32), this.info.getSignature()) && !signatureVerifier.verify(pKey, UtilCM.inverseCopyByte(signedHash, 0, 32), UtilCM.reverseParts(this.info.getSignature(), 0))) {
                    return false;
                }
                if (hashFromPkcs == null || this.verifyHashes(signatureAlg, hashToData, hashFromPkcs)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean verifyHashes(String signatureAlg, byte[] hash, byte[] hashFromPkcs) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        boolean result = Arrays.areEqual(hash, hashFromPkcs);
        if (!result && !(result = Arrays.areEqual(hash = UtilCM.inverseCopyByte(hash, 0, hash.length), hashFromPkcs)) && this.text != null) {
            String stringCp1251 = new String(this.text, "Cp1251");
            byte[] unicode = stringCp1251.getBytes("Unicode");
            byte[] unicodeWithoutBOM = null;
            try {
                ByteOrder byteOrder = this.endiannessUtils.getEndianness(unicode);
                if (byteOrder.equals(ByteOrder.BIG_ENDIAN) || byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) {
                    unicodeWithoutBOM = new byte[unicode.length - 2];
                    System.arraycopy(unicode, 2, unicodeWithoutBOM, 0, unicodeWithoutBOM.length);
                }
            }
            catch (RuntimeException re) {
                unicodeWithoutBOM = unicode;
            }
            byte[] resultBytes = this.endiannessUtils.changeEndianness(unicodeWithoutBOM);
            MessageDigest digest = null;
            if (signatureAlg.equals("gost")) {
                digest = JCEMessageDigest.getInstance("");
            } else if (signatureAlg.equals("rsa")) {
                digest = MessageDigest.getInstance("SHA1");
            }
            digest.reset();
            digest.update(resultBytes, 0, resultBytes.length);
            byte[] hashToData = digest.digest();
            result = Arrays.areEqual(hashToData, hashFromPkcs);
        }
        return result;
    }

    public SignerInformation getSignerInformation() {
        return this.info;
    }
}

