/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.core.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileHelper {
    private JFileChooser chooser = new JFileChooser();

    public FileHelper() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this.chooser);
        }
        catch (Exception e) {
            System.out.println("Cannot set system look and feel");
        }
    }

    public Boolean createFile(final String path) throws Exception {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File defaultDir = new File(path);
                Boolean isDirectory = defaultDir.isDirectory();
                Boolean isExists = defaultDir.exists();
                if (!isExists.booleanValue()) {
                    Stack<File> toCreate = new Stack<File>();
                    toCreate.add(defaultDir);
                    File file = defaultDir;
                    while (!(file = file.getParentFile()).exists()) {
                        toCreate.add(file);
                    }
                    while (!toCreate.isEmpty()) {
                        file = (File)toCreate.pop();
                        file.mkdir();
                    }
                    isExists = defaultDir.exists();
                } else if (isExists.booleanValue() && !isDirectory.booleanValue()) {
                    throw new RuntimeException("File \"" + path + "\" is exists and not a directory");
                }
                return isExists;
            }
        });
        return result;
    }

    public String getUserHomePath() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        return path;
    }

    public String getDefaultKeysPath() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home") + File.separator + "TumarCSP";
            }
        });
        return path;
    }

    public void saveData(final byte[] dataToSave, final String fileName) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileOutputStream fos = null;
                ByteArrayOutputStream bous = null;
                try {
                    File file = new File(fileName);
                    FileHelper.this.createFile(file.getParent());
                    fos = new FileOutputStream(fileName);
                    bous = new ByteArrayOutputStream();
                    bous.write(dataToSave);
                    bous.writeTo(fos);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (bous != null) {
                        try {
                            bous.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return null;
            }
        });
    }

    public String saveResource(final String resourcePackage, final String resourceName) {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    int bytesRead;
                    is = this.getClass().getResourceAsStream(resourcePackage + resourceName);
                    if (is == null) {
                        throw new RuntimeException(String.format("Cannot get resource \"%s%s\" as stream", resourcePackage, resourceName));
                    }
                    File file = new File(System.getProperty("java.io.tmpdir") + "/" + resourceName);
                    System.out.println("Trying to save dll to: " + file.getAbsolutePath());
                    FileHelper.this.createFile(file.getParent());
                    fos = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    String string = file.toString();
                    return string;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        return path;
    }

    public String readResource(final String resourcePackage, final String resourceName) {
        String content = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                InputStream is = null;
                ByteArrayOutputStream baos = null;
                try {
                    int bytesRead;
                    is = this.getClass().getResourceAsStream(resourcePackage + resourceName);
                    if (is == null) {
                        throw new RuntimeException(String.format("Cannot get resource \"%s%s\" as stream", resourcePackage, resourceName));
                    }
                    baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    baos.flush();
                    String string = new String(baos.toByteArray());
                    return string;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        return content;
    }

    public byte[] loadData(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileName);
                    int size = fis.available();
                    byte[] result = new byte[size];
                    fis.read(result, 0, size);
                    byte[] byArray = result;
                    return byArray;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public int getFileSize(String fileName) {
        final String fileNameLocal = fileName;
        Number size = AccessController.doPrivileged(new PrivilegedAction<Number>(){

            @Override
            public Number run() {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileNameLocal);
                    Integer n = fis.available();
                    return n;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        return size.intValue();
    }

    public Boolean isFileExists(final String path) throws Exception {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File(path);
                return file.exists();
            }
        });
        return result;
    }

    public boolean deleteData(final String path) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File(path);
                if (file.exists() && file.isDirectory()) {
                    File[] files;
                    for (File localFile : files = file.listFiles()) {
                        if (localFile.isDirectory()) {
                            FileHelper.this.deleteData(localFile.getAbsolutePath());
                            continue;
                        }
                        localFile.delete();
                    }
                }
                return file.delete();
            }
        });
    }

    public List<File> find(String startPath, String fileName, String fileExt) {
        if (startPath == null || startPath.trim().equals("")) {
            throw new RuntimeException("You must set start path");
        }
        if (fileName == null || fileName.trim().equals("")) {
            throw new RuntimeException("You must set file name");
        }
        if (fileExt == null || fileExt.trim().equals("")) {
            throw new RuntimeException("You must set file extension");
        }
        File topDirectory = new File(startPath);
        if (!topDirectory.exists()) {
            throw new RuntimeException("Start path directory is not exist");
        }
        LinkedList<File> resultList = new LinkedList<File>();
        this.search(topDirectory, resultList, fileName, fileExt);
        return resultList;
    }

    private void search(File startDirectory, List<File> resultList, String fileName, String fileExt) {
        File[] filesArray;
        for (File file : filesArray = startDirectory.listFiles()) {
            if (file.isDirectory()) {
                this.search(file, resultList, fileName, fileExt);
                continue;
            }
            if (!file.getName().matches(fileName + "." + fileExt)) continue;
            resultList.add(file);
        }
    }

    public String createDialog(List extensions, String description, Integer type) {
        return this.createDialog(extensions, description, type, 0);
    }

    public String createDialog(List extensions, String description, final Integer type, Integer selectionMode) {
        if (type == null) {
            throw new NullPointerException("parameter type must not be null");
        }
        final List extensionsLocal = extensions;
        final String descriptionLocal = description;
        final Integer typeLocal = type;
        final Integer selectionModeLocal = selectionMode;
        if (selectionMode == 2) {
            throw new RuntimeException("You cannot use JFileChooser.FILES_AND_DIRECTORIES");
        }
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String filePath = null;
                FileHelper.this.chooser.setFileSelectionMode(selectionModeLocal);
                if (extensionsLocal != null && extensionsLocal.size() != 0) {
                    String[] extArray = new String[extensionsLocal.size()];
                    boolean useFilter = true;
                    for (int i = 0; i < extensionsLocal.size(); ++i) {
                        extArray[i] = (String)extensionsLocal.get(i);
                        if (!extArray[i].equals("*")) continue;
                        useFilter = false;
                    }
                    if (useFilter) {
                        FileNameExtensionFilter filter = new FileNameExtensionFilter(descriptionLocal, extArray);
                        FileHelper.this.chooser.setFileFilter(filter);
                        FileHelper.this.chooser.setAcceptAllFileFilterUsed(false);
                    }
                }
                FileHelper.this.chooser.setDialogType(typeLocal);
                String approveButtonText = "Select";
                if (selectionModeLocal == 1) {
                    approveButtonText = "Select";
                } else {
                    switch (typeLocal) {
                        case 0: {
                            approveButtonText = "Open";
                            break;
                        }
                        case 1: {
                            approveButtonText = "Save";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal type: " + type);
                        }
                    }
                }
                int result = FileHelper.this.chooser.showDialog(null, approveButtonText);
                if (result == 0) {
                    File selectedFile = FileHelper.this.chooser.getSelectedFile();
                    switch (typeLocal) {
                        case 0: {
                            if (selectedFile.isFile() || selectionModeLocal == 1) break;
                            throw new RuntimeException("Selected object is not a file");
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal type: " + type);
                        }
                    }
                    try {
                        filePath = selectedFile.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    filePath = "";
                }
                return filePath;
            }
        });
        return path;
    }
}

