/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import kz.gamma.hardware.crypto.params.DeviceParameter;
import kz.gamma.hardware.jce.CryptoObject;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.jce.param.PKCS11Param;
import kz.gamma.hardware.jce.param.PcscParam;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;

public class DeviceList {
    private static byte[] ALADDIN_JACARTA_APPLET = new byte[]{0, -92, 4, 0, 10, -96, 0, 0, 4, 72, 1, 1, 1, 6, 2, 0};
    private static byte[] GAMMA_JACARTA_APPLET = new byte[]{0, -92, 4, 0, 12, -96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 0};
    private static byte[] GAMMA_JAVA_TOKEN_APPLET = new byte[]{0, -92, 4, 0, 10, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0};
    private static byte[] KZ_TOKEN_STATUS = new byte[]{0, -54, 1, -119, 38};
    private static byte[] KZ_TOKEN_SERIAL = new byte[]{0, -54, 1, -127, -1};

    private static boolean isAppletLoaded(CardChannel ch, byte[] applet) {
        boolean ret = false;
        ResponseAPDU respApdu = null;
        CommandAPDU capdu = null;
        try {
            capdu = new CommandAPDU(applet);
            respApdu = ch.transmit(capdu);
            if (respApdu.getSW() == 36864) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static boolean isKzToken(CardChannel ch) {
        try {
            CommandAPDU capdu = new CommandAPDU(KZ_TOKEN_STATUS);
            ResponseAPDU respApdu = ch.transmit(capdu);
            if (respApdu.getSW() != 36864) {
                return false;
            }
            capdu = new CommandAPDU(KZ_TOKEN_SERIAL);
            respApdu = ch.transmit(capdu);
            return respApdu.getSW() == 36864;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void checkDevice(String libName, DeviceParameter deviceParameter, String deviceName, boolean isGost) {
        try {
            long[] slotList;
            PKCS11 pkcs11;
            Method getInstanceMethode;
            String javaVersion = System.getProperty("java.version");
            Class<?> pkcs11Class = Class.forName("sun.security.pkcs11.wrapper.PKCS11");
            if (javaVersion.startsWith("1.5.")) {
                getInstanceMethode = pkcs11Class.getDeclaredMethod("getInstance", String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                pkcs11 = (PKCS11)getInstanceMethode.invoke(null, libName, null, false);
            } else {
                getInstanceMethode = pkcs11Class.getDeclaredMethod("getInstance", String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                pkcs11 = (PKCS11)getInstanceMethode.invoke(null, libName, "C_GetFunctionList", null, false);
            }
            for (long slot : slotList = pkcs11.C_GetSlotList(false)) {
                CK_SLOT_INFO ckSlotInfo = pkcs11.C_GetSlotInfo(slot);
                if (!new String(ckSlotInfo.slotDescription).contains(deviceParameter.getReaderName()) || (ckSlotInfo.flags & 1L) == 0L) continue;
                try {
                    CK_TOKEN_INFO ckTokenInfo = pkcs11.C_GetTokenInfo(slot);
                    if (isGost) {
                        deviceParameter.setGost(true);
                        deviceParameter.setGostDeviceName(deviceName);
                        break;
                    }
                    deviceParameter.setRsa(true);
                    deviceParameter.setRsaDeviceName(deviceName);
                }
                catch (Throwable t) {
                    System.err.println("Checking device '" + deviceName + "' with reader '" + deviceParameter.getReaderName() + "' and library '" + libName + "'. Error: " + t.getMessage());
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DeviceParameter> listOfDevices(String algorithm) {
        boolean isGostAlgorithm = false;
        boolean isRsaAlgorithm = false;
        if (algorithm == null || algorithm.trim().length() == 0) {
            isGostAlgorithm = true;
            isRsaAlgorithm = true;
        } else {
            if (!algorithm.equals("gost") && !algorithm.equals("rsa")) {
                throw new JCEHardwareException("Unknown algorithm: " + algorithm);
            }
            isGostAlgorithm = algorithm.equals("gost");
            isRsaAlgorithm = algorithm.equals("rsa");
        }
        LinkedList<DeviceParameter> deviceParameters = new LinkedList<DeviceParameter>();
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> cardTerminals = factory.terminals().list();
            for (CardTerminal cardTerminal : cardTerminals) {
                DeviceParameter deviceParameter;
                block34: {
                    CardTerminal terminal = cardTerminal;
                    if (!terminal.isCardPresent()) continue;
                    deviceParameter = new DeviceParameter();
                    deviceParameter.setReaderName(terminal.getName());
                    Card sc = terminal.connect("*");
                    CardChannel ch = null;
                    try {
                        CryptoObject cryptoObject;
                        ch = sc.getBasicChannel();
                        String implementationTitle = DeviceList.class.getPackage().getImplementationTitle();
                        boolean iterateAllCases = true;
                        if (implementationTitle != null && implementationTitle.equals("crypto-hardware.jar for NIT")) {
                            iterateAllCases = false;
                        }
                        if (isGostAlgorithm) {
                            String gostLibName;
                            if (DeviceList.isAppletLoaded(ch, GAMMA_JACARTA_APPLET)) {
                                deviceParameter.setGost(true);
                                deviceParameter.setGostDeviceName("GammaJaCarta");
                            } else if (DeviceList.isAppletLoaded(ch, GAMMA_JAVA_TOKEN_APPLET)) {
                                deviceParameter.setGost(true);
                                deviceParameter.setGostDeviceName("JavaToken");
                            } else if (DeviceList.isAppletLoaded(ch, ALADDIN_JACARTA_APPLET) && iterateAllCases) {
                                deviceParameter.setGost(true);
                                deviceParameter.setGostDeviceName("AladdinJaCarta");
                            } else if (!deviceParameter.isGost() && iterateAllCases) {
                                gostLibName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
                                DeviceList.checkDevice(gostLibName, deviceParameter, "JaCartaToken", true);
                            } else if (!deviceParameter.isGost() && iterateAllCases) {
                                gostLibName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
                                DeviceList.checkDevice(gostLibName, deviceParameter, "SafeNetToken", true);
                            } else if (!deviceParameter.isGost() && iterateAllCases) {
                                gostLibName = PKCS11Param.RUTOKEN_PKCS11_LIB_GOST_NAME;
                                DeviceList.checkDevice(gostLibName, deviceParameter, "RuToken", true);
                            } else if (!deviceParameter.isGost() && DeviceList.isKzToken(ch)) {
                                deviceParameter.setGost(true);
                                deviceParameter.setGostDeviceName("KzToken");
                                cryptoObject = CryptoObject.getInstance("KzToken", "gost");
                                cryptoObject.init(new PcscParam(deviceParameter.getReaderName()));
                            }
                        }
                        if (!isRsaAlgorithm || !iterateAllCases) break block34;
                        String rsaLibName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
                        DeviceList.checkDevice(rsaLibName, deviceParameter, "JaCarta", false);
                        if (!deviceParameter.isRsa()) {
                            rsaLibName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
                            DeviceList.checkDevice(rsaLibName, deviceParameter, "JavaToken", false);
                        }
                        if (!deviceParameter.isRsa()) {
                            rsaLibName = PKCS11Param.RUTOKEN_PKCS11_LIB_RSA_NAME;
                            DeviceList.checkDevice(rsaLibName, deviceParameter, "RuToken", false);
                        }
                        if (deviceParameter.isRsa()) break block34;
                        rsaLibName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
                        DeviceList.checkDevice(rsaLibName, deviceParameter, "KzToken", false);
                        cryptoObject = CryptoObject.getInstance("KzToken", "rsa");
                        cryptoObject.init(new PKCS11Param(deviceParameter.getReaderName(), deviceParameter.getLibraryName("rsa"), "rsa"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        try {
                            ch.getCard().disconnect(false);
                        }
                        catch (CardException e) {
                            System.err.println("error on disconnect reader '" + deviceParameter.getReaderName() + "': " + e.getMessage());
                        }
                        continue;
                    }
                }
                deviceParameters.add(deviceParameter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return deviceParameters;
        }
        return deviceParameters;
    }
}

