/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.params;

import kz.gamma.hardware.jce.param.PKCS11Param;

public class DeviceParameter {
    private String readerName;
    private boolean isGost = false;
    private String gostDeviceName;
    private boolean isRsa = false;
    private String rsaDeviceName;

    public String getReaderName() {
        return this.readerName;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    public boolean isGost() {
        return this.isGost;
    }

    public void setGost(boolean gost) {
        this.isGost = gost;
    }

    public String getGostDeviceName() {
        return this.gostDeviceName;
    }

    public void setGostDeviceName(String gostDeviceName) {
        this.gostDeviceName = gostDeviceName;
    }

    public boolean isRsa() {
        return this.isRsa;
    }

    public void setRsa(boolean rsa) {
        this.isRsa = rsa;
    }

    public String getRsaDeviceName() {
        return this.rsaDeviceName;
    }

    public void setRsaDeviceName(String rsaDeviceName) {
        this.rsaDeviceName = rsaDeviceName;
    }

    public boolean isHaveDevice(String algorithm) {
        if (algorithm.equals("gost") && this.isGost) {
            return true;
        }
        return algorithm.equals("rsa") && this.isRsa;
    }

    public String getLibraryName() {
        String libraryName = null;
        if (this.isRsa) {
            if (this.rsaDeviceName.equals("JaCarta")) {
                libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
            } else if (this.rsaDeviceName.equals("JavaToken")) {
                libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
            } else if (this.rsaDeviceName.equals("RuToken")) {
                libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_RSA_NAME;
            } else if (this.rsaDeviceName.equals("KzToken")) {
                libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
            }
        } else if (this.gostDeviceName.equals("JaCartaToken")) {
            libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
        } else if (this.gostDeviceName.equals("SafeNetToken")) {
            libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
        } else if (this.gostDeviceName.equals("RuToken")) {
            libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_GOST_NAME;
        } else if (this.gostDeviceName.equals("KzToken")) {
            libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
        }
        return libraryName;
    }

    public String getLibraryName(String alg) {
        String libraryName = null;
        if (alg.equals("rsa")) {
            if (this.rsaDeviceName.equals("JaCarta")) {
                libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
            } else if (this.rsaDeviceName.equals("JavaToken")) {
                libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
            } else if (this.rsaDeviceName.equals("RuToken")) {
                libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_RSA_NAME;
            } else if (this.rsaDeviceName.equals("KzToken")) {
                libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
            }
        } else if (this.gostDeviceName.equals("JaCartaToken")) {
            libraryName = PKCS11Param.JACARTA_PKCS11_LIB_NAME;
        } else if (this.gostDeviceName.equals("SafeNetToken")) {
            libraryName = PKCS11Param.JAVATOKEN_PKCS11_LIB_NAME;
        } else if (this.gostDeviceName.equals("RuToken")) {
            libraryName = PKCS11Param.RUTOKEN_PKCS11_LIB_GOST_NAME;
        } else if (this.gostDeviceName.equals("KzToken")) {
            libraryName = PKCS11Param.KZTOKEN_PKCS11_LIB_NAME;
        }
        return libraryName;
    }
}

