/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pcsc.jacarta.gamma;

import java.util.Enumeration;
import java.util.LinkedList;
import javax.smartcardio.CardException;
import kz.gamma.hardware.crypto.pcsc.PcscGammaObject;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;
import kz.gamma.hardware.crypto.pcsc.jacarta.gamma.GammaJaCartaPrivateKey;
import kz.gamma.hardware.crypto.pcsc.jacarta.gamma.GammaJaCartaPublicKey;
import kz.gamma.hardware.crypto.pcsc.jacarta.gamma.TokenGammaJaCarta;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.jce.param.CryptoParam;
import kz.gamma.hardware.jce.param.PcscParam;
import kz.gamma.hardware.util.DataConverter;
import kz.gamma.hardware.util.UtilCM;

public class GammaJaCartaGammaObject
extends PcscGammaObject {
    private TokenGammaJaCarta tokenGammaJaCarta = null;
    private byte[] license = new byte[]{0, 0, 0, 0, 0};
    private boolean licState = true;

    @Override
    public void init(CryptoParam param) {
        try {
            if (!(param instanceof PcscParam)) {
                throw new PcscException("Wrong parameter type");
            }
            this.param = (PcscParam)param;
            this.tokenGammaJaCarta = new TokenGammaJaCarta(this.param.getReaderName());
            this.responceCard = this.tokenGammaJaCarta.selectApplet();
            if (this.responceCard.getRetCode() != 36864) {
                throw new PcscException("Gamma applet not available");
            }
            this.tokenGammaJaCarta.resetCard();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        catch (PcscException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public JCEKeyPair createKey(int algType, String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: createKey.\n", "GammaJaCarta");
        byte keyAlgID = 1;
        JCEKeyPair ret = null;
        try {
            if (algType == 1) {
                keyAlgID = 1;
            } else if (algType == 2) {
                keyAlgID = 4;
            } else {
                throw new IllegalArgumentException("Unknown algorithm type: " + algType);
            }
            this.responceCard = this.tokenGammaJaCarta.createKey(name, keyAlgID);
            if (this.responceCard.getRetCode() == 25620) {
                this.responceCard = this.tokenGammaJaCarta.verifyPin(pass);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJaCarta.createKey(name, keyAlgID);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = new JCEKeyPair(new GammaJaCartaPrivateKey(name, pass, keyAlgID), new GammaJaCartaPublicKey(name, this.responceCard.getData()));
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public byte[] signature(JCEPrivateKey privateKey, byte[] data) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: signature.\n", "GammaJaCarta");
        byte[] ret = null;
        try {
            this.responceCard = this.tokenGammaJaCarta.signature(privateKey.getName(), data);
            if (this.responceCard.getRetCode() == 25620) {
                this.responceCard = this.tokenGammaJaCarta.verifyPin(privateKey.getPass());
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJaCarta.signature(privateKey.getName(), data);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = this.responceCard.getData();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public Enumeration<JCEKeyPair> getKeyList(String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: getKeyList.\n", "GammaJaCarta");
        LinkedList<JCEKeyPair> ret = new LinkedList<JCEKeyPair>();
        try {
            this.responceCard = this.tokenGammaJaCarta.getObjectCount();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            int count = UtilCM.byteToShort(this.responceCard.getData(), 0, 1);
            for (int i = 0; i < count; ++i) {
                this.responceCard = this.tokenGammaJaCarta.getObjectName((short)i);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                int sizeWithoutNulls = DataConverter.getSizeWithoutNulls(this.responceCard.getData(), 0);
                String name = new String(UtilCM.copyByte(this.responceCard.getData(), 0, sizeWithoutNulls));
                if (!this.tokenGammaJaCarta.isObjectExists(name, (short)0)) continue;
                JCEKeyPair keyPair = new JCEKeyPair();
                this.responceCard = this.tokenGammaJaCarta.getKeyAlgID(name);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                byte keyAlgID = this.responceCard.getData()[0];
                byte algType = 0;
                if (keyAlgID == 1) {
                    algType = 1;
                } else {
                    if (keyAlgID != 4) continue;
                    algType = 2;
                }
                keyPair.setPrivateKey(new GammaJaCartaPrivateKey(name, pass, algType));
                this.responceCard = this.tokenGammaJaCarta.getPublicKey(name);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                keyPair.setPublicKey(new GammaJaCartaPublicKey(name, this.responceCard.getData()));
                if (this.tokenGammaJaCarta.isObjectExists(name, (short)2)) {
                    this.responceCard = this.tokenGammaJaCarta.getCertificate(name);
                    if (this.responceCard.getRetCode() != 36864) {
                        throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                    }
                    keyPair.setCertBlob(this.responceCard.getData());
                }
                ret.add(keyPair);
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return UtilCM.makeEnumeration(ret.toArray());
    }

    @Override
    public void setCertificate(byte[] cert, JCEPrivateKey key) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: setCertificate.\n", "GammaJaCarta");
        try {
            GammaJaCartaPrivateKey privateKey = (GammaJaCartaPrivateKey)key;
            this.responceCard = this.tokenGammaJaCarta.setCertificate(privateKey.getName(), cert);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public void deleteKey(String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: deleteKey.\n", "GammaJaCarta");
        try {
            this.responceCard = this.tokenGammaJaCarta.deleteObject(name);
            if (this.responceCard.getRetCode() == 25620) {
                this.responceCard = this.tokenGammaJaCarta.verifyPin(pass);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJaCarta.deleteObject(name);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkPassword(String pass) {
        boolean retCode;
        block3: {
            retCode = true;
            try {
                this.responceCard = this.tokenGammaJaCarta.verifyPin(pass);
                if (this.responceCard.getRetCode() == 36864) break block3;
                if (this.responceCard.getRetCode() == 25620) {
                    retCode = false;
                    break block3;
                }
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            catch (CardException e) {
                throw new JCEHardwareException(e);
            }
        }
        return retCode;
    }

    @Override
    public void changePassword(String oldPass, String newPass) {
        try {
            this.responceCard = this.tokenGammaJaCarta.changePin(oldPass, newPass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkLicense() {
        return this.licState;
    }

    @Override
    public int getFreeMemorySize() {
        short size = 0;
        try {
            this.responceCard = this.tokenGammaJaCarta.getStatus();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            size = UtilCM.byteToShort(this.responceCard.getData(), 3, 1);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return size;
    }

    @Override
    public String getSerialNumber() {
        try {
            this.responceCard = this.tokenGammaJaCarta.getStatus();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            return UtilCM.array2hex(this.responceCard.getData(), 9, 8);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public byte[] makeDH(JCEPrivateKey privateKey, byte[] publicKey, byte[] ukm) {
        try {
            this.responceCard = this.tokenGammaJaCarta.makeDH(privateKey.getName(), publicKey, ukm);
            if (this.responceCard.getRetCode() == 25620) {
                this.responceCard = this.tokenGammaJaCarta.verifyPin(privateKey.getPass());
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJaCarta.makeDH(privateKey.getName(), publicKey, ukm);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            return this.responceCard.getData();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }
}

