/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pcsc.jacarta.license;

import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import kz.gamma.hardware.crypto.pcsc.ResponceCard;

public class LicenseJaCarta {
    private static final byte CLA = -128;
    private static final byte LIC_OPERATION = 32;
    private static final byte P1_GET_VENDOR_ID = 0;
    private static final byte P1_GET_LICENSE_ID = 16;
    private static final byte P1_GET_LICENSE = 32;
    private ResponseAPDU respApdu = null;
    private CommandAPDU capdu = null;
    private CardChannel ch = null;
    private String atr;
    private byte[] GAMMA_VENDOR_ID = new byte[]{0, 8};
    private byte[] GAMMA_PRODUCT_ID = new byte[]{0, 1};

    public LicenseJaCarta(CardChannel ch) throws CardException {
        this.ch = ch;
    }

    public boolean checkLicense(byte[] lic) {
        return true;
    }

    public ResponceCard readApplet() throws CardException {
        byte[] selectApplet = new byte[]{0, -92, 4, 0, 10, -96, 0, 0, 4, 72, 3, 1, 1, 1, 2};
        this.capdu = new CommandAPDU(selectApplet);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getVendorID() throws CardException {
        byte[] apdu = new byte[]{-128, 32, 0, 0, 0};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getLicenseID(byte[] vendorID, int offset) throws CardException {
        byte[] apdu = new byte[]{-128, 32, 16, 0, 2, vendorID[offset], vendorID[offset + 1]};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public ResponceCard getLicense(byte[] vendorID, int offsetV, byte[] licenseID, int offsetL) throws CardException {
        byte[] apdu = new byte[]{-128, 32, 32, 0, 4, vendorID[offsetV], vendorID[offsetV + 1], licenseID[offsetL], licenseID[offsetL + 1]};
        this.capdu = new CommandAPDU(apdu);
        this.respApdu = this.ch.transmit(this.capdu);
        return new ResponceCard(this.respApdu.getSW());
    }

    public void disconnect() throws CardException {
        this.ch.getCard().disconnect(false);
    }
}

