/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pcsc.javatoken.gamma;

import java.util.Enumeration;
import java.util.LinkedList;
import javax.smartcardio.CardException;
import kz.gamma.hardware.crypto.pcsc.PcscGammaObject;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;
import kz.gamma.hardware.crypto.pcsc.javatoken.gamma.GammaJavaTokenPrivateKey;
import kz.gamma.hardware.crypto.pcsc.javatoken.gamma.GammaJavaTokenPublicKey;
import kz.gamma.hardware.crypto.pcsc.javatoken.gamma.TokenGammaJavaToken;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.jce.param.CryptoParam;
import kz.gamma.hardware.jce.param.PcscParam;
import kz.gamma.hardware.util.DataConverter;
import kz.gamma.hardware.util.UtilCM;

public class GammaJavaTokenGammaObject
extends PcscGammaObject {
    private TokenGammaJavaToken tokenGammaJavaToken;
    private static final int ERROR_OFFSET = 34304;

    @Override
    public void init(CryptoParam param) {
        try {
            if (!(param instanceof PcscParam)) {
                throw new PcscException("Wrong parameter type");
            }
            this.param = (PcscParam)param;
            this.tokenGammaJavaToken = new TokenGammaJavaToken(this.param.getReaderName());
            this.responceCard = this.tokenGammaJavaToken.selectApplet();
            if (this.responceCard.getRetCode() != 36864) {
                throw new PcscException("Gamma applet not available");
            }
            this.tokenGammaJavaToken.resetCard();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        catch (PcscException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public JCEKeyPair createKey(int algType, String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: createKey.\n", "JavaToken");
        byte keyAlgID = 1;
        JCEKeyPair ret = null;
        try {
            if (algType == 1) {
                keyAlgID = 1;
            } else if (algType == 2) {
                keyAlgID = 4;
            } else {
                throw new IllegalArgumentException("Unknown algorithm type: " + algType);
            }
            this.responceCard = this.tokenGammaJavaToken.createKey(name, keyAlgID);
            if (this.responceCard.getRetCode() == 25620 || this.responceCard.getRetCode() - 34304 == 25620) {
                this.responceCard = this.tokenGammaJavaToken.verifyPin(pass);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJavaToken.createKey(name, keyAlgID);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = new JCEKeyPair(new GammaJavaTokenPrivateKey(name, pass, keyAlgID), new GammaJavaTokenPublicKey(name, this.responceCard.getData()));
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public byte[] signature(JCEPrivateKey privateKey, byte[] data) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: signature.\n", "JavaToken");
        byte[] ret = null;
        try {
            this.responceCard = this.tokenGammaJavaToken.signature(privateKey.getName(), data);
            if (this.responceCard.getRetCode() == 25620 || this.responceCard.getRetCode() - 34304 == 25620) {
                this.responceCard = this.tokenGammaJavaToken.verifyPin(privateKey.getPass());
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJavaToken.signature(privateKey.getName(), data);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = this.responceCard.getData();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public Enumeration<JCEKeyPair> getKeyList(String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: getKeyList.\n", "JavaToken");
        LinkedList<JCEKeyPair> ret = new LinkedList<JCEKeyPair>();
        try {
            this.responceCard = this.tokenGammaJavaToken.getObjectCount();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            int count = UtilCM.byteToShort(this.responceCard.getData(), 0, 1);
            for (int i = 0; i < count; ++i) {
                this.responceCard = this.tokenGammaJavaToken.getObjectName((short)i);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                int sizeWithoutNulls = DataConverter.getSizeWithoutNulls(this.responceCard.getData(), 0);
                String name = new String(UtilCM.copyByte(this.responceCard.getData(), 0, sizeWithoutNulls));
                if (!this.tokenGammaJavaToken.isObjectExists(name, (short)0)) continue;
                JCEKeyPair keyPair = new JCEKeyPair();
                this.responceCard = this.tokenGammaJavaToken.getKeyAlgID(name);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                byte keyAlgID = this.responceCard.getData()[0];
                byte algType = 0;
                if (keyAlgID == 1) {
                    algType = 1;
                } else {
                    if (keyAlgID != 4) continue;
                    algType = 2;
                }
                keyPair.setPrivateKey(new GammaJavaTokenPrivateKey(name, pass, algType));
                this.responceCard = this.tokenGammaJavaToken.getPublicKey(name);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                keyPair.setPublicKey(new GammaJavaTokenPublicKey(name, this.responceCard.getData()));
                if (this.tokenGammaJavaToken.isObjectExists(name, (short)2)) {
                    this.responceCard = this.tokenGammaJavaToken.getCertificate(name);
                    if (this.responceCard.getRetCode() != 36864) {
                        throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                    }
                    keyPair.setCertBlob(this.responceCard.getData());
                }
                ret.add(keyPair);
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return UtilCM.makeEnumeration(ret.toArray());
    }

    @Override
    public void setCertificate(byte[] cert, JCEPrivateKey key) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: setCertificate.\n", "JavaToken");
        try {
            GammaJavaTokenPrivateKey privateKey = (GammaJavaTokenPrivateKey)key;
            this.responceCard = this.tokenGammaJavaToken.setCertificate(privateKey.getName(), cert);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public void deleteKey(String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: deleteKey.\n", "JavaToken");
        try {
            this.responceCard = this.tokenGammaJavaToken.deleteObject(name);
            if (this.responceCard.getRetCode() == 25620 || this.responceCard.getRetCode() - 34304 == 25620) {
                this.responceCard = this.tokenGammaJavaToken.verifyPin(pass);
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.responceCard = this.tokenGammaJavaToken.deleteObject(name);
            }
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkPassword(String pass) {
        boolean retCode;
        block3: {
            retCode = true;
            try {
                this.responceCard = this.tokenGammaJavaToken.verifyPin(pass);
                if (this.responceCard.getRetCode() == 36864) break block3;
                if (this.responceCard.getRetCode() == 25620 || this.responceCard.getRetCode() - 34304 == 25620) {
                    retCode = false;
                    break block3;
                }
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            catch (CardException e) {
                throw new JCEHardwareException(e);
            }
        }
        return retCode;
    }

    @Override
    public void changePassword(String oldPass, String newPass) {
        try {
            this.responceCard = this.tokenGammaJavaToken.changePin(oldPass, newPass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkLicense() {
        return true;
    }

    @Override
    public int getFreeMemorySize() {
        short size = 0;
        try {
            this.responceCard = this.tokenGammaJavaToken.getStatus();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            size = UtilCM.byteToShort(this.responceCard.getData(), 3, 1);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return size;
    }

    @Override
    public String getSerialNumber() {
        try {
            this.responceCard = this.tokenGammaJavaToken.getStatus();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            return UtilCM.array2hex(this.responceCard.getData(), 9, 8);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public byte[] makeDH(JCEPrivateKey privateKey, byte[] publicKey, byte[] ukm) {
        throw new RuntimeException("Get DH key method not implemented for JavaToken");
    }
}

