/*
 * Decompiled with CFR 0.152.
 */
package kz.gamma.hardware.crypto.pcsc.kztoken;

import java.util.Enumeration;
import java.util.LinkedList;
import javax.smartcardio.CardException;
import kz.gamma.hardware.core.file.FileHelper;
import kz.gamma.hardware.crypto.pcsc.PcscGammaObject;
import kz.gamma.hardware.crypto.pcsc.exception.PcscException;
import kz.gamma.hardware.crypto.pcsc.kztoken.GammaKzTokenPrivateKey;
import kz.gamma.hardware.crypto.pcsc.kztoken.GammaKzTokenPublicKey;
import kz.gamma.hardware.crypto.pcsc.kztoken.KzTokenMapKeyFile;
import kz.gamma.hardware.crypto.pcsc.kztoken.TokenKzToken;
import kz.gamma.hardware.jce.JCEKeyPair;
import kz.gamma.hardware.jce.JCEPrivateKey;
import kz.gamma.hardware.jce.exception.JCEHardwareException;
import kz.gamma.hardware.jce.param.CryptoParam;
import kz.gamma.hardware.jce.param.PcscParam;
import kz.gamma.hardware.util.UtilCM;

public class KzTokenGammaObject
extends PcscGammaObject {
    private TokenKzToken tokenKzToken;
    private KzTokenMapKeyFile mapKeyFile = new KzTokenMapKeyFile();

    @Override
    public void init(CryptoParam param) {
        try {
            if (!(param instanceof PcscParam)) {
                throw new PcscException("Wrong parameter type");
            }
            this.param = (PcscParam)param;
            this.tokenKzToken = new TokenKzToken(this.param.getReaderName());
            this.checkLicense();
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        catch (PcscException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public JCEKeyPair createKey(int algType, String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: createKey.\n", "KzToken");
        JCEKeyPair ret = null;
        try {
            this.mapKeyFile.clear();
            this.responceCard = this.tokenKzToken.isContainer();
            if (this.responceCard.getRetCode() == 36864) {
                this.responceCard = this.tokenKzToken.readContainer();
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.mapKeyFile.addElements(this.responceCard.getData());
            }
            byte newId = this.mapKeyFile.getUniqueElement();
            this.mapKeyFile.addElement(name, newId);
            this.responceCard = this.tokenKzToken.verifyPin((byte)2, pass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.writeContainer(this.mapKeyFile.getElementsBuffer());
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.genKeyPair(algType, newId);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = new JCEKeyPair(new GammaKzTokenPrivateKey(name, pass, (byte)algType), new GammaKzTokenPublicKey(name, UtilCM.reverseParts(this.responceCard.getData(), 0)));
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public byte[] signature(JCEPrivateKey privateKey, byte[] hash) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: signature.\n", "KzToken");
        byte[] ret = null;
        try {
            this.mapKeyFile.clear();
            this.responceCard = this.tokenKzToken.isContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.readContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.mapKeyFile.addElements(this.responceCard.getData());
            if (!this.mapKeyFile.isNameExists(privateKey.getName())) {
                throw new IllegalArgumentException("Key not found: " + privateKey.getName());
            }
            this.responceCard = this.tokenKzToken.verifyPin((byte)2, privateKey.getPass());
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.signature(this.mapKeyFile.getIdElement(privateKey.getName()), UtilCM.inverseCopyByte(hash, 0, hash.length));
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            ret = UtilCM.reverseParts(this.responceCard.getData(), 0);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return ret;
    }

    @Override
    public Enumeration<JCEKeyPair> getKeyList(String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: getKeyList.\n", "KzToken");
        LinkedList<JCEKeyPair> ret = new LinkedList<JCEKeyPair>();
        try {
            this.mapKeyFile.clear();
            this.responceCard = this.tokenKzToken.isContainer();
            if (this.responceCard.getRetCode() == 36864) {
                this.responceCard = this.tokenKzToken.readContainer();
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                this.mapKeyFile.addElements(this.responceCard.getData());
            }
            Object[] names = this.mapKeyFile.getNamesElement();
            for (int i = 0; i < names.length; ++i) {
                String name = (String)names[i];
                if (!this.tokenKzToken.isObjectExists(this.mapKeyFile.getIdElement(name), (short)0)) continue;
                JCEKeyPair keyPair = new JCEKeyPair();
                keyPair.setPrivateKey(new GammaKzTokenPrivateKey(name, pass, this.tokenKzToken.getKeyAlgID(this.mapKeyFile.getIdElement(name))));
                this.responceCard = this.tokenKzToken.getPublicKey(this.mapKeyFile.getIdElement(name));
                if (this.responceCard.getRetCode() != 36864) {
                    throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                }
                keyPair.setPublicKey(new GammaKzTokenPublicKey(name, UtilCM.reverseParts(this.responceCard.getData(), 0)));
                if (this.tokenKzToken.isObjectExists(this.mapKeyFile.getIdElement(name), (short)2)) {
                    this.responceCard = this.tokenKzToken.getCertificate(this.mapKeyFile.getIdElement(name));
                    if (this.responceCard.getRetCode() != 36864) {
                        throw new CardException(Integer.toString(this.responceCard.getRetCode()));
                    }
                    keyPair.setCertBlob(this.responceCard.getData());
                }
                ret.add(keyPair);
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
        return UtilCM.makeEnumeration(ret.toArray());
    }

    @Override
    public void setCertificate(byte[] cert, JCEPrivateKey key) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: setCertificate.\n", "KzToken");
        try {
            GammaKzTokenPrivateKey privateKey = (GammaKzTokenPrivateKey)key;
            this.mapKeyFile.clear();
            this.responceCard = this.tokenKzToken.isContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.readContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.mapKeyFile.addElements(this.responceCard.getData());
            if (!this.mapKeyFile.isNameExists(privateKey.getName())) {
                throw new IllegalArgumentException("Key not found: " + privateKey.getName());
            }
            this.responceCard = this.tokenKzToken.verifyPin((byte)2, key.getPass());
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.setCertificate(this.mapKeyFile.getIdElement(privateKey.getName()), cert);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public void deleteKey(String name, String pass) {
        System.out.printf("Interface: APDU, PCSC. Device: %s. Method: deleteKey.\n", "KzToken");
        try {
            this.mapKeyFile.clear();
            this.responceCard = this.tokenKzToken.isContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.readContainer();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.mapKeyFile.addElements(this.responceCard.getData());
            if (!this.mapKeyFile.isNameExists(name)) {
                throw new IllegalArgumentException("Key not found: " + name);
            }
            this.responceCard = this.tokenKzToken.verifyPin((byte)2, pass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.delObject(this.mapKeyFile.getIdElement(name));
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.mapKeyFile.delElement(name);
            this.responceCard = this.tokenKzToken.writeContainer(this.mapKeyFile.getElementsBuffer());
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkPassword(String pass) {
        boolean retCode;
        block3: {
            retCode = true;
            try {
                this.responceCard = this.tokenKzToken.verifyPin((byte)2, pass);
                if (this.responceCard.getRetCode() == 36864) break block3;
                if (this.responceCard.getRetCode() == 25344) {
                    retCode = false;
                    break block3;
                }
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            catch (CardException e) {
                throw new JCEHardwareException(e);
            }
        }
        return retCode;
    }

    @Override
    public void changePassword(String oldPass, String newPass) {
        try {
            this.responceCard = this.tokenKzToken.verifyPin((byte)2, oldPass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            this.responceCard = this.tokenKzToken.changePin((byte)2, newPass);
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public boolean checkLicense() {
        try {
            this.responceCard = this.tokenKzToken.getStatus();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            byte[] data = this.responceCard.getData();
            int hId = data[1];
            int lId = data[1];
            hId = (byte)(hId & 0xF0);
            hId = (byte)(hId / 16);
            lId = (byte)(lId & 0xF);
            FileHelper fileHelper = new FileHelper();
            int deviceMajor = 0;
            int deviceMinor = 0;
            try {
                String encodedDeviceVersion = fileHelper.readResource("/kz/gamma/hardware/crypto/pcsc/kztoken/", "device.info");
                StringBuilder decodedDeviceVersion = new StringBuilder();
                String letters = "_abcdefghij";
                String digits = ".0123456789";
                for (int i = 0; i < encodedDeviceVersion.length(); ++i) {
                    int indexOfChar = letters.indexOf(encodedDeviceVersion.charAt(i));
                    if (indexOfChar == -1) {
                        throw new RuntimeException("Bad device version");
                    }
                    decodedDeviceVersion.append(digits.charAt(indexOfChar));
                }
                String[] version = decodedDeviceVersion.toString().split("\\.");
                if (version.length == 2) {
                    deviceMajor = Integer.valueOf(version[0]);
                    deviceMinor = Integer.valueOf(version[1]);
                }
            }
            catch (Throwable t) {
                deviceMajor = 0;
                deviceMinor = 0;
                t.printStackTrace();
            }
            if (deviceMajor == 0 && deviceMinor == 0) {
                deviceMajor = 1;
                deviceMinor = 4;
                System.out.printf("Default version of supported device will be used. Default version: %d.%d\n", deviceMajor, deviceMinor);
            }
            if (hId == deviceMajor && lId == deviceMinor) {
                return true;
            }
            throw new JCEHardwareException(String.format("Device with version %d.%d not supported. Supported version: %d.%d", (byte)hId, (byte)lId, deviceMajor, deviceMinor));
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public int getFreeMemorySize() {
        throw new RuntimeException("Get memory method not implemented for KzToken");
    }

    @Override
    public String getSerialNumber() {
        try {
            this.responceCard = this.tokenKzToken.getSerial();
            if (this.responceCard.getRetCode() != 36864) {
                throw new CardException(Integer.toString(this.responceCard.getRetCode()));
            }
            return UtilCM.array2hex(this.responceCard.getData(), 0, this.responceCard.getData().length);
        }
        catch (CardException e) {
            throw new JCEHardwareException(e);
        }
    }

    @Override
    public byte[] makeDH(JCEPrivateKey privateKey, byte[] publicKey, byte[] ukm) {
        throw new RuntimeException("Get DH key method not implemented for KzToken");
    }
}

